#include "header.h"

#define DB(xxx) /* fprintf(stderr, "Debug #%d", (xxx)); fflush(stdout); fflush(stderr) /**/

void greeting()
{
#ifdef MS_DOS
    clrscr();
#else
    system("clear");
#endif
    printf("\n");
    printf("Tape organizer 0.0 ---   By David Bleckmann \n ");
    printf("\n");
    printf("Created 1988 \n");
    printf("\n");
    printf("\n");
    printf("Use/modify however you wish, but please give me credit for\n");
    printf("my work.\n");
    /* and excuse me for my "ammature" programming skills :-) */
    printf("\n");
    printf("Send all criticizism/improvements to me at my UUCP/internet address:\n");
    printf("\n");
    printf("\tbleckmd@jacobs.cs.orst.edu\n");
    printf("\t{tektronix, hp-pcd}!orstcs!jacobs.cs.orst.edu!bleckmd\n");
    printf("\n");
    printf("\n");
    printf("Use 'H', 'h', or '?' for help menu\n\n");

}

main(argc, argv)
int argc;
char *argv[];
{
struct tape *t[MAX_NUM_TAPES];
int a, b, c, count;
string fname, tmp, tmp1, tmp2;
int save_tape(), get_tape(), correct();
void clr_to_null(), alpha_out();
char *decode(), *malloc();
extern int allblank();

FILE *fp;

    count=0;


#ifndef MS_DOS
    initscr();
#endif

    for (a=0; a<MAX_NUM_TAPES; a++)
	t[a]= NULL;			/*clear all tape elements to NULL*/


    switch(argc)
    {
	case 1:
	    greeting();
	    break;

	case 2:
	    if ((count=get_tape(t, argv[1])) == -1)  /* return -1 if error */
	    {
		greeting();
		fprintf(stderr, "file error\n%s not loaded.\n", argv[1]);
	    }
	    else
	    {
		greeting();
		printf("File %s Loaded\n", argv[1]);
            }
	    break;

	default:
	    fprintf(stderr,
		"Usage: %s [tapefile]\n where tapefile was created using %s\n",
		argv[0], argv[0]);

#ifndef MS_DOS
	    nocbreak();
	    endwin();
#endif
	    exit(1);
    }

    for(;;)
    {
	printf("\nCommand:");
	gets(tmp);

	switch (*tmp)  {

	case '?':
	case 'h':
	case 'H':	/*help command! (yes we have one)*/
	    printf("command list:\n");
	    printf("\t%c: read in file\n", READCOM);
	    printf("\t%c,%c: write to file\n", WR1COM, WR2COM);
	    printf("\t%c: add tape data\n", ADDCOM);
	    printf("\t%c: edit tape\n", EDITCOM);
            printf("\t%c: list tapes\n", LISTCOM);
	    printf("\t%c: print out tapes\n", PRINTCOM);
	    printf("\t%c: delete a tape\n", DELCOM);
            printf("\t%c: clear all tapes (careful!)\n", CLEARCOM);
	    printf("\t%c: order tapes\n", ORDCOM);
	    printf("\t%c: correct alpha mismatch\n", ALPHACOM);
	    printf("\t%c: quit\n", QUITCOM);
	    break;

	case READCOM:
	    printf("file to read from:");
	    gets(fname);
	    if ((a=get_tape(t, fname)) == -1)  /* returns -1 on error */
		fprintf(stderr, "file error\n");
	    else {
		count=a;
		printf("file read in: %d entries\n\n", count);
		/*gets(tmp, STR_LEN);*/
	    }
	    break;

	case WR1COM:
	case WR2COM:
	    printf("file to save to:");
	    gets(fname);
	    if (save_tape(t, fname, count)==-1)  /* return -1 on error */
		printf("Error: file not saved\n");
	    break;

	case ADDCOM:
	    printf("enter 0 to quit...\n\n");
	    for(;;)
	    {
		if (count>=MAX_NUM_TAPES)
		{
		    printf("Can't have more than %d tapes\n", MAX_NUM_TAPES-1);
		    break;
		}
		printf("tape number=");
		gets(tmp);
		if (tmp[0] == '\0' && count > 0)
		{
		    a=t[count-1]->num+1;
		    printf("%d\n", a);
		}
		else if ((a=atoi(tmp))==0)
		    break;
		t[count]=(struct tape *) malloc(sizeof(struct tape));
		t[count]->num=a;
		printf("side %c:", SIDE1CHAR);
		gets(t[count]->s1);
		printf("side %c:", SIDE2CHAR);
		gets(t[count]->s2);
		++count;	/*update current number of tapes*/
		putchar('\n');
	    }	/*end of 'a'*/
	    break;

	case EDITCOM:
	    printf("Enter tape #:");
	    gets(tmp);
	    if ((a=atoi(tmp))>0)
	    {
		for(b=0; b<count && t[b]->num!=a; b++)
		    ;
		if (b==count)
		{
		    printf("tape not found\n");
		    break;
		}
		printf("%d:\n%c: %s\n%c: %s\n\n", t[b]->num, SIDE1CHAR,
		    t[b]->s1, SIDE2CHAR, t[b]->s2);

#ifndef SIDEAB
		printf("Edit: (1) Side 1, (2) Side 2, or (3) number:");

		switch (a=atoi(gets(tmp))) {

		case 3:
		    printf("\nNew Num:");
		    if ((a=atoi(gets(tmp)))>0)
			t[b]->num=a;

		    break;

		case 2:
		case 1:
		    printf("\nNew Title for side %d:\n", a);
		    gets(Sx(t[b], a));
		    break;
		} /*end of switch*/
	        printf("%d:\n1: %s\n2: %s\n\n", t[b]->num,
		        decode(tmp1, t[b]->s1), decode(tmp2, t[b]->s2));
#else
		printf("Edit: (A) Side A, (B) Side B, or (N) number:");

		switch (a= *gets(tmp)) {

		case 'N':
		case '3':
		case 'n':
		    printf("\nNew Num:");
		    if ((a=atoi(gets(tmp)))>0)
			t[b]->num=a;

		    break;

		case 'a':
		case 'A':
		case 'b':
		case 'B':
		    a=(a=='a' || a=='A') ? 1 : 2 ;
		    printf("\nNew Title for side %c:\n", SIDECHAR(a));
		    gets(Sx(t[b], a));
		    break;
		} /*end of switch*/
	        printf("%d:\nA: %s\nB: %s\n\n", t[b]->num,
		        decode(tmp1, t[b]->s1), decode(tmp2, t[b]->s2));
#endif

	    } /*end of if (a>0)*/
	    break;

	case LIST2COM:
	    c=FALSE;
	    for(a=0; a<count; a+=SCRHT)
	    {
	      for(b=a; b<a+SCRHT && b<count; b++)
		printf("%d\t%s\n\t%s\n", t[b]->num, t[b]->s1,
				    t[b]->s2);
              if (!c && b<count)
	      {
#ifndef MS_DOS
		  cbreak();
#endif
		  printf("More (Quit, Continuous)?");
		  *tmp=getchar();
#ifndef MS_DOS
		  nocbreak();
#endif
		  putchar('\n');
		  if (*tmp=='q' || *tmp=='Q')
		      break;
		  if (*tmp=='c' || *tmp=='C')
		      c=TRUE;
              }
	    }
            break;

	case LISTCOM:
	    c=FALSE;
	    for(a=0; a<count; a+=SCRHT)
	    {
	      for(b=a; b<a+SCRHT && b<count; b++)
		printf("%d\t%s\n\t%s\n", t[b]->num, decode(tmp1, t[b]->s1),
				    decode(tmp2,t[b]->s2));
              if (!c && b<count)
	      {
#ifndef MS_DOS
		  cbreak();
#endif
		  printf("More (Quit, Continuous)?");
		  *tmp=getch();
#ifndef MS_DOS
		  nocbreak();
#endif
		  putchar('\n');
		  if (*tmp=='q' || *tmp=='Q')
		      break;
		  if (*tmp=='c' || *tmp=='C')
		      c=TRUE;
              }
	    }
            break;

        case PRINTCOM:
#ifdef MS_DOS
	    printf("Enter output device:\n(i.e. enter LPT1 to go to printer)");
#else
	    printf("Enter output file:\n");
#endif
	    printf("\n>");
	    gets(tmp);
	    if ((fp=fopen(tmp, "w")) == NULL)
	    {
		fprintf(stderr, "Cannot open file\n");
		break;
            }

            printf("\nPrint Format:\n");
	    printf("\t1: Standard output (just like '%c')\n", LISTCOM);
	    printf("\t2: Alphabetized index (num;side:Artist)\n");
	    printf("Choice:");
	    gets(tmp);

            switch (atoi(tmp)) {

            case 1:
	        for(a=0; a<count; a++)
#ifndef SIDEAB
		    fprintf(fp,
			  /*don't print side2 if there ain't any*/
			    allblank(t[a]->s2) ? "Tape %4d side 1:%s\n"
				  : "Tape %4d side 1:%s\n          side 2:%s\n",
					t[a]->num,
					decode(tmp1, t[a]->s1),
				        decode(tmp2,t[a]->s2));
#else
		    fprintf(fp,
			  /*don't print side2 if there ain't any*/
			    allblank(t[a]->s2) ? "Tape %4d side A:%s\n"
				  : "Tape %4d side A:%s\n          side B:%s\n",
					t[a]->num,
					decode(tmp1, t[a]->s1),
				        decode(tmp2,t[a]->s2));
#endif
                break;

            case 2:
		alpha_out(fp, t, count);
		break;

	    } /*end of switch*/

            fclose(fp);
            break;

	case CLEARCOM:
	    printf("Are you Sure(y/n)?");
	    gets(tmp);
	    if (*tmp=='y' || *tmp=='Y')
	        count=0;
	    break;

        case RECOVCOM:	/*undocumented way of un-'C'ing...just enter a count*/
	    printf("Debug option - set new count\nEnter new number of tapes:");
	    if ((a=atoi(gets(tmp))) != 0)
                count=a;
	    break;

        case DELCOM:	/* Delete a tape */
	    printf("Delete tape\nEnter tape #:");
	    gets(tmp);
	    if ((a=atoi(tmp))>0)
	    {
		for(b=0; b<count && t[b]->num!=a; b++)
		    ;
		if (b==count)
		{
		    printf("tape not found\n");
		    break;
		}
		printf("Tape: %d\nSide %c: %s\nSide %c: %s\nDelete (y/n)?",
			t[b]->num, SIDE1CHAR, t[b]->s1, SIDE2CHAR, t[b]->s2);
		gets(tmp);
		if (tmp[0]=='y' || tmp[0]=='Y')
		{
		    for(a=b; a<count-1; a++)
                        t[a]=t[a+1];
		    t[a]=NULL;
		    count--;
		    printf("Tape deleted.\n");
		}
		else
		    printf("Tape not deleted.\n");
            }
	    break;

        case ORDCOM:	/*order tapes*/
	    printf("\nOrder with respect to:\n");
	    printf("\t1. Number\n\t2. Alphabetized to side %c\nChoice:",
		   SIDE1CHAR);
	    gets(tmp);
	    if ((a=atoi(tmp))==1 || a==2)
	    {
                a=(a==1);	/*a is true if to be sorted numerically*/
		printf("Sorting....");
		fflush(stdout);

                do {
		    b=0;	/*time for an inefficient bubble sort :-)*/
		    for(c=0; c<count-1; c++)
		        if (a ? t[c]->num > t[c+1]->num
			      : strcmp(t[c]->s1, t[c+1]->s1) > 0)
                        {
			    struct tape *tmp;
			    tmp=t[c];
			    t[c]=t[c+1];
			    t[c+1]=tmp;
			    b=1;
		        }
		} while (b);

                printf("Done.\n");
	    }
	    break;

        case ALPHACOM:
	    printf("correct Alpha mismatch\n");
	    printf("1. Search for \"The\"\n");
	    printf("2. Name Search.\n");
	    printf("3. Specific Tape and Side.\n\n");
	    printf("Enter choice:");
	    gets(tmp);

	    switch (a=atoi(tmp)) {
	      case 1:
		strcpy(tmp, "The");
	      case 2:
		if (a!=1)
		{
		    printf("Enter name to search for:");
		    gets(tmp);
		}
		c=strlen(tmp);

		for(a=0; a<count; a++)
		  for(b=1; b<=2; b++)
		    if (strnicmp(Sx(t[a], b), tmp, c) == 0)
			if (correct(Sx(t[a], b)) == -1)
			    goto qhit;
	qhit:
                break;

              case 3:
	        printf("Enter tape number:");
	        gets(tmp);
                if ((a=atoi(tmp))<1)
	            break;

                for(c=0; t[c]->num!=a && c<count; c++)
		    ;
	        if (c==count)
	        {
		    printf("Tape not found\n");
		    break;
	        }

                printf("Enter side:");
	        gets(tmp);
		if (islower(*tmp))
		    *tmp=toupper(*tmp);

	        if (*tmp!=SIDE1CHAR && *tmp!=SIDE2CHAR)
		    break;

                correct(*tmp!=SIDE1CHAR ? t[c]->s2 : t[c]->s1);
	        break;
            } /* end of switch(a=atoi(tmp)) */
	    break;

	case QUITCOM:
	    printf("\nBye !\n");

#ifndef MS_DOS
    	    nocbreak();
	    endwin();
#endif
	    exit(0);

	default:
	    fprintf(stderr, "error???\nUse 'H' for help\n");

	}	/*end of command switch*/
    }	/*end of for(;;)*/

}	/*end of main()*/

