#include "header.h"

char *crstrip(s)	/*strips off a '\n' off the end of a string if */
char *s;   		/*there is one.				       */
{
int a;

    if (s != NULL  &&  s[a=strlen(s)-1] == '\n')
	s[a]= '\0';

    return s;
}

int get_tape(t, fname)	/*returns count or -1 if error*/
struct tape *t[];
char *fname;
{
FILE *fp;
int a, b;
string tmp;
char *malloc();

    if ((fp=fopen(fname, "r"))==NULL)
    {
	fprintf(stderr, "can't open file\n");
	return(-1);
    }
    for (a=0; t[a]!=NULL; a++)
    {
	if (fgets(tmp, 80, fp)==NULL)	/* NULL implies EOF */
	{
	    fclose(fp);
	    return(a);
	}

        if((t[a]->num=atoi(tmp)) == 0)
	{
	    fprintf(stderr, "\"%s\" not tape number\n", tmp);
	    fclose(fp);
	    return(-1);
	}
	crstrip(fgets(t[a]->s1, 80, fp));
	crstrip(fgets(t[a]->s2, 80, fp));
    }

    for(; a<MAX_NUM_TAPES && fgets(tmp, 80, fp)!=NULL; a++)
    {
        if((b=atoi(tmp)) == 0)
	{
	    t[a]=NULL;
	    fprintf(stderr, "\"%s\" not tape number\n", tmp);
	    fclose(fp);
	    return(-1);
	}
	t[a]=(struct tape *) malloc(sizeof(struct tape));
	t[a]->num=b;
	crstrip(fgets(t[a]->s1, 80, fp));
	crstrip(fgets(t[a]->s2, 80, fp));
    }
/* found EOF */
    fclose(fp);
    return(a);
}


int save_tape(t, fname, count)
struct tape *t[];
char *fname;
int count;
{
FILE *fp;
int a;

    if ((fp=fopen(fname, "w"))==NULL)
    {
	fprintf(stderr, "can't open file\n");
	return(-1);
    }
    for(a=0; a<count; a++)
	fprintf(fp, "%d\n%s\n%s\n", t[a]->num, t[a]->s1, t[a]->s2);
    fclose(fp);
    return(a);
}
