/* xalloc.h - defines for use with xalloc.c
 *
 * 18.Sep.87  jimmc  Collected into xalloc.h
 * 22.Sep.87  jimmc  Add XFREE, XALLOCD etc.
 * 21.Oct.87  jimmc  Change XALLOC to XALLOCM, XALLOCD to XALLOC etc.
 *  6.Nov.87  jimmc  call xallocm instead of xalloc, etc.
 */

#ifndef XALLOCINCLUDED
#define XALLOCINCLUDED

extern char *xalloc(), *xcalloc(), *xrealloc();
extern char *xallocm(), *xcallocm(), *xreallocm();

#define XALLOC(item, count ) (item *)xalloc(sizeof(item)*(count))
#define XCALLOC(item, count ) (item *)xcalloc(sizeof(item)*(count))
#define XREALLOC(item, old, count ) \
	(item *)xrealloc((char *)(old),sizeof(item)*(count))

#define XFREE(old) free((char *)(old));

#define XALLOCM(item, count, msg) (item *)xallocm(sizeof(item)*(count),msg)
#define XCALLOCM(item, count, msg) (item *)xcallocm(sizeof(item)*(count),msg)
#define XREALLOCM(item, old, count, msg) \
	(item *)xreallocm((char *)(old),sizeof(item)*(count),msg)
#endif

/* end */
