/* parse.c - parsing routines
 *
 * 29.Sep.87  jimmc  Code start
 *  4.Nov.87  jimmc  Add setjmp stuff
 * 30.Nov.87  jimmc  Lint cleanup
 */
/* LINTLIBRARY */

#include <stdio.h>
#include <ctype.h>
#include <strings.h>
#include "goto.h"
#include "xalloc.h"
#include "spin.h"
#include "spinparse.h"

extern char *sprintf();	/* make lint happy */

SPtoken *__tmptoken;

extern int SPtokenival;
extern float SPtokenfval;
extern char *SPtokenpval;

extern char *SPerrorstr;

char *SPprompt1 = ">";
char *SPprompt2 = ">>";

static char *parseerr="ParsingError";

SPfgets(info,t)
SPstreaminfo *info;	/* what to read from */
int t;			/* offset into linebuf */
{
char *dst, *src;
int i;

	switch (info->type) {
	case 'f':	/* file */
		fgets(info->SPlinebuf+t,info->SPlinebufsize-t,info->stream);
		if (feof(info->stream)) info->eofflag=1;
		break;
	case 's':	/* string */
		dst = info->SPlinebuf+t;
		src = info->stringget;
		if (! *src) {
			info->eofflag=1;
			*dst = 0;
			break;
		}
		for (i=0; i<info->SPlinebufsize-t; i++) {
			*dst++ = *src++;
			if (dst[-1]==0) {
				info->eofflag=1;
				break;
			}
			if (dst[-1]=='\n') {
				*dst = 0;
				break;
			}
		}
		if (i>=info->SPlinebufsize-t) *dst=0;
		info->stringget = src;
		break;
	default:	/* error */
		SPescape("BadStreamType","bad type %c in SPfgets", info->type);
		/* NOTREACHED */
	}
}

void			/* reads data info SPlinebuf in info structure */
SPgetline(info)		/* read an arbitrarily long line from the stream */
SPstreaminfo *info;	/* what to read from */
{
	int t, l;
	static char *mmsg="SP line buffer";

	if (info->SPlinebufsize==0) {
		info->SPlinebufsize = 120;	/* a starting point */
		info->SPlinebuf = XALLOCM(char,info->SPlinebufsize,mmsg);
	}
	info->SPlinebuf[info->SPlinebufsize-1]=0;
		/* set to null so we can check it */
	info->SPlinebuf[info->SPlinebufsize-2]=0;
	info->SPlinebuf[0]=0;
	t = 0;		/* first read goes into start of buffer */
	if (info->stream==stdin) {
		fputs(SPprompt1,stdout);
	}
	while (1) {	/* exit from the loop with a break statement */
		SPfgets(info,t);
		l = strlen(info->SPlinebuf+t)+t;	/* len of string */
		if (l<info->SPlinebufsize-1) {	/* buffer not full */
			/* info->SPlinebuf[l] is null char */
			if (info->SPlinebuf[l-1]=='\n'
			    && info->SPlinebuf[l-2]=='\\') {
				/* continuation line */
				t = l-2;  /* new chars overwrite backslash */
				info->SPlineno++;
				if (info->stream==stdin) {
					fputs(SPprompt2,stdout);
				}
				goto readmore;
			}
			else break;	/* done reading */
		}
		else if (info->SPlinebuf[l-1]=='\n') break;
			/* buffer full, but ends with newline, so we're done */

		/* buffer is full; expand buffer and read more */
		t = l;	/* this is where new piece should start */
		info->SPlinebufsize *=2;	/* try twice the size */
		info->SPlinebuf = XREALLOCM(char,
			info->SPlinebuf,info->SPlinebufsize,mmsg);
readmore:
		info->SPlinebuf[t]=0;
		info->SPlinebuf[info->SPlinebufsize-1]=0;
		info->SPlinebuf[info->SPlinebufsize-2]=0;
	}
/* We now have the complete line in info->SPlinebuf,
 * no matter how long it was!
 */
	info->SPlineno++;
}

void
SPparseline(info)	/* parse and execute the line in info->SPlinebuf */
SPstreaminfo *info;
{

	SPtokenize(info);	/* break the line into tokens */
	SPlistize(info);	/* convert parens into nested lists */
}

void
SPtokenize(info)
SPstreaminfo *info;
{
int t;
SPtoken *tk, *lasttk;

	SPlexinit(info);	/* init the lex parser */
	info->tokenlist = NIL;
	lasttk = NIL;
	while ((t=yylex())) {
		ALLOCTOKEN(tk)
		if (!info->tokenlist) {
			info->tokenlist = tk;
		}
		if (lasttk)
			lasttk->next = tk;
		tk->next = NIL;	/* put on end of token list */
		lasttk = tk;
		tk->type = t;
		switch (t) {
		case SPTokStr:
		case SPTokName:
			tk->value.s = XALLOCM(char,strlen(SPtokenpval)+1,
				"token string");
			strcpy(tk->value.s,SPtokenpval);
			break;
		case SPTokInt:
			tk->value.n = SPtokenival;
			break;
		case SPTokFloat:
			tk->value.f = SPtokenfval;
			break;
		default: break;
		}
	}
}

SPtoken *
SPmklist(tklist)	/* makes a balanced list, returns excess at end */
SPtoken *tklist;
{
SPtoken *prevtk, *newtk;

	prevtk = NIL;
	while (tklist) {
		switch (tklist->type) {
		case SPTokRP:	/* right paren */
		case SPTokSM:	/* semicolon */
			if (prevtk) prevtk->next = NIL;
			return tklist;
		case SPTokLP:	/* left paren - nested list */
			tklist->type = SPTokList;  /* convert type to list */
			tklist->value.l = tklist->next;
			if (!tklist->next) {	/* error */
				SPescape(parseerr,
					"open paren at end of input");
				/* NOTREACHED */
			}
			newtk = SPmklist(tklist->next);
			if (tklist->value.l == newtk) {
				tklist->value.l = NIL;
			}
			if (newtk) {
				if (newtk->type==SPTokSM) {
					tklist->next = newtk;
					newtk->type = SPTokLP;
				}
				else {
					tklist->next = newtk->next;
					FREETOKEN(newtk)  /* release the CP */
				}
			}
			else {
				tklist->next = NIL;
			}
			break;
		default:
			break;
		}
		prevtk = tklist;
		tklist = tklist->next;
	}
	return NIL;
}

void
SPlistize(info)		/* convert paren and semi tokens into lists */
SPstreaminfo *info;
{
SPtoken *tklist, *newtk;

	tklist = info->tokenlist;
	newtk = SPmklist(tklist);	/* make a balanced list */
	while (newtk && newtk->type == SPTokSM) {
		tklist->next = newtk->next;
		tklist = tklist->next;
		newtk = SPmklist(tklist);
	}
	if (newtk) {
		SPescape(parseerr,"unbalanced close parenthesis");
		/* NOTREACHED */
	}
/* make a list out of the top level */
	ALLOCTOKEN(newtk)
	newtk->type = SPTokList;
	newtk->next = NIL;
	newtk->value.l = info->tokenlist;
	info->tokenlist = newtk;
}

SPtoken *
SPparseinfo(info)
SPstreaminfo *info;
{
SPtoken *rval, *SPexeclist();

	rval = NIL;
	info->eofflag = 0;
	while (!info->eofflag) {
		SPgetline(info);	/* read in a line */
		if (!info->SPlinebuf[0]) break;	/* EOF */
		SPparseline(info);	/* parse one line */
		if (rval) FREETOKEN(rval)
		rval = SPexeclist(info->tokenlist);	/* execute it */
		if (info->stream==stdin) {
			if (rval && rval->type!=SPTokNil)
				SPprintval(stdout,rval,0);
		}
	}
	if (info->SPlinebuf) XFREE(info->SPlinebuf);
	XFREE(info);
	return rval;
}

SPtoken *		/* returns a token which is the top value from
			 * the value stack for this level. */
SPparsefile(stream)
FILE *stream;		/* where to read input from */
{
SPstreaminfo *info;

	info = XCALLOCM(SPstreaminfo,1,"stream info structure");
	info->stream = stream;
	info->type = 'f';
	return SPparseinfo(info);	/* frees info when done */
}

SPtoken *		/* same as SPparsestream */
SPparsestring(str)
char *str;
{
SPstreaminfo *info;

	info = XCALLOCM(SPstreaminfo,1,"stream info structure");
	info->string = info->stringget = str;
	info->type = 's';
	return SPparseinfo(info);	/* frees info when done */
}

int	/* returns 0 if no errors, 1 if error */
SPmainfile(stream)
FILE *stream;
{
jmp_buf jbuf;
SPtoken *rval;

	SPjbufp = jmpbuf_addr(jbuf);
	while (1) {
		if (setjmp(jbuf)) {	/* uncaught goto */
			fprintf(stderr,"Uncaught goto: %s\n", SPgotolabel);
			if (SPerrorstr) fprintf(stderr,"%s\n", SPerrorstr);
			XFREE(SPgotolabel);
			if (feof(stream)) return 1;
		}
		else {	/* normal execution */
			rval = SPparsefile(stream);
			if (rval) FREETOKEN(rval);
			if (feof(stream)) return 0;
		}
	}
}

int	/* returns 0 if no errors, 1 if error */
SPmainstring(str)
char *str;
{
jmp_buf jbuf;
SPtoken *rval;

	SPjbufp = jmpbuf_addr(jbuf);
	if (setjmp(jbuf)) {	/* uncaught goto */
		fprintf(stderr,"Uncaught goto: %s\n", SPgotolabel);
		if (SPerrorstr) fprintf(stderr,"%s\n", SPerrorstr);
		XFREE(SPgotolabel);
		return 1;	/* error executing string */
	}
	rval = SPparsestring(str);
	if (rval) FREETOKEN(rval);
	return 0;
}

/* VARARGS1 */
SPwerror(fmt,a0,a1,a2)
char *fmt;
char *a0,*a1,*a2;
{
char buf[1000];

	sprintf(buf,fmt,a0,a1,a2);
	fprintf(stderr,"Warning: %s\n",buf);
}

/* end */
