/* goto.c - subroutines used in goto (also for error goto)
 *
 *  4.Nov.87  jimmc  Initial definition
 * 30.Nov.87  jimmc  Lint cleanup
 */
/* LINTLIBRARY */

#include <strings.h>
#include "goto.h"
#include "xalloc.h"

extern char *sprintf();	/* make lint happy */

jmp_bufp SPjbufp;
char *SPgotolabel;
char *SPerrorstr;

SPgoto(label)
char *label;
{
	if (SPgotolabel) XFREE(SPgotolabel);
	SPgotolabel = XALLOC(char,strlen(label)+1);
	strcpy(SPgotolabel,label);
	longjmp(jmpbuf_ref(SPjbufp),1);
	/* NOTREACHED */
}

/* ARGSUSED */
void
SPlabel(label)	/* labels are actually handled in SPexeclist */
char *label;
{
	;	/* no value for a label statement */
}

char *
SPerrorinfo(info)
char *info;
{
int l;
char *newerrorstr;

	if (!info) return SPerrorstr;
	if (info[0]=='+') {
		if (SPerrorstr) l = strlen(SPerrorstr)+strlen(info+1)+1;
		else l = strlen(info+1)+1;
		newerrorstr = XALLOC(char,l);
		if (SPerrorstr) strcpy(newerrorstr,SPerrorstr);
		else newerrorstr[0]=0;
		strcat(newerrorstr,info+1);
	}
	else {
		l = strlen(info)+1;
		newerrorstr = XALLOC(char,l);
		strcpy(newerrorstr,info);
	}
	if (SPerrorstr) XFREE(SPerrorstr);
	SPerrorstr = newerrorstr;
	return SPerrorstr;
}

/* SPescape is an internal function used to deal with errors */
/* VARARGS2 */
SPescape(label,fmt,arg1,arg2)
char *label;		/* label to go to */
char *fmt;		/* printf-style format for error info */
char *arg1,*arg2;		/* first of printf-style args */
{
char buf[2000];

/*** this needs to be fixed up to be truly variable number of args */
	sprintf(buf,fmt,arg1,arg2);
	SPerrorinfo(buf);
	SPgoto(label);
	/* NOTREACHED */
}

SPinitgoto()
{
	SPdeffunc("goto","vs",SPgoto);
	SPdeffunc("label","vs",SPlabel);
	SPdeffunc("errorinfo","sSN",SPerrorinfo);
}

/* end */
