/* filesubs.c - file subroutines for spin
 *
 * 20.Oct.87  jimmc  Initial definition
 *  4.Nov.87  jimmc  Add print
 *  5.Nov.87  jimmc  Add setjmp stuff in sourcefile
 * 30.Nov.87  jimmc  Lint cleanup
 */
/* LINTLIBRARY */

#include <stdio.h>
#include "goto.h"
#include "spin.h"
#include "xalloc.h"

int			/* 0 if no errors */
sp_sourcefile(filename)
char *filename;
{
SPtoken *rval, *SPparsefile();
FILE *fp;
jmp_buf jbuf;
jmp_bufp oldbufp;

	fp = fopen(filename,"r");
	if (!fp) {
		SPescape("CantOpenFile","can't open file %s",filename);
		/* NOTREACHED */
	}
	oldbufp = SPjbufp;
	SPjbufp = jmpbuf_addr(jbuf);
	if (setjmp(jbuf)) {	/* got an error while processing */
		fclose(fp);	/* close the file */
		SPjbufp = oldbufp;
		longjmp(jmpbuf_ref(SPjbufp),1);	/* continue up */
		/* NOTREACHED */
	}
	rval = SPparsefile(fp);
	fclose(fp);
	FREETOKENLIST(rval)
	SPjbufp = oldbufp;
	return 0;
}

int			/* 0 if no errors */
sp_sourcestring(string)
char *string;
{
SPtoken *rval, *SPparsestring();

	rval = SPparsestring(string);
	FREETOKENLIST(rval)
	return 0;
}

sp_print(v)
SPtoken *v;
{
	SPprintval(stdout,v,0);
}

SPinitfile()
{
	SPdeffunc("sourcefile","is",sp_sourcefile);
	SPdeffunc("sourcestring","is",sp_sourcestring);
	SPdeffunc("print","vV",sp_print);
}

/* end */
