.TH SETS L "December 3, 1987" "" "Local UNIX Programmer's Manual"
.UC 4
.SH NAME
sets \- performs set operations on its arguments
.SH SYNOPSIS
.B sets
[-p] e1 e2 ... en [\-u] [\-d] [\-i] e1 e2 ... en
.br
.SH DESCRIPTION
.I Sets
prints on the standard output stream the result of a 
.B single
set operation on
two sets of elements provided on the command line.
The sets are separated by the operator flag.
The program collects the elements for each set, removes
duplicated elements, and then performs the set operation.
.PP
.I Sets
performs three set operations:
.TP
.B "e1 e2 ... en \-u[nion] e1 e2 ... en"
prints the union of the two sets;
.TP
.B "e1 e2 ... en \-d[ifference] e1 e2 ... en"
prints the set difference
.I "e1 e2 ... en"
\- 
.I "e1 e2 ... en;"
.TP
.B "e1 e2 ... en \-i[ntersection] e1 e2 ... en"
prints the intersection of the two sets.
.PP
As
.I sets
is intended to be used on filenames it ignores leading pathnames
in the set operations.
The
.B \-p
flag makes pathnames significant in membership tests.
.SH "USAGE"
.PP
.I Sets
is most useful for restricting the files to be processed by some
other command.
For example, to
.I grep
all files in a directory except the object files you might use:
.TP
grep string `sets * -d *.o`
.PP
Since by default leading pathnames are ignored,
.I sets
can be used across directories \- for example, to list files
with the same names in two directories:
.TP
sets ../* -i *
.PP
Note that full pathnames are included in the output.
As a result the relative position
of the sets on the command line is significant.
The above command will print all matching names with a leading "../".
If the position of the sets is reversed only the filenames will be printed.
.SH "FILES"
.PP
/usr/local/sets
.br
/usr/src/local/sets.c
.\" .SH "SEE ALSO"
.\" .SH "DIAGNOSTICS"
.\" .SH "BUGS"
.SH "AUTHOR"
.PP
Chris Tweed
