/* LINTLIBRARY */
#include <stdio.h>
#include <ctype.h>
/*
	getword(string,ioptr) is equivalent to fscanf(ioptr,"%s",string)
	but much faster.  It returns a NULL pointer on EOF or the end
	of the string when one is found.  The return result can be used
	to find the length of the obtained string.
*/

char *
getword (string, ioptr)
register	char	*string;
register	FILE	*ioptr;
	{
	register	int 	C;
	while ((C = getc (ioptr)) != EOF && isspace (C));
	if (C == EOF) return (NULL);
	do
		{
		*string++ = C;
	} while ((C = getc (ioptr)) != EOF && !isspace (C));
	*string = '\0';
	return (string); /* pointer to the end of string */
	}
