/* LINTLIBRARY */
/*
	These are simple versions of the curses(3) screen handling functions.
	Tiny curses does not support windows or screen optimization,
	so they are simply a high level interface to the termcap(3) functions.
*/

static	char	sccsid[] = "@(#) Tiny_Curses 1.0 (WangInst) Feb 24 85";
#include "curses.h"

#include <sgtty.h>
static	struct	sgttyb	Savetty;  /* save tty state here */
static	struct	sgttyb	Curtty;   /* current tty state here */

#include <signal.h>

extern	char	*getenv ();
extern	char	*tgetstr ();
extern	char	*tgoto ();

static
int
outchar (c) /* static fun used to output characters by termcap */
register	int 	c;
	{
	putc (c, stdout);
	}

int 	LINES;     /* number of lines */
int 	COLS;      /* number of columns */

/* these external variables are used by termcap functions */
char	PC;       /* padding character */
char	*BC;      /* backspace */
char	*UP;      /* up */
short	ospeed;   /* output speed */

/* terminal capabilities strings stored for efficiency */
static	char	*CD;	/* clear to end of display */
static	char	*CE;	/* clear to end of line */
static	char	*CL;	/* clear line */
static	char	*AL;	/* add (insert) line */
static	char	*DL;	/* delete line */
static	char	*CM;	/* cursor movement */
static	char	*VB;	/* visible bell */
static	char	*SO;	/* stand out */
static	char	*SE;	/* stand end */
static	char	*IC;	/* insert char */
static	char	*IM;	/* enter insert char mode */
static	char	*EI;	/* end insert mode */
static	char	*DC;	/* delete char */
static	char	*DM;	/* enter delete char mode */
static	char	*ED;	/* end delete mode */
static	char	*US;	/* underscore */
static	char	*UE;	/* underend */

/*FUN .FN void refresh () "flush output to screen */
void
refresh ()
	{
	(void) fflush (stdout);
	}

/*FUN .FN void setterm "(char *name)" "set terminal capabilities */
void
setterm (name)
char	*name;
	{
	char	Termcap[1024];         /* termcap entry stored here */
	static	char	Abuf[BUFSIZ];  /* capabilities stored here */
	char	*area = Abuf;
	char	*ptr;
	if (name == NULL) return;
	if (tgetent (Termcap, name) != 1) return;
	BC = tgetstr ("bc", &area);
	ptr = tgetstr ("pc", &area);
	if (ptr && *ptr) PC = *ptr;
	UP = tgetstr ("up", &area);
	COLS = tgetnum ("co");
	LINES = tgetnum ("li");
	AL = tgetstr ("al", &area);
	CD = tgetstr ("cd", &area);
	CE = tgetstr ("ce", &area);
	CL = tgetstr ("cl", &area);
	CM = tgetstr ("cm", &area);
	DC = tgetstr ("dc", &area);
	DL = tgetstr ("dl", &area);
	DM = tgetstr ("dm", &area);
	ED = tgetstr ("ed", &area);
	EI = tgetstr ("ei", &area);
	IC = tgetstr ("ic", &area);
	IM = tgetstr ("im", &area);
	SE = tgetstr ("se", &area);
	SO = tgetstr ("so", &area);
	UE = tgetstr ("ue", &area);
	US = tgetstr ("us", &area);
	VB = tgetstr ("vb", &area);
	}

/*FUN .FN void crmode () "put tty in cbreak mode */
void
crmode ()
	{
	Curtty.sg_flags |= CBREAK;
	(void) stty (0, &Curtty);
	}

/*FUN .FN void nocrmode () "take tty out of cbreak mode */
nocrmode () /* out of cbreak mode */
	{
	Curtty.sg_flags &= ~CBREAK;
	(void) stty (0, &Curtty);
	}

/*FUN .FN void raw () "put tty in raw mode */
void
raw ()
	{
	Curtty.sg_flags |= RAW;
	(void) stty (0, &Curtty);
	}

/*FUN .FN void noraw () "take tty out of raw mode */
void
noraw ()
	{
	Curtty.sg_flags &= ~RAW;
	(void) stty (0, &Curtty);
	}

/*FUN .FN void echo () "have tty echo input characters */
void
echo ()
	{
	Curtty.sg_flags |= ECHO;
	(void) stty (0, &Curtty);
	}

/*FUN .FN void noecho () "have tty echo not input characters */
void
noecho ()
	{
	Curtty.sg_flags &= ~ECHO;
	(void) stty (0, &Curtty);
	}

/*FUN .FN void resetty () "reset tty to stored state */
void
resetty ()
	{
	(void) stty (0, &Savetty);
	}

/*FUN .FN void savetty () "save tty state */
void
savetty ()
	{
	(void) gtty (0, &Savetty);
	}

/*FUN .FN void standout () "begin highlighted text */
void
standout ()
	{
	tputs (SO, 1, outchar);
	}

/*FUN .FN void standend () "end highlighted text */
void
standend ()
	{
	tputs (SE, 1, outchar);
	}

/*FUN .FN void underscore () "begin underscored text */
void
underscore ()
	{
	tputs (US, 1, outchar);
	}

/*FUN .FN void underend () "end underscored text */
underend ()
	{
	tputs (UE, 1, outchar);
	}

/*FUN .FN void beep () "visible bell or at least beep */
void
beep ()
	{
	if (VB && *VB)
		tputs (VB, 1, outchar);
	else outchar ('\007');
	}

/*FUN .FN void clear () "clear screen */
void
clear ()
	{
	tputs (CL, LINES, outchar);
	}

/*FUN .FN void clrtoeol () "clear to end of line */
void
clrtoeol ()
	{
	tputs (CE, 1, outchar);
	}

/*FUN .FN void clrtobot () "clear to bottom of screen */
void
clrtobot ()
	{
	tputs (CD, LINES, outchar);
	}

/*FUN .FN void delch () "delete the character under the cursor */
void
delch ()
	{
	tputs (DM, 1, outchar);
	tputs (DC, 1, outchar);
	tputs (ED, 1, outchar);
	}

/*FUN .FN void deleteln () "delete the current line */
void
deleteln ()
	{
	tputs (DL, LINES, outchar);
	}

/*FUN .FN void insch "(int c)" "insert character */
void
insch (c)
int 	c;
	{
	tputs (IM, 1, outchar);
	tputs (IC, 1, outchar);
	outchar (c);
	tputs (EI, 1, outchar);
	}

/*FUN .FN void insertln () "insert line */
void
insertln ()
	{
	tputs (AL, LINES, outchar);
	}

/*FUN .FN void move "(int y, x)" "move to line=y col=x (zero origin) */
void
move (y, x)
register	int 	y;
register	int 	x;
	{
	if (y < 0 || x < 0) return;
	if (y >= LINES || x >= COLS) return;
	tputs (tgoto(CM,x,y), 1, outchar);
	}

/*FUN .FN void endwin () "reset tty to old parameters */
void
endwin ()
	{
	(void) resetty ();
	}

static
die () /* static function used to die gracefully */
	{
	(void) signal (SIGINT, SIG_IGN);
	beep ();
	move (LINES-1, 0);
	clrtoeol ();
	endwin ();
	exit (1);
	}

/*FUN .FN void initscr () "initialize screen */
void
initscr ()
	{
	extern 	die ();
	(void) savetty ();
	(void) gtty (0, &Curtty);
	Curtty.sg_flags &= ~XTABS;
	(void) stty (0, &Curtty);
	ospeed = Savetty.sg_ospeed;
	(void) setterm (getenv ("TERM"));
	(void) signal (SIGINT, die);
	}
