#include <stdio.h>
#include <sys/types.h>
#include <string.h>
#include <time.h>
#include <utmp.h>


#define	 OWTMP_FILE		"/usr/adm/acct/nite/owtmp"		/* file to search after /etc/wtmp */

#define  LINE_FIELD_LEN		12					/* magic numbers courtesy of /usr/include/utmp.h */
#define  USER_FIELD_LEN		 8

static char *prog;
static char *wtmpfile[] = { OWTMP_FILE, WTMP_FILE, NULL };

struct list {
		struct utmp rec;
		struct list *next;
		struct list *previous;
};



main(argc, argv)			/* last: show recent logins in last-to-first order */
int argc;
char *argv[];
{
	int    i;
	void   prproc();
	struct list *listp = NULL, *p, *addlist();
	struct utmp *entry;
	extern void utmpname();
	extern struct utmp *getutent();

	prog = argv[0];

	for (i = 0; wtmpfile[i] != NULL; i++) {
		utmpname(wtmpfile[i]);
		while ((entry = getutent()) != NULL)
			listp = addlist(listp, entry);
	}

	/* listp points to most recent wtmp entry */

	for (p = listp; p != NULL; p = p->previous)
		if (p->rec.ut_type == USER_PROCESS) {
			if (argc == 1)
				prproc(p, listp);
			else
				for (i = 1; i < argc; i++) {
					if (strncmp(p->rec.ut_user, argv[i], USER_FIELD_LEN) == 0) {
						prproc(p, listp);
						break;
					}
				}
		}

	return (0);
}



struct list *addlist(head, wtmp)	/* add new wtmp entry to head of list */
struct list *head;
struct utmp *wtmp;
{
	void	 errexit();
	register struct list *new;
	extern	 char *malloc();

	if ((new = (struct list *) malloc(sizeof(struct list))) == NULL)
		errexit("memory error", NULL);
	else {
		new->rec = *wtmp;
		new->next = new;		/* no next yet */
		new->previous = head;
		if (head != NULL)
			head->next = new;
	}
	return (new);
}



void prproc(start, last)		/* print entries for process */
struct list *start, *last;
{
	void	 prentry();
	register struct list *p;

	prentry(start->rec);
	for (p = start->next; p != last; p = p->next)
		if (p->rec.ut_pid == start->rec.ut_pid)
			prentry(p->rec);
	putchar('\n');
}


	
void prentry(wtmp)			/* print wtmp entry */
struct utmp wtmp;
{
	static char *wkday[] = { "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat" };
	static char *month[] = { "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec" };

	char   line[LINE_FIELD_LEN + 1], user[USER_FIELD_LEN + 1];
	struct tm *time;
	extern struct tm *localtime();

	strncpy(line, wtmp.ut_line, LINE_FIELD_LEN);
	strncpy(user, wtmp.ut_user, USER_FIELD_LEN);
	line[LINE_FIELD_LEN] = user[USER_FIELD_LEN] = '\0';
	time = localtime(&wtmp.ut_time);
	switch (wtmp.ut_type) {
	case USER_PROCESS:
		printf("%-*s %-*s %s %s %2d %02d:%02d", USER_FIELD_LEN, user, LINE_FIELD_LEN, line,
			wkday[time->tm_wday], month[time->tm_mon], time->tm_mday, time->tm_hour, time->tm_min);
		break;
	case DEAD_PROCESS:
		printf("  -  %02d:%02d %s", time->tm_hour, time->tm_min, wkday[time->tm_wday]);
		break;
	default:
		sprintf(line, "%d", wtmp.ut_type);
		errexit("illegal wtmp.ut_type entry:", line);
	}
}



void errexit(s1, s2)			/* print error message and die */
char s1[], s2[];
{
	extern void exit();

	fprintf(stderr, s2 == NULL ? "%s: %s\n" : "%s: %s %s\n", prog, s1, s2);
	exit(-1);
}
