static char rcsid[] = "$Header: rs.c,v 2.2 85/02/25 10:35:48 don Exp $";

/* $Log:	rs.c,v $
 * Revision 2.2  85/02/25  10:35:48  don
 * 1.  Optimized kill and line wrap routines.
 * 2.  Added defines for LPR & VI.
 * 3.  Added more RSINIT options. (A & D)
 * 4.  Deleted add_calendar routine, now uses add_reminders.
 * 5.  Added comments.
 * 
 * Revision 2.1  85/01/28  17:03:56  don
 * 1. Added new notes file - .rsnotes | command rs -n
 * 2. Added new alternate file - user defined via setenv RSALT | command rs -A
 * 3. Added environment variable RSINIT.
 *    setenv RSINIT 'ad' | a = display after add | d = display after delete.
 * 4. Lines may now be 256 char. long.
 * 5. Long lines will automatically wrap like 'vi'.
 * 6. Added search command. | rs -s 'search string'
 * 7. Help deleted, replaced with 'usage' message.
 * 8. Misc. optimizations.
 * 
 * Revision 1.3  85/01/15  09:17:57  don
 * 1. Added $Log line for RCS.
 * 2. Fixed help message.
 * 3. Coded in range deletion.
 *  */

/*	Program	written by:	Don Joslyn
 *				Nova University Computer Center
 *				3301 College Avenue
 *				Fort Lauderdale, Florida 33314
 *				(305) 475-7630 (novavax!don)
 *
 *	Copyright (C) 1985 by	Nova University, Don Joslyn
 *
 *	The rs program was written under and for BSD 4.2
*/

#include	<stdio.h>
#include	<ctype.h>
#include	<strings.h>

#define		MAXLEN   256	/* Max. Length of a single line     */
#define		MAXLINES 500	/* Max. number of lines (reminders) */

#define		CALENDAR "/calendar"	/* calendar file */
#define		RSFILE	 "/.reminders"	/* reminder file */
#define		RSNOTES  "/.rsnotes"	/* notes    file */

#define		LPR	"/usr/ucb/lpr"	/* location of lpr */
#define		VI	"/usr/ucb/vi"	/* location of vi  */

FILE	*fp,
	*fptmp;

char	fname[128],
	line[MAXLEN],
	s[MAXLEN],
	sstr[80],
	cmd[128],
	entity[128],
	*fun;

char	*getenv(),
	*mktemp();

char	rstmp[]= "/tmp/rsXXXXXX";	/* name of temp. file during delete */

int	adisplay = 0,	/* display reminders after additions (default = no) */
	ddisplay = 0,	/* display reminders after deletions (default = no) */
	Adisplay = 0,	/* display notes/alt after additions (default = no) */
	Ddisplay = 0,	/* display notes/alt after deletions (default = no) */
	rem_work = 1,	/* working on reminder file by default */
	search = 0,	/* search option seen on command line */
	status;		/* Hold status returned by sys calls and such */

main(argc, argv)
int	argc;
char	*argv[];

{ 

char	*env;		/* Hold for RSINIT environment variable */

/* Get RSINIT environment variable to find options desired */

env = getenv("RSINIT");

if (index(env, 'd'))
	ddisplay++;	/* user wants reminders displayed after deletions */
if (index(env, 'a'))
	adisplay++;	/* user wants reminders displayed after additions */
if (index(env, 'D'))
	Ddisplay++;	/* user wants notes/alt displayed after deletions */
if (index(env, 'A'))
	Adisplay++;	/* user wants notes/alt displayed after additions */

/* Get users HOME directory and construct default name for reminder file */

sprintf(fname, "%s%s", getenv("HOME"), RSFILE);
strcpy(entity, "Reminders");

/* Find out what the user wants to do */

while ( --argc > 0 && (*++argv)[0] == '-')
	for (fun = argv[0]+1; *fun != '\0'; fun++)
		switch(*fun) {
		case 'A' :	/* Work on Alternate reminder file */
			env = getenv("RSALT");
			if (!env)
			{
				printf("RSALT not defined\n");
				exit(1);
			}
			else
			{
			sprintf(fname, "%s/.%s", getenv("HOME"), env);
			strcpy(entity, env);
			if (islower(entity[0]))
				entity[0] = toupper(entity[0]);
			rem_work = 0;
			break;
			}

		case 'a' :	/* Add reminder(s)/note(s)/alternate(s) */
			add_reminder();
			exit(0);

		case 'c' :	/* Add entries to calendar file */
			sprintf(fname, "%s%s", getenv("HOME"), CALENDAR);
			strcpy(entity, "Calendar commands");
			rem_work = 0;
			add_reminder();
			exit(0);

		case 'd' :	/* Delete reminder(s)/note(s)/alternate(s) */
			delete_reminder(argc, argv);
			exit(0);

		case 'k' :	/* Kill all reminders/notes/alternates */
			if ( unlink(fname) == 0)
			{
				printf("%s killed.\n", entity);
			}
			exit(0);

		case 'n' :	/* Work on notes file */
			sprintf(fname, "%s%s", getenv("HOME"), RSNOTES);
			strcpy(entity, "Notes");
			rem_work = 0;
			break;

		case 'p' :	/* print reminders/notes/alternates */
			sprintf(cmd, "%s %s", LPR, fname);
			status = system(cmd);

			if (status == 0)
			{
				printf("%s will be printed.\n", entity);
				exit(0);
			}
			else
			{
				printf("%s can't be printed, sorry\n", entity);
				exit(1);
			}

		case 's' :	/* search for string in reminders/notes/alts */
			argc--;
			argv++;
			sprintf(sstr, "%s", argv[0]);
			search++;
			break;
		case 'v' :	/* Edit reminders/notes/alternates with vi */
			sprintf(cmd, "%s %s",VI,fname);
			system(cmd);
			exit(0);
		default:	/* Give em some help */
			printf("Usage: rs [ -Aacknpv ] [ -s search_string ] [ -d # ] [ -d #-# ]\n");
			printf("For additional information type:  man rs\n");

		/* You can enable this stuff if you want! */
		/*	printf("Reminder Service commands:\n\n");
			printf("-A	Work on Alternate reminder file.\n");
			printf("-a	Add reminder(s)/note(s)/Alt(s).\n");
			printf("-c	Add line(s) to the calendar file.\n");
			printf("-d	Delete reminder(s)/note(s)/Alt(s).\n");
			printf("-k	Kill all reminders/notes/Alternate.\n");
			printf("-n	Work on notes.\n");
			printf("-p	Print reminders/notes/Alternates.\n");
			printf("-s	Search for string.\n");
			printf("-v	Edit reminders/notes/Alt with Vi.\n\n");
			printf("rs with no option will display reminders.\n");
			printf("SEE ALSO rs(1)\n");
		*/
			exit(0);
		}

print_reminders();

}


/* ADD REMINDERS */
/* This routine uses cat to add lines to the reminder/note/alternate file */
/* If you don't like it, add your own getline routine! */

add_reminder()
{

	printf("Enter %s then ^d to exit:\n", entity);

	sprintf(cmd, "%s %s","/bin/cat >>",fname);
	system(cmd);
	if ( (adisplay && rem_work) || (Adisplay && !rem_work) )
		print_reminders();
}


/* DELETE REMINDERS/NOTES/ALTERNATES */

delete_reminder(argc, argv)
	int	argc;
	char	*argv[];
{


	int	begin,
		end,
		delete_line[MAXLINES];

	char	a[4], b[4];

	register int	i	    = 0,
			j	    = 0,
			deleted     = 0,
			line_number = 0,
			printed     = 0;


	argc--, argv++;
	for (;argc > 0; argc--, argv++)
	{
		if (alldigits(*argv))
		{
			delete_line[atoi(*argv)] = 1;
		}


		else
		{
			i = rindex(*argv, '-');
			sscanf(i+1, "%s", b );
			j = ( strlen(*argv) - strlen(b) ) - 1;
			strncpy(a, *argv, j);
			a[j]='\0';
			begin = atoi(a);
			end   = atoi(b);

			if (begin < end)
			{
				for (j = begin ; j < end+1 ; j++)
					delete_line[j] = 1;
			}
			else
			{
				printf("Illegal range specified.\n");
				exit(1);
			}
		}
	}


	mktemp(rstmp);
	if ((fptmp = fopen(rstmp,"w")) == NULL)
	{
		print_open_error_exit(rstmp);
	}


	if ((fp = fopen(fname,"r")) == NULL)
	{
		print_open_error_exit(fname);
	}


	while (getline(s, MAXLEN) > 0)
	{
		if (delete_line[++line_number] != 1)
		{
			fprintf(fptmp,"%s",s);
			printed++;
		}


		else
		{
			deleted++;
		}
	}


	fclose(fp);
	fclose(fptmp);

	status = unlink(fname);
	if (status != 0)
	{
		printf("Can't remove file - %s", fname);
		exit(1);
	}

	if (printed)
	{
		if ((fp = fopen(fname,"w")) == NULL)
		{
			print_open_error_exit(fname);
		}

		if ((fptmp = fopen(rstmp,"r")) == NULL)
		{
			print_open_error_exit(rstmp);
		}

		while (fgets(line, MAXLEN, fptmp) != NULL)
		{
			fputs(line, fp);
		}

	}

	fclose(fp);
	fclose(fptmp);
	status = unlink(rstmp);


	if (deleted)
	{

		printf("%d %s deleted.\n",
			deleted, entity );
	}
	if ( (ddisplay && rem_work) || (Ddisplay && !rem_work) )
		print_reminders();
}


/* PRINT REMINDERS/NOTES/ALTERNATES */
/* This routine will print reminders/notes/alternates */
/* If a line is longer than 75 characters, print_line is called which does */
/* auto wrap.  If a search argument was given, only lines that contain the */
/* search string will be printed. */

print_reminders()
{

	register int line_number = 0;

	if ((fp = fopen(fname,"r")) == NULL)
	{
		exit(0);
	}


	printf("\n%s:\n", entity);

	while (getline(s, MAXLEN) > 0)
	{
		if (search)
		{
			if (instr(s, sstr) != -1)
			{
				if ( strlen(s) > 75 )
				{
					printf("%3d. ", ++line_number);
					print_line(s);
				}
				else
					printf("%3d. %s",++line_number,s);
			}
			else
				line_number++;
		}
		else
		if ( strlen(s) > 75 )
		{
			printf("%3d. ", ++line_number);
			print_line(s);
		}
		else
			printf("%3d. %s",++line_number,s);
	}


	printf("\n");


	fclose(fp);

}


getline(s, lim)
char s[];
int  lim;
{

	register int i = 0;
	register int c;


	while (--lim > 0 && (c=getc(fp)) != EOF && c != '\n')
	{
		s[i++] = c;
	}

	if (c == '\n')
	{
		s[i++] = c;
	}

	s[i] = '\0';

	return(i);
}


alldigits(s)
	register char *s;
{
register c = *s++;

	do
	{
	if (!isdigit(c))
		return(0);
	 }
	 while (c = *s++);
		return(1);
}

instr(s, t)
char s[], t[];
{
	register int i, j, k;

	for (i = 0; s[i] != '\0' ; i++)
	{
		for (j=i, k=0 ; t[k] != '\0' && s[j]==t[k] ; j++ , k++)
			;
		if (t[k] == '\0')
			return(i);
	}
	return(-1);
}

print_open_error_exit(file_name)
char	file_name[];
{
	printf("Can't open file - %s\n",file_name);
	exit(1);
}

/* This routine will wrap lines greater than 75 characters long.      */
/* An attempt is made to break the line up after a word.  If a "word" */
/* is greater than 75 characters, the line does not look so hot.      */
/* There must be a better way to do this.  If you have time to play   */
/* and find a better way, please let me know. */

print_line(long_line)
char	long_line[];
{

register int	a,z,x,m;

m = strlen(long_line);
z = -1;
while ( z < m )
{
	x = ++z;
	z += 74;
	if ( z < m)
		for ( ; long_line[z] != ' ' && (z != x) ; z--) ;
	else
		z = m;
	for (a=x ; a < z ; a++)
		putchar(long_line[a]);
	if ( z < m )
		printf("\n     ");
}
}
