/****************************************************************

Module:
	HP main module

Description:
	interactive loop


Modification history:

	0.0	hjp	89-06-26

		initial version

	0.1	hjp	89-07-25

		main greatly simplified by replacement of switch (obj->id)
		through interprete (obj, 1);

	0.2	hjp	89-12-11

		FPE handling added.

	0.3	hjp	90-03-06

		Stack length, profiling and clearmem excluded for 
		non-Turbo-C environment.

****************************************************************/


#include <signal.h>
#include <stdio.h>
#include <string.h>

#include "rpl.h"
#include "globvar.h"
#include "intcmd.h"
#include "parser.h"
#include "debug.h"

#ifdef __TURBOC__
uint _stklen = 0x4000;	/*	16 k Bytes of stack	*/
#endif

main (int argc, char ** argv)
{
	genobj * obj;

#ifdef __TURBOC__
	if (! strcmp (argv [1], "-p")) {
		prof_start (argv [0]);
	}
#endif

	/*	clear memory so that MemMap will work right	*/

#ifdef __TURBOC__
	clearmem (0x8000);
#endif

	/*	set up floating point exception handler	*/

	signal (SIGFPE, fpehandler);
	signal (SIGINT, inthandler);

	for (;;) {
		setjmp (main_loop);
		obj = readvalue ();
		if (obj) {
			interprete (obj, 1);
			obj->link ++;		/* destroy original instance of object	*/
			destroy (obj, 1);
		} else {
			empty = 1;
			printstack ();
		}
	}
}

