/****************************************************************

	RealCmd	--	Commands for manipulating real objects.
			(The REAL menu on HP28)

0.0	hjp	90-03-04

	initial version

****************************************************************/

#include <stdlib.h>

#include "arithcmd.h"
#include "errors.h"
#include "globvar.h"
#include "intcmd.h"
#include "realcmd.h"
#include "rpl.h"
#include "stackcmd.h"


/*
	MAXR	--	push maximum real number

	-> REAL
*/

void	c_maxr (void)
{
	push (&real_max);
}


/*
	MINR	--	push minimum positive real number

	-> REAL
*/

void	c_minr (void)
{
	push (&real_min);
}


/*
	ABS	--	absolute value of argument

	REAL	->	REAL
	COMPLEX	->	REAL
*/

void c_abs (void)
{
	genobj		* a;
	realobj 	* c;

	if (! stack) {
		error ("ABS", ERR_2FEWARG);
		return;
	}

	if ((a = stack->obj)->id == REAL) {
		if (!(c = mallocobj (REAL)))
		{
			error ("ABS", ERR_NOMEM);
			return;
		}
		((realobj *)c)->val = fabs(((realobj *) a)->val);
		c_drop ();
		push (c);
	} else if (a->id == COMPLEX) {

		if (!(c = mallocobj (REAL)))
		{
			error ("ABS", ERR_NOMEM);
			return;
		}
		c->val = cabs (((complexobj *) a)->val);
		c_drop ();
		push (c);
	} else {
		error ("ABS", ERR_WRTYPE, id2str (a->id));
	}
}


/*
	SIGN	--	sign of argument

	REAL	->	REAL
	COMPLEX	->	COMPLEX
*/

void c_sign (void)
{
	genobj		* a;

	if (! stack) {
		error ("SIGN", ERR_2FEWARG);
		return;
	}

	if ((a = stack->obj)->id == REAL && ((realobj *)a)->val == 0.0) {
		c_drop ();
		push (& real_zero);
	} else if (a->id == COMPLEX && ((complexobj *) a)->val.x == 0.0 && ((complexobj *) a)->val.y == 0.0) {
		c_drop ();
		push (& complex_zero);
	} else {
		c_dup ();
		c_abs ();
		c_div ();
	}
}


/*
	IP	--	integer part of argument

	REAL	->	REAL
*/

void c_ip (void)
{
	genobj		* a;
	realobj		* r;
	double		x;

	if (! stack) {
		error ("IP", ERR_2FEWARG);
		return;
	}

	if ((a = stack->obj)->id == REAL) {
		if (!(r = mallocobj (REAL)))
		{
			error ("IP", ERR_NOMEM);
			return;
		}
		modf (((realobj *) a)->val, & x);
		((realobj *)r)->val = x;
		c_drop ();
		push (r);
	} else {
		error ("IP", ERR_WRTYPE, id2str (a->id));
	}
}




/*
	FP	--	fractional part of argument

	REAL	->	REAL
*/

void c_fp (void)
{
	genobj		* a;
	realobj		* r;
	double		x;

	if (! stack) {
		error ("FP", ERR_2FEWARG);
		return;
	}

	if ((a = stack->obj)->id == REAL) {
		if (!(r = mallocobj (REAL)))
		{
			error ("FP", ERR_NOMEM);
			return;
		}
		((realobj *)r)->val = modf (((realobj *) a)->val, & x);
		c_drop ();
		push (r);
	} else {
		error ("FP", ERR_WRTYPE, id2str (a->id));
	}
}




/*
	FLOOR	--	round to nearest integer smaller than argument.

	REAL	->	REAL
*/

void c_floor (void)
{
	genobj		* a;
	realobj		* r;

	if (! stack) {
		error ("FLOOR", ERR_2FEWARG);
		return;
	}

	if ((a = stack->obj)->id == REAL) {
		if (!(r = mallocobj (REAL)))
		{
			error ("FLOOR", ERR_NOMEM);
			return;
		}
		((realobj *)r)->val = floor (((realobj *) a)->val);
		c_drop ();
		push (r);
	} else {
		error ("FLOOR", ERR_WRTYPE, id2str (a->id));
	}
}




/*
	CEIL	--	round to nearest integer greaterthan argument.

	REAL	->	REAL
*/

void c_ceil (void)
{
	genobj		* a;
	realobj		* r;

	if (! stack) {
		error ("CEIL", ERR_2FEWARG);
		return;
	}

	if ((a = stack->obj)->id == REAL) {
		if (!(r = mallocobj (REAL)))
		{
			error ("CEIL", ERR_NOMEM);
			return;
		}
		((realobj *)r)->val = ceil (((realobj *) a)->val);
		c_drop ();
		push (r);
	} else {
		error ("CEIL", ERR_WRTYPE, id2str (a->id));
	}
}




/*
	MOD	--	remainder.

	x	y	->	x % y.

	REAL	REAL	->	REAL
*/

void c_mod (void)
{
	genobj		* a, * b;
	realobj		* r;

	if (! stack || ! stack->next) {
		error ("MOD", ERR_2FEWARG);
		return;
	}

	if ((b = stack->obj)->id == REAL && (a = stack->next->obj)->id == REAL) {
		double	x = ((realobj *) a)->val,
			y = ((realobj *) b)->val;

		if (!(r = mallocobj (REAL)))
		{
			error ("MOD", ERR_NOMEM);
			return;
		}
		((realobj *)r)->val = x - y * floor (x / y);
		c_drop ();
		c_drop ();
		push (r);
	} else {
		if (a->id != REAL) error ("MOD", ERR_WRTYPE, id2str (a->id));
		if (b->id != REAL) error ("MOD", ERR_WRTYPE, id2str (b->id));
	}
}


/*
	MAX	--	returns larger of to numbers.

	x	y	->	x % y.

	REAL	REAL	->	REAL
*/

void c_max (void)
{
	genobj		* a, * b;
	realobj		* r;

	if (! stack || ! stack->next) {
		error ("MAX", ERR_2FEWARG);
		return;
	}

	if ((b = stack->obj)->id == REAL && (a = stack->next->obj)->id == REAL) {
		if (!(r = mallocobj (REAL)))
		{
			error ("MAX", ERR_NOMEM);
			return;
		}
		((realobj *)r)->val = max (((realobj *) a)->val, ((realobj *) b)->val);
		c_drop ();
		c_drop ();
		push (r);
	} else {
		if (a->id != REAL) error ("MAX", ERR_WRTYPE, id2str (a->id));
		if (b->id != REAL) error ("MAX", ERR_WRTYPE, id2str (b->id));
	}
}


/*
	MIN	--	returns smaller of two numbers.

	x	y	->	x % y.

	REAL	REAL	->	REAL
*/

void c_min (void)
{
	genobj		* a, * b;
	realobj		* r;

	if (! stack || ! stack->next) {
		error ("MIN", ERR_2FEWARG);
		return;
	}

	if ((b = stack->obj)->id == REAL && (a = stack->next->obj)->id == REAL) {
		if (!(r = mallocobj (REAL)))
		{
			error ("MIN", ERR_NOMEM);
			return;
		}
		((realobj *)r)->val = min (((realobj *) a)->val, ((realobj *) b)->val);
		c_drop ();
		c_drop ();
		push (r);
	} else {
		if (a->id != REAL) error ("MIN", ERR_WRTYPE, id2str (a->id));
		if (b->id != REAL) error ("MIN", ERR_WRTYPE, id2str (b->id));
	}
}
