/****************************************************************

Module:
	Errors

Description:
	Error messages


Modification history:

	0.0	hjp	89-06-26

		initial version

	0.1	hjp	89-07-25

		ERR_NXVAR added

	0.2	hjp	89-08-15

		parameter detail added to error
		ERR_DOS added.

	0.3	hjp	89-08-29

		ERR_LOOP added.

	0.4	hjp	89-10-05

		INT_BADLINK added.
		error has now variable parameter list.

	0.5	hjp	89-11-15

		parameter to ERR_SYNTAX added.

	0.6	hjp	89-12-11

		ERR_FPE added.

	0.7	hjp	90-02-27

		START, FOR, DO, WHILE, COMMENT added to id2str.

****************************************************************/

#define ERRORS_C

#include <port.h>
#include <stdarg.h>
#include <stdio.h>

#include "errors.h"
#include "debug.h"

char * errstr [] =
{
	"No error\n",
	"Wrong argument type %s\n",
	"Stack empty\n",
	"Too few arguments\n",
	"Syntax error: %s\n",
	"Out of Memory\n",
	"No such variable: '%s'\n",
	"No user variables\n",
	"Error reported by DOS: %s\n",
	"Loop nesting error\n",
	"Floating Point Exception\n",

	"(INTERNAL) stack is not a list\n",
	"(INTERNAL) unknown object type %s\n",
	"(INTERNAL) impossible link count %s",

	"(PANIC) buffer overflow -- committing suicide ...\n",
};

char * id2str (int id)
{
	char * rc;

	switch (id) {
	case REAL:
		rc = "REAL";
		break;
	case COMPLEX:
		rc = "COMPLEX";
		break;
	case BINARY:
		rc = "BINARY";
		break;
	case PROGRAM:
		rc = "PROGRAM";
		break;
	case OP:
		rc = "OP";
		break;
	case UNAME:
		rc = "UNAME";
		break;
	case QNAME:
		rc = "QNAME";
		break;
	case STRING:
		rc = "STRING";
		break;
	case LIST:
		rc = "LIST";
		break;
	case VARIABLE:
		rc = "VARIABLE";
		break;
	case START:
		rc = "START";
		break;
	case DO:
		rc = "DO";
		break;
	case FOR:
		rc = "FOR";
		break;
	case WHILE:
		rc = "WHILE";
		break;
	case COMMENT:
		rc = "COMMENT";
		break;
	default:
		rc = NULL;
	}
	return rc;
}


#ifdef STDARGBUG

	void error (char * cmd, int errnum, long dummy )
	{
		va_list	argptr;

	#ifdef TRACE
		printf ("error (%s, %d, ...) {\n", cmd, errnum);
	#endif
		va_start (argptr, errnum);
		printf ("%s: ", cmd);
		vprintf (errstr [errnum], argptr);
		va_end (argptr);
	#ifdef TRACE
		printf ("} error\n");
	#endif
	}
#else

	void error (char * cmd, int errnum, ... )
	{
		va_list	argptr;

	#ifdef TRACE
		printf ("error (%s, %d, ...) {\n", cmd, errnum);
	#endif
		va_start (argptr, errnum);
		printf ("%s: ", cmd);
		vprintf (errstr [errnum], argptr);
		va_end (argptr);
	#ifdef TRACE
		printf ("} error\n");
	#endif
	}
#endif
