/****************************************************************

Module:
	FileCmd

Description:
	Commands for file I/O


Modification history:

	0.0	hjp	89-08-14

		initial version.

	0.1	hjp	89-08-15

		SAVE	debugged
		LOAD	added
		SYSTEM	added.

	0.2	hjp	89-11-23

		SAVE now _appends_ to file.

	0.3	hjp	89-12-02

		PRINT added.

	0.4	hjp	89-12-11

		minor bug fixing.

****************************************************************/

#include <stddef.h>
#include <stdlib.h>
#include <stdio.h>

#include "rpl.h"
#include "errors.h"
#include "filecmd.h"
#include "globvar.h"
#include "intcmd.h"
#include "stackcmd.h"

/*
	SAVE: save object at level 2 to file at level 1

	1: obj	2: string	->
*/

void c_save (void)
{
	listobj	* a, * b;
	FILE	* fp;

	if ((b = stack) && (a = stack->next)) {

		if (b->obj->id != STRING) {

			error ("SAVE", ERR_WRTYPE, id2str (b->obj->id));

		} else if (fp = fopen (((stringobj *) b->obj)->val, "a")) {

			c_drop ();		/*	drop name	*/

			iop = iobuffer;
			printobj (a->obj);
			fprintf (fp, "%s\n", iobuffer);
			if (fclose (fp)) {
				error ("SAVE", ERR_DOS, strerror (errno));
			}
			c_drop ();	/*	drop saved object	*/

		} else {
			error ("SAVE", ERR_DOS, strerror (errno));
		}
	} else {

		error ("SAVE", ERR_2FEWARG, NULL);
	}
}


/*
	LOAD: load file into command line

	1: string	->	??
*/

void c_load (void)
{
	listobj	* b;
	FILE	* fp;
	int	rdcnt;

	if ((b = stack)) {

		if (b->obj->id != STRING) {

			error ("LOAD", ERR_WRTYPE, id2str (b->obj->id));

		} else if (fp = fopen (((stringobj *) b->obj)->val, "r")) {

			c_drop ();						/*	drop name			*/

			rdcnt = fread (cmdline, 1, PROGMAXSIZE - 1, fp);	/*	try to read max. program size	*/
			cmdline [rdcnt] = 0;					/*	append EOS			*/
			rdptr = cmdline; empty = 0;				/*	simulate edit ()		*/
			if (fclose (fp)) {
				error ("LOAD", ERR_DOS, strerror (errno));
			}

		} else {
			error ("LOAD", ERR_DOS, strerror (errno));
		}
	} else {

		error ("LOAD", ERR_2FEWARG, NULL);
	}
}

void c_system (void)
{
	listobj	* b;

	if ((b = stack)) {

		if (b->obj->id != STRING) {

			error ("SYSTEM", ERR_WRTYPE, id2str (b->obj->id));

		} else if (system (((stringobj *) b->obj)->val)) {

			error ("SYSTEM", ERR_DOS, strerror (errno));

		}
		c_drop ();

	} else {

		error ("SYSTEM", ERR_2FEWARG, NULL);
	}
}


/*
	PRINT: write object at level 1 to stdout

	1: obj	->
*/

void c_print (void)
{
	listobj	* a;

	if (a = stack) {

		iop = iobuffer;
		printobj (a->obj);
		printf ("%s\n", iobuffer);
		c_drop ();	/*	drop printed object	*/

	} else {

		error ("PRINT", ERR_2FEWARG, NULL);
	}
}

