.\"@(#) rot.man 88/03/03 -- use tbl
.TH ROT 1 public UNIX
.SH NAME
rot \- rotate a file
.SH SYNOPSIS
rot [-rbloB] [-c \fIc\fP] [\fIfile\fP]
.SH DESCRIPTION
.I Rot
rotates a file, so that lines become columns and vice versa. Without any
options, the file will be rotated clockwise. So, from the input
.nf
.in +10

abcde
abcd
abc
ab
a
\0\0\0xx\0xx
A
AB
ABC
ABCD
ABCDE

.ti -10
you will get

AAAAA\0aaaaa
BBBB\0\0\0bbbb
CCC\0\0\0\0\0ccc
DD\0\0\0x\0\0\0dd
E\0\0\0\0x\0\0\0\0e
\0\0\0\0\0\0
\0\0\0\0\0x
\0\0\0\0\0x

.in -10
.fi
.I Rot
uses a two pass algorithm, where the first part collects the line length of each
line in the input, and the second prints out the new lines, seeking through
the input file.
When no file or - is given,
.I rot
reads from standard input.
.SH OPTIONS
.TP
.B -r
rotate reverse (counter-clockwise)
.TP
.B -b
normally,
.I rot
suppresses printing of trailing blanks in output lines.
This option retains them, so all blanks of the input will appear
in the output
.TP
.B -l
do only the first pass and print the number of lines and the length of the
longest line found to standard output
.TP
.B -o
change order of columns; in combination with the rotation this yields
one more file operation (see below)
.TP
.B -B
this is for big files; the data will be hold in temporary files rather
than in memory; this slows down
.I rot
enormously
.TP
.B -c \fIc\fP
use
.I c
as "line"-separator, instead of the newline character
.br
.ne 8
.SH REMARKS
One may ask, what
.I rot
is useful for.
Think about the functionality of programs like
.IR cat (1),
or the line oriented
.IR grep (1),
.IR cut (1),
.IR sed (1),
.IR sort (1),
and others, when applied to a rotated file.
In conjunction with
.I rot
they do not longer work on lines, but columns.
For example
.P
.ti +10
rot f | grep ... | rot -r
.P
is a
.I grep
on columns of the file f.
.P
The -o option permits you to manipulate a file in some way of "reflecting" it
in a "diagonal" line. The following table shows the different effects of
.I rot
called with various options. Data manipulation is shown by means of the
output of a file with the contents
.P
.ti +10
AB
.br
.ti +10
CD
.P
and a symbolic notation. R means Rotation (angle given), M means
reflection at given mirror axis.
Combinations of two calls of
.I rot
are also given. (Other combinations
have identical effects to one of the mentioned.)

.TS
tab(#) center box;
lfB | cfB | cfB
l | c | c.
call#output#function
.sp 0.5
=
rot#CA#R
\^#DB#-90 deg
_
rot -r#BD#R
\^#AC#90 deg
_
rot -o#DB#M
\^#CA#/
_
rot -ro#AC#M
\^#BD#\e
=
rot | rot#DC#R
\^#BA#180 deg
_
rot | rot -r#AB#(Id) *
\^#CD#\^
_
rot | rot -o#BA#M **
\^#DC#|
_
rot | rot -ro#CD#M
\^#AB#\-
.TE

* Note, that  rot|rot -r  (or  rot|rot|rot|rot)  is not exactly the null
operator.
.I Rot
must insert blanks to keep track of the columns.
They may appear at the end of lines in a further run of
.IR rot ,
if the -b option is given.
Without this option blanks from the original input may be lost.
.P
** This is not the same as what is done by
.IR rev (1).
Rev does not retain columns!

.I Rot
knows nothing about tab characters, use
.IR expand (1)
to handle them correctly.
.SH FILES
.TP
/tmp/rot* -
temporarily copied input, if standard input is incapable of seeking
(pipe or terminal) (-B option only)
.TP
/tmp/rod* -
tempfile for holding length of input lines (-B option only)
.SH SEE ALSO
rev(1), tail(1bsd), tac(1public), expand(1), colrm(1)
.SH AUTHOR
.nf
Martin Schmidt
Dortmund - W. Germany
mschmidt@exunido.uucp
.fi
