#include <stdio.h>
#include "defs.h"
#define SPACECONST 1000.

int             drawline[] = {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};	/* 0=no line, 1=line */

extern int      optind;
extern char    *optarg;
char            names[MAXCOLS][MAXTXT];	/* input : names of columns */
char            labeldata[MAXCOLS][MAXPTS][10];	/* input : label-data in
						 * columns */
char           *pnames[MAXCOLS];/* don't draw lines for columns with this
				 * name */
char           *lnames[MAXCOLS];/* name of column, which has label-data */

char           *optstr = "Eeicl:P:H:X:Y:F:w:x:y:d:l:L:";	/* list of options */
char           *header = "";	/* figure caption */
char           *xlabel = names[0];	/* label for x axis */
char           *ylabel = names[1];	/* --------- y ---- */
char           *plottertype = "hp300h";	/* type of output device */
char           *xformat = "%.1lf";
/* char	*yformat="%5.1lf"; */
char           *yformat = "%.1lf";
/*	"solid", "solid", "solid", "solid", "solid", /* -- was 1st line below - gs*/

char           *linetype[] = {
	"solid", "dotted", "longdashed", "shortdashed", "dotdashed",	/* change 14/6/89 - gs*/
	"solid", "dotted", "longdashed", "shortdashed", "dotdashed",
	"solid", "dotted", "longdashed", "shortdashed", "dotdashed",
	"solid", "dotted", "longdashed", "shortdashed", "dotdashed",
	"solid", "dotted", "longdashed", "shortdashed", "dotdashed",
};

static char    *help[] = {
	"Usage : scat [options]",
	"-x m,n,l	Bounds on x axis (min, max, interval   ",
	"-y m,n,l	Bounds on y axis (min, max, interval   ",
	"-w m,n,l,o	Window bounds  minx, miny, maxx,maxy   ",
	"-X text 	Text for X axis                        ",
	"-Y text  	Text for Y axis                        ",
	"-H text  	Figurecaption                          ",
	"-F \"x/y format\"	Format for numbers on x/y axis ",
	"-c       	Use colors                             ",
	"-e      	No erase                               ",
	"-E      	Use extended plot commands		",
	"-l name	Name of y column not to draw lines for ",
	"-L name	Name of label-column                   ",
	"-d number	Debug level                            ",
""};
char          **ptrhlp = help;

int             extended_plot = 0;

int             init_plotter = 1;
int             plotfil;
int             num_pens = 8;	/* number of pen in plotter */
int             numcols;	/* input : number of data-columns */
int             numpts;		/* ----------------- data pts */
int             pcol = 0;	/* number of columns, not to draw lines for */
int             lcol = 0;	/* number of label-columns in the inputdata */
int             debuglevel = 0;	/* level of debugging output */
int             outx, outy, outx1, outy1;	/* convert data to new coord.
						 * system */
int             plotdata[MAXCOLS][MAXPTS];	/* ditto  */
int             missingvalue[MAXCOLS][MAXPTS];	/* 1=value is missing from
						 * inputfile 0=value is not
						 * missing */
double          spaceconst = SPACECONST;
double          data[MAXCOLS][MAXPTS];	/* input : data in columns */
double          min[MAXCOLS];	/* min of data */
double          max[MAXCOLS];	/* max of data */
double          xmin = 0., xmax = 0.;	/* min, max of all x-values */
double          ymin = 0., ymax = 0.;	/* min, max of all y-values */
double          xdelta = 0., ydelta = 0.;	/* increment for x/y tick
						 * marks */
double          xrange = 0., yrange = 0.;	/* ranges of xy-values */
double          wxmin = 0., wxmax = 0.;	/* x-window bounds in x-scale */
double          wymin = 0., wymax = 0.;	/* y-window bounds in y-scale */
double          wx1 = 0., wx2 = SPACECONST;	/* Relative x-window bounds */
double          wy1 = 0., wy2 = SPACECONST;	/* relative y-window bounds */
main(argc, argv)
	int             argc;
	char          **argv;
{

	int             col, row, ldcol;	/* indices */
	int             c;
	int             werase = 1;	/* 0=no erase ; 1=erase */
	int             usecolor = 0;	/* 0=no color */
	int             optionx = 0;	/* option x not used */
	int             optiony = 0;	/* option y not used */

	while ((c = getopt(argc, argv, optstr)) != EOF) {
		switch (c) {
		case 'x':
			sscanf(optarg, "%lf,%lf,%lf", &xmin, &xmax, &xdelta);
			xrange = xmax - xmin;
			optionx = 1;
			break;
		case 'y':
			sscanf(optarg, "%lf,%lf,%lf", &ymin, &ymax, &ydelta);
			yrange = ymax - ymin;
			optiony = 1;
			break;
		case 'd':
			sscanf(optarg, "%d", &debuglevel);
			break;
		case 'i':
			init_plotter = 0;
			break;
		case 'E':
			extended_plot = 1;	/* no extended plot cmds */
			break;
		case 'e':
			werase = 0;	/* no erase */
			break;
		case 'c':
			usecolor = 1;	/* use color */
			break;
		case 'l':
			pnames[pcol] = optarg;
			pcol++;
			break;
		case 'L':
			lnames[lcol] = optarg;
			lcol++;
			break;
		case 'F':
			c = optarg[0];
			if (c == 'x')
				xformat = ++optarg;
			else
				yformat = ++optarg;
			break;
		case 'w':
			sscanf(optarg, "%lf,%lf,%lf,%lf", &wx1, &wy1, &wx2, &wy2);
			wx1 = wx1 * spaceconst;
			wx2 = wx2 * spaceconst;
			wy1 = wy1 * spaceconst;
			wy2 = wy2 * spaceconst;
			break;
		case 'X':
			xlabel = optarg;
			break;
		case 'Y':
			ylabel = optarg;
			break;
		case 'H':
			header = optarg;
			break;
		default:
			while (**ptrhlp)
				fprintf(stderr, "\t%s\n", *ptrhlp++);
			exit(-1);

		}
	}

	if (debuglevel) {
		fprintf(stderr, "Finished reading options\n");
		fprintf(stderr, "Read data\n");
		fprintf(stderr, "pcol= %d, lcol=%d\n", pcol, lcol);
	}
	read_data(&numcols, &numpts, names, pnames, pcol, lnames, lcol, drawline,
		  data, labeldata, missingvalue);

	if (debuglevel) {
		fprintf(stderr, "Finished reading data\n");
		for (row = 0; row < numpts; row++) {
			for (col = 0; col < lcol; col++)
				fprintf(stderr, "%s\t", labeldata[col][row]);
			fprintf(stderr, "\n");
		}
		for (row = 0; row < numpts; row++) {
			for (col = 0; col < numcols; col++)
				fprintf(stderr, "%lf\t", data[col][row]);
			fprintf(stderr, "\n");
		}
	}
	if (debuglevel)
		fprintf(stderr, "find min og max\n");
	/* find min and max of data */
	for (col = 0; col < numcols; col++) {
		max[col] = data[col][0];
		min[col] = data[col][0];
		for (row = 1; row < numpts; row++) {
			if (data[col][row] > max[col])
				max[col] = data[col][row];
			else if (data[col][row] < min[col])
				min[col] = data[col][row];
		}
	}

	if (optionx < 1) {
		xmin = min[0];	/* store x min and max */
		xmax = max[0];
		xrange = xmax - xmin;
		xdelta = xrange / 40.;
	}
	if (optiony < 1) {
		ymax = max[1];	/* initialize max/min of all yvals */
		ymin = min[1];
		for (col = 2; col < numcols; col++)
			if (max[col] > ymax)
				ymax = max[col];
			else if (min[col] < ymin)
				ymin = min[col];
		yrange = ymax - ymin;
		ydelta = yrange / 40.;
	}
	/* Enlarge outer frame */
	wxmin = xmin - 0.25 * xrange;
	wxmax = xmax + 0.10 * xrange;
	wymin = ymin - 0.25 * yrange;
	wymax = ymax + 0.15 * yrange;

	if (debuglevel) {
		fprintf(stderr, "wxmin= %lf and wxmax= %lf\n", wxmin, wxmax);
		fprintf(stderr, "wymin= %lf and wymax= %lf\n", wymin, wymax);
	}
	if (debuglevel)
		fprintf(stderr, "Opening plotter for output\n");
	openpl();
	if (werase)
		erase();
	space(0, 0, (int) spaceconst, (int) spaceconst);
	transf_data(wxmin, wymin, wxmax, wymax, wxmin, wymin, &outx, &outy);
	transf_data(wxmin, wymin, wxmax, wymax, wxmax, wymax, &outx1, &outy1);
	rectangle(outx, outy, outx1, outy1);
	transf_data(wxmin, wymin, wxmax, wymax, xmin, ymin, &outx, &outy);
	transf_data(wxmin, wymin, wxmax, wymax, xmax, ymax, &outx1, &outy1);
	rectangle(outx, outy, outx1, outy1);
	if (debuglevel)
		fprintf(stderr, "Finished initializing plotter\n");

	if (debuglevel)
		fprintf(stderr, "Converting data to new system\n");
	for (row = 0; row < numpts; row++)
		plotdata[0][row] = (int) ((wx2 - wx1) * (data[0][row] - wxmin) / (wxmax - wxmin) + wx1);
	for (col = 1; col < numcols; col++)
		for (row = 0; row < numpts; row++)
			plotdata[col][row] = (int) ((wy2 - wy1) * (data[col][row] - wymin) / (wymax - wymin) + wy1);

	if (debuglevel)
		fprintf(stderr, "Drawing figure\n");
	ldcol = 0;
	for (col = 1; col < numcols; col++) {
		if (usecolor)
			selectcolor((col - 1) % num_pens + 1);
		if (drawline[col] > 1) {
			labelplace("c");	/* center the label at the
						 * point */
			for (row = 0; row < numpts; row++)
				text(plotdata[0][row], plotdata[col][row], labeldata[ldcol][row]);
			ldcol++;
		} else if (drawline[col] > 0) {
			linemod(linetype[col - 1]);
			if (!missingvalue[col][0])
				point(plotdata[0][0], plotdata[col][0]);
			for (row = 1; row < numpts; row++) {
				if (!missingvalue[col][row]) {
					point(plotdata[0][row], plotdata[col][row]);
					if (!missingvalue[col][row - 1]) {
						move(plotdata[0][row - 1], plotdata[col][row - 1]);
						cont(plotdata[0][row], plotdata[col][row]);
					}
				}
			}
		} else {
			for (row = 0; row < numpts; row++)
				point(plotdata[0][row], plotdata[col][row]);
		}
	}

	if (debuglevel)
		fprintf(stderr, "Plotting tic-marks\n");
	plot_tics(wxmin, wxmax, wymin, wymax, xmin, xmax, xdelta, ymin, ymax, ydelta);

	if (debuglevel)
		fprintf(stderr, "Plotting texts\n");
	plot_texts(header, xlabel, ylabel, wxmin, wxmax, wymin, wymax, xmin, ymin, ymax);

	closepl();
}
