#include "defs.h"
extern int debuglevel;
extern char *xformat;
extern char *yformat;

plot_tics(wxmin,wxmax,wymin,wymax,xmin,xmax,xdelta,ymin,ymax,ydelta)
double	xmin,xmax;		/* min, max of all x-values */
double	ymin,ymax;		/* min, max of all y-values */
double	xdelta,ydelta;		/* increment for x/y tick marks */
double  wxmin,wxmax,wymin,wymax;
{
	int i=0,j=0;
	int outx,outy;
	char number[80];
	double numlargeticks;
	double x, y;

	linemod("solid");
	if (debuglevel) {
		fprintf(stderr,"xformat= %s\n",xformat);	
		fprintf(stderr,"yformat= %s\n",yformat);	
	}

	labelplace("u");
	x=xmin;				/* x axis */
	sprintf(number,xformat,x);	/* char version of axis number */

	transf_data(wxmin,wymin,wxmax,wymax,x,ymin,&outx,&outy);
	move(outx,outy);
	transf_data(wxmin,wymin,wxmax,wymax,x,ymin-(ymax-ymin)*.03,&outx,&outy);
	cont(outx,outy);
	transf_data(wxmin,wymin,wxmax,wymax,x,ymin-(ymax-ymin)*.035,&outx,&outy);
	move(outx,outy);
	label(number);

	numlargeticks=(((xmax-xmin)/xdelta)/5);
	for(i=(int)numlargeticks;i--;){	/* large tick loop */
		for(j=5;j--;){		/* small tick loop */
			transf_data(wxmin,wymin,wxmax,wymax,x,ymin,&outx,&outy);
			move(outx,outy);	/* draw small tick */
			transf_data(wxmin,wymin,wxmax,wymax,x,ymin-(ymax-ymin)*.015,&outx,&outy);
	                cont(outx,outy);
			x+=xdelta;		/* x for next small tick */
		}
		transf_data(wxmin,wymin,wxmax,wymax,x,ymin,&outx,&outy);
		move(outx,outy);		/* next large tick */
		transf_data(wxmin,wymin,wxmax,wymax,x,ymin-(ymax-ymin)*.03,&outx,&outy);
		cont(outx,outy);
		transf_data(wxmin,wymin,wxmax,wymax,x,ymin-(ymax-ymin)*.035,&outx,&outy);
		move(outx,outy);
		sprintf(number,xformat,x);	/* put number at large tick */
		label(number);
	}

	labelplace("l");
	y=ymin;					/* y axis */
	sprintf(number,yformat,y);		/* string rep of # */
	transf_data(wxmin,wymin,wxmax,wymax,x,ymin,&outx,&outy);
	move(outx,outy);
	transf_data(wxmin,wymin,wxmax,wymax,xmin-(xmax-xmin)*.03,y,&outx,&outy);
	cont(outx,outy);
	transf_data(wxmin,wymin,wxmax,wymax,xmin-(xmax-xmin)*.035,y,&outx,&outy);
	move(outx,outy);
	label(number);
	numlargeticks=(((ymax-ymin)/ydelta)/5);
	for (i=(int)numlargeticks;i--;){
		for(j=5;j--;){
			transf_data(wxmin,wymin,wxmax,wymax,xmin,y,&outx,&outy);
			move(outx,outy);
		transf_data(wxmin,wymin,wxmax,wymax,xmin-(xmax-xmin)*.02,y,&outx,&outy);
		cont(outx,outy);
			y+=ydelta;
		}
		transf_data(wxmin,wymin,wxmax,wymax,xmin,y,&outx,&outy);
		move(outx,outy);
		transf_data(wxmin,wymin,wxmax,wymax,xmin-(xmax-xmin)*.03,y,&outx,&outy);
		cont(outx,outy);
		transf_data(wxmin,wymin,wxmax,wymax,xmin-(xmax-xmin)*.035,y,&outx,&outy);
		move(outx,outy);
		sprintf(number,yformat,y);
		label(number);
	}

}
