/************************************************************************
 *   Plot(5) interface library for XWindows				*
 *									*
 *   Asta G. March 1989                                                 *
 *   Adapted from a code for suntools by:                               *
 *									*
 *   	Scott Sutherland, November 1987					*
 *   	Boston University Math Department			       	*
 *									*
 *   This was adapted from a code by:					*
 *   	Jim Constantine, Janurary 1986					*
 *   which was in turn based on work by:				*
 *   	Mike Caplinger, Rice University, September 1984.		*
 ***********************************************************************/

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <strings.h>

#define FONT    "6x13.snf"
#define ARG_FONT                "font"


/* plot stuff */
float 		xscale = 1.0, yscale = 1.0;
float 		xorig = 0.0, yorig = 0.0;
int 		x, y;
int		use_labelplace=0;  /* 0=false, 1=true */
char		*label_pl;
int		xheight, yheight, width;
int winX, winY, winW, winH;

/* xwindow stuff */
XWMHints        xwmh = {
    (InputHint|StateHint),      /* flags */
    False,                       /* no input from keyboard */
    NormalState,                /* initial_state */
    0,                          /* icon pixmap */
    0,                          /* icon window */
    0, 0,                       /* icon location */
    0,                          /* icon mask */
    0,                          /* Window group */
};

char *ProgramName;

void Usage ()
{
        fprintf (stderr, "usage:  %s [-options ...]\n\n", ProgramName);
        fprintf (stderr, "where options include:\n");
        fprintf (stderr, "    -geometry geom           size of window\n");
        fprintf (stderr, "\n");
        exit (1);
}

extern    int argc_copy;
extern    char **argv_copy;

char **ap;
char *geom = NULL;
Display    *dpy;            /* X server connection */
Screen *scr;
Window      win;            /* Window ID */
GC          gc;             /* GC to draw with */
char        *fontName;      /* Name of the font to use */
XFontStruct *fontstruct;    /* Font descriptor */
unsigned long fth, ftw, pad;     /* Font size parameters */
unsigned long fg, bg, bd;   /* Pixel values */
unsigned long bw;           /* Border width */
XGCValues   gcv;            /* Struct for creating GC */
XEvent      event;          /* Event received */
XSizeHints  xsh;            /* Size hints for window manager */
char       *geomSpec;       /* Window geometry string */
XSetWindowAttributes xswa;  /* Temporary Set Window Attribute struct
Window win;
 
/************************************************************************/
/*			openpl						*/
/************************************************************************/
openpl() {

 /* Process arguments: */
    ap = argv_copy;  
    while (*++ap) {
        if (!strncmp(*ap, "-g", 2)) {
                if (*++ap) {
                        geom = *ap;
                } else
                        Usage ();
        } else if (**ap == '=')
                        geom = *ap;
    }

  /*
     * Open the display using the $DISPLAY environment variable to locate
     * the X server.  See Section 2.1.
     */
    if ((dpy = XOpenDisplay(NULL)) == NULL) {
        fprintf(stderr, "%s: can't open %s\n", argv_copy[0], XDisplayName(NULL));
        exit(1);
    }
     /* Select the font to use */
    if ((fontName = XGetDefault(dpy, argv_copy[0], ARG_FONT)) == NULL) {
        fontName = FONT;
    }
    if ((fontstruct = XLoadQueryFont(dpy, fontName)) == NULL) {
        fprintf(stderr, "%s: display %s doesn't know font %s\n",
                argv_copy[0], DisplayString(dpy), fontName);
        exit(1);
    }
    fth = fontstruct->max_bounds.ascent + fontstruct->max_bounds.descent;
/*    fth = fontstruct->ascent + fontstruct->descent; */
    ftw = fontstruct->max_bounds.width;

	    /*
     * Select colors for the border,  the window background,  and the
     * foreground.
     */
    bd = BlackPixel(dpy, DefaultScreen(dpy));
    bg = WhitePixel(dpy, DefaultScreen(dpy));
    fg = BlackPixel(dpy, DefaultScreen(dpy)); 

    /*
     * Set the border width of the window
     */
     bw = 3;

     /*
     * Create the Window with the information in the XSizeHints, the
     * border width,  and the border & background pixels. See Section 3.3.
     */
     scr = DefaultScreenOfDisplay(dpy);
     xsh.width = 500;
     xsh.height = 300;
     xsh.x = 0; 
     xsh.y = 0;
     xsh.flags = (PPosition | PSize); 
  
     if (geom) {
        XParseGeometry(geom, &xsh.x, &xsh.y, &xsh.width, &xsh.height);
	xsh.flags = (USPosition | USSize);
     }
        
     win = XCreateSimpleWindow(dpy, DefaultRootWindow(dpy),
                      xsh.x, xsh.y, xsh.width, xsh.height,
                      bw, bd, bg);
      
     /* 
     * Set the standard properties for the window managers. See Section
     * 9.1.
     */
    XSetStandardProperties(dpy, win, "", "", None, argv_copy, argc_copy,&xsh);
    XSetWMHints(dpy, win, &xwmh);

        scr = DefaultScreenOfDisplay(dpy);
                

     /*
     * Ensure that the window's colormap field points to the default
     * colormap,  so that the window manager knows the correct colormap to
     * use for the window.  See Section 3.2.9. Also,  set the window's Bit
     * Gravity to reduce Expose events.
     */
     xswa.save_under=True;
     xswa.backing_store = Always;
     xswa.colormap = DefaultColormap(dpy, DefaultScreen(dpy));
     xswa.bit_gravity = CenterGravity;
     XChangeWindowAttributes(dpy, win, (CWSaveUnder | CWBackingStore | CWColormap | CWBitGravity),&xswa);

     /*
     * Create the GC for plotting.  See Section 5.3.
     */

     gcv.font = fontstruct->fid;
     gcv.foreground = fg;
     gcv.background = bg;
/*     gcv.function=GXand;
     gcv.plane_mask=BlackPixel(dpy,DefaultScreen(dpy)) ^
                    WhitePixel(dpy,DefaultScreen(dpy));    */
     gc = XCreateGC(dpy, win, (GCFont | GCForeground | GCBackground ), &gcv);

    /*
     * Specify the event types we're interested in - only Exposures. See
     * Sections 8.5 & 8.4.5.1
     */
    XSelectInput(dpy, win, ExposureMask);
     
    /*
     * Map the window to make it visible.  See Section 3.5.
     */
    XMapWindow(dpy, win);     
    XNextEvent(dpy, &event);
   
}
/************************************************************************/
/*			move						*/
/************************************************************************/
move(x1, y1) {
    x = scalex(x1);
    y = scaley(y1);
}
/************************************************************************/
/*			cont						*/
/************************************************************************/
cont(x1, y1) {
    x1 = scalex(x1);
    y1 = scaley(y1);
    XDrawLine(dpy, win, gc, x, y, x1, y1);
    x = x1;
    y = y1;
    XFlush(dpy);
}
/************************************************************************/
/*			point						*/
/************************************************************************/
point(x, y) {
    x = scalex(x);
    y = scaley(y);
    XDrawRectangle(dpy, win, gc, x, y, 1, 1);
    XFlush(dpy);
}
/************************************************************************/
/*			line						*/
/************************************************************************/
line(x1, y1, x2, y2) {
    x1 = scalex(x1);
    y1 = scaley(y1);
    x2 = scalex(x2);
    y2 = scaley(y2);
    XDrawLine(dpy, win, gc, x1, y1, x2, y2);
    XFlush(dpy);
}
/************************************************************************/
/*			circle						*/
/*		Not implemented						*/
/************************************************************************/
circle(x1, y1, r) {
      x1=scalex(x1-r);
      y1=scaley(y1-r);
      width=scalex(2*r);
      XDrawArc(dpy,win,gc,x1,y1,width,width,0,23040);
      XFlush(dpy);
}
/************************************************************************/
/*			arc						*/
/*		Not implemented						*/
/************************************************************************/
arc(cx, cy, sx, sy, ex, ey) 
{
}
/************************************************************************/
/*			label						*/
/************************************************************************/
label(s)
char *s;
{
    if(!use_labelplace){
          XDrawString(dpy, win, gc, x, y, s, strlen(s));
          XFlush(dpy);
          }
    else {
        switch(*label_pl){
		case 'u':
                      x=x-XTextWidth(fontstruct,s,strlen(s))/2;
                      y=y+fth;
                      XDrawString(dpy, win, gc, x, y, s, strlen(s));
                      XFlush(dpy);
                      break;

		case 'o': /* center the label over the point */
                      x=x-XTextWidth(fontstruct,s,strlen(s))/2;
                      XDrawString(dpy, win, gc, x, y, s, strlen(s));
                      XFlush(dpy);
                      break;
        
		case 'l': /* center the label left at the point */
                      x=x-XTextWidth(fontstruct,s,strlen(s));
/*		      y=y-fth/2+fontstruct->ascent; */
		      y=y-fth/2+fontstruct->max_bounds.ascent;
                      XDrawString(dpy, win, gc, x, y, s, strlen(s));
                      XFlush(dpy);
                      break;
        
	        case 'r': /* center the label right at the point */
/*		      y=y+fth/2;  */
		      y=y-fth/2+fontstruct->max_bounds.ascent;
                      XDrawString(dpy, win, gc, x, y, s, strlen(s));
                      XFlush(dpy);
	              break;
    
	        case 'c': /* center the label at the point */
                      x=x-XTextWidth(fontstruct,s,strlen(s))/2;
		      y=y-fth/2+fontstruct->max_bounds.ascent;
/*		      y=y+fth/2;  */
                      XDrawString(dpy, win, gc, x, y, s, strlen(s));
                      XFlush(dpy);
	              break;
	
	        default: /* center the label at the point */
                      x=x-XTextWidth(fontstruct,s,strlen(s))/2;
		      y=y-fth/2+fontstruct->max_bounds.ascent;
/*		      y=y+fth/2;   */
	              XDrawString(dpy, win, gc, x, y, s, strlen(s));
        	      XFlush(dpy);
	              break;
	  }
     }
}
/************************************************************************/
/*			labelplace -- a homemade function						*/
/************************************************************************/
labelplace(s)
    char *s;
{
     
    switch(s[1]) {

    case 'u': /* center the label under the point */
        use_labelplace=1;
        label_pl="u";
        break;
    
    case 'o': /* center the label over the point */
        use_labelplace=1;
        label_pl="o";
        break;
        
    case 'l': /* center the label left at the point */
        use_labelplace=1;
        label_pl="l";
        break;
        
    case 'r': /* center the label right at the point */
        use_labelplace=1;
        label_pl="r";
        break;
    
    case 'c': /* center the label at the point */
        use_labelplace=1;
        label_pl="c";
        break;

    default: /* center the label at the point */
        use_labelplace=1;
        label_pl="c";
        break;
    }
}

/************************************************************************/
/*			labelrotation  - a homemade function            */
/*			not implemented  				*/
/************************************************************************/
labelrotation(s)
    char *s;
{
        
    switch(s[1]) {

    case 'h': /* horizontal */
        break;
 
    case 'v': /* vertical */
        break;
    }
}

/************************************************************************/
/*	  		selectcolor  - a homemade function              */
/*			not implemented  				*/
/************************************************************************/
selectcolor(s)
    char *s;
{
    
    switch(s[1]) {
        
    case '1': /* select pen 1 */
        break;
        
    case '2': /* select pen 2 */
        break;
        
    case '3': /* select pen 3 */
        break;
 
    case '4': /* select pen 4 */
        break;
 
    case '5': /* select pen 5 */
        break;

    case '6': /* select pen 6 */
        break;
    
    case '7': /* select pen 7 */
        break;
    
    case '8': /* select pen 8 */
        break;

    default: /* select pen 1 */
        break;
    }
}    

/************************************************************************/
/*			erase						*/
/************************************************************************/
erase() {
    XClearWindow(dpy, win);
    XFlush(dpy);
}

/************************************************************************/
/*			linemod						*/
/*		    Not implemented					*/
/************************************************************************/
linemod(s)
char *s;
{

    switch(s[3]) {
    case 't': /* dotTed */
        break;

    case 'i': /* solId */
    default:
        break;

    case 'g': /* lonGdashed */
        break;

    case 'r': /* shoRtdashed */
        break;

    case 'd': /* dotDashed */
        break;

    }
}
/************************************************************************/
/*			space						*/
/************************************************************************/
space(xorigi, yorigi, x1, y1) {
    xorig = xorigi;
    yorig = yorigi;
    xscale = ((float) xsh.width) / (x1 - xorig);
    yscale = ((float) xsh.height) / (y1 - yorig);
}

/************************************************************************/
/*			closepl						*/
/************************************************************************/
closepl() {
  XFlush(dpy);
  sleep(100000);
  return;
}

/************************************************************************/
/*			scalex						*/
/************************************************************************/
static scalex(xi) {
    float x;

    x = xi;
    x -= xorig;
    x = x * xscale;
    return((int) x);
}
/************************************************************************/
/*			scaley						*/
/************************************************************************/
static scaley(yi) {
    float y;

    y = yi;
    y -= yorig;
    y = y * yscale;
    y = xsh.height - y; /* origin at lower left. */
    return((int) y);
}

