#!/bin/sh
#
# testgr -- user script for testing reldb programs.
#

PLOTDIR=/usr/local/src/Reldb/testgr

if [ ! -d $PLOTDIR ]
then
	echo "I can't seem to find the test data and programs"
	echo "Please edit my PLOTDIR variable properly"
	echo "(It is now set to $PLOTDIR, which is incorrect)"
	exit 1
fi

# Go home first - no need to clutter discs
cd
if [ ! -d testgr ]
then
	mkdir testgr
fi
cd testgr
PWD=`pwd`
echo "Copying programs and data into $PWD - hold on ..."
cp $PLOTDIR/* .
echo "Now run the sample programs, for example 't1 | xplot =500x500+300+300'"
