#!/bin/sh
# reldbprint -- prepares printing of reldb table using tbl.
#
# Usage: reldbprint title < reldb_table

trap "rm -f /tmp/tmp$$" 2 15

caption="$*"		# tablecaption

cat - > /tmp/tmp$$
read head < /tmp/tmp$$		# first get the header line

echo '.TS'		        # tell tbl this is a table

echo 'center doublebox;'	# and to draw a nice box around it
set - $head
captctrl=c			# Tbl header for caption
line1=c				# Handle header for first column
line3=l				# assume first col is label
shift
for i				# set up remaining tbl header lines of c's and n's
do
	captctrl=$captctrl"s"
	line1=$line1"c"		# Want to center column headers
	line3=$line3"n"		# Assume rest of cols are numbers
done
line3=$line3"."		# add the dot to end the tbl format
echo $captctrl

echo $line1		# output the tbl format 
echo $line3		# statements
echo .sp .3c
echo $caption		# then the table caption
echo .sp .3c
echo =			# double underline for caption
echo .sp .1c
echo "$head"		# next line of table data is the prelude header
echo .sp .1c
echo "_"		# underline the header in the table
sed 1,2d < /tmp/tmp$$	# now for the body of the table=data file
echo '.TE'		# and end the pretty little thing

rm -f /tmp/tmp$$
