#include <stdio.h>
#include <starbase.c.h>

#define MAXPTS	1500	/* max no of data points (lines in file) */
#define MAXCOLS	25	/* max no of data columns */
#define MAXTXT	100	/* max length of name of column */
int	drawline[]={0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}; /* 0=no line, 1=line */

extern char *optarg;

main(argc,argv)
int	argc;
char	**argv;
{
	char	names[MAXCOLS][MAXTXT];	/* input : names of columns */
	char	*optstr="eicl:P:D:H:X:Y:w:x:y:";	/* list of options */
	char	*header="";		/* figure caption */
	char	*xlabel=names[0];	/* label for x axis */
	char	*ylabel=names[1];	/* --------- y ---- */
	char	*device="/dev/crt";	/* output device (/dev entry) */
	char	*plottertype="hp300h";	/* type of output device */
	static char	*help[]={
		"Usage : scat [options]",
		"-x m,n,l	Bounds on x axis (min, max, interval   ",
		"-y m,n,l	Bounds on y axis (min, max, interval   ",
		"-w m,n,l,o	Window bounds  minx, miny, maxx,maxy   ",
		"-X text 	Text for X axis                        ",
		"-Y text  	Text for Y axis                        ",
		"-H text  	Figurecaption                          ",
		"-P plottertype	Type of plotter (e.g. hp2622 og hpgl)  ",
		"-D device	Device (e.g. filename or /dev/plt7550) ",
		"-c       	Use colors                             ",
		"-i       	Don't initialize plotter               ",
		"-e      	No erase                               ",
		"-l name	Name of y column to draw lines for     ",
		""};
        char    **ptrhlp=help;

	int	init_plotter=INIT;
	int	plotfil;
	int	numcols;		/* input : number of columns */
	int	numpts;			/* ----------------- data pts */
	int	col,row;		/* indices */
	int	c;
	int	num_pts,y,yy;		/* */
	int	num_pens;
	int	werase=1;		/* 0=no erase ; 1=erase */
	int	usecolor=0;		/* 0=no color */

	float	plotvec[MAXPTS*2];	/* temp vec for plotting */
	float	ph_lim[2][3],res[3],p1[3],p2[3];

	double	data[MAXCOLS][MAXPTS];	/* input : data in columns */
	double	min[MAXCOLS];		/* min of data */
	double	max[MAXCOLS];		/* max of data */
	double	xmin,xmax;		/* min, max of all x-values */
	double	ymin,ymax;		/* min, max of all y-values */
	double	xdelta=0.,ydelta=0.;	/* increment for x/y tick marks */
	double	xrange=0.,yrange=0.;	/* ranges of xy-values */
	double	wxmin=0.,wxmax= 0.;	/* x-window bounds in x-scale */
	double	wymin=0.,wymax= 0.;	/* y-window bounds in y-scale */
	float	wx1=0., wx2=1.;		/* Relative x-window bounds */
	float	wy1=0., wy2=1.;		/* relative y-window bounds */


	read_data(&numcols,&numpts,names,data);
	find_bounds(numcols,numpts,data,min,max,&xmin,&xmax,&ymin,&ymax);
	
	xrange=xmax-xmin;
	xdelta=xrange/40.;
	yrange=ymax-ymin;
	ydelta=yrange/40.;
	while ((c = getopt(argc, argv, optstr)) != EOF) {
		switch ( c ) {
		case 'x': sscanf(optarg,"%lf,%lf,%lf",&xmin,&xmax,&xdelta);
			xrange=xmax-xmin;
	 		break; 
		case 'y': sscanf(optarg,"%lf,%lf,%lf",&ymin,&ymax,&ydelta);
			yrange=ymax-ymin;
	 		break; 
		case 'i': init_plotter=SPOOLED;
			break;
		case 'e': werase=0;		/* no erase */
			break;
		case 'c': usecolor=1;		/* use color */
			break;
		case 'l': for(col=1;col<numcols;col++)
				if(!strcmp(optarg,names[col]))
					drawline[col]=1;
		case 'w': sscanf(optarg,"%f,%f,%f,%f", &wx1,&wy1,&wx2,&wy2);
	 		break; 
		case 'X': xlabel = optarg; 		break; 
		case 'Y': ylabel = optarg;		break;
		case 'H': header = optarg;		break;
		case 'D': device = optarg;		break;
		case 'P': plottertype = optarg;		break;
		default:
			while(**ptrhlp)fprintf(stderr,"\t%s\n",*ptrhlp++);
			exit(-1);

		}
	}

	wxmin=xmin-0.25*xrange;
	wxmax=xmax+0.05*xrange;
	wymin=ymin-0.25*yrange;
	wymax=ymax+0.15*yrange;

	if((plotfil=gopen(device,OUTDEV,plottertype,init_plotter))== -1)exit(-1);
	set_p1_p2(plotfil,FRACTIONAL,wx1,wy1,0.,wx2,wy2,0.);
	vdc_extent(plotfil,(float)wxmin,(float)wymin,(float)0.,(float)wxmax,(float)wymax,(float)0.);
	clip_rectangle(plotfil,(float)wxmin,(float)wxmax,(float)wymin,(float)wymax);
	mapping_mode(plotfil,TRUE);
	interior_style(plotfil,INT_HOLLOW,TRUE);
	rectangle(plotfil,(float)wxmin,(float)wymin,(float)wxmax,(float)wymax);
	rectangle(plotfil,(float)xmin,(float)ymin,(float)xmax,(float)ymax);

	inquire_sizes(plotfil,ph_lim,res,p1,p2,&num_pens);
	for(col=1;col<numcols;col++){
		for(row=0;row<numpts;row++){
			plotvec[2*row]=data[0][row];
			plotvec[2*row+1]=data[col][row];
		}
		y=col+1;
		yy=col-1;
		if(usecolor)
			line_color_index(plotfil,y%num_pens);
		else
			line_type(plotfil,yy%7);
		if(drawline[col]) 
			polymarker2d(plotfil,plotvec,numpts,FALSE);
		else
			polyline2d(plotfil,plotvec,numpts,FALSE);
	}
	line_color_index(plotfil,1);
	plot_texts(plotfil,header,xlabel,ylabel,wxmin,wxmax,wymin,wymax,xmin,xmax,ymin,ymax);

	line_color_index(plotfil,1);
	plot_tics(plotfil,xmin,xmax,xdelta,ymin,ymax,ydelta,wxmin,wxmax,wymin,wymax);

	gclose(plotfil);
}
read_data(numcols,numpts,names,data)
char	names[MAXCOLS][MAXTXT];	/* input : names of columns */
int	*numcols;
int	*numpts;
double	data[MAXCOLS][MAXPTS];	/* input : data in columns */
{
	int	c;		/* input character */
	int	i;	
	int	col= -1;	/* running column index */

	do{
		i=0;
		col++;
		while((c=getchar())!='\t'&&c!=' '&&c!='\n'&&c!=EOF)
			names[col][i++]=c;
		names[col][i]='\0';
	} while(c!='\n' && c!= EOF);
	if(c==EOF)exit(-1);
	*numcols= ++col;		/* store number of cols */
	while((c=getchar())!='\n');	/* skip line of minuses */
	i=0;
	do {
		for(col=0;col < *numcols ; col++)
			if(scanf("%lf",&data[col][i])<=0)return;
		i++;
		*numpts=i;
	} while(1);
}
find_bounds(numcols,numpts,data,min,max,xmin,xmax,ymin,ymax)
int	numcols;		/* input : number of columns */
int	numpts;			/* ----------------- data pts */
double	data[MAXCOLS][MAXPTS];	/* input : data in columns */
double	min[MAXCOLS];	/* min on data */
double	max[MAXCOLS];	/* max of data */
double	*xmin,*xmax;	/* min,max of ALL x-values */
double	*ymin,*ymax;	/* min,max of ALL y-values */
{
	int	col;
	int	row;
	for(col=0;col<numcols;col++){
		max[col]=data[col][0];
		min[col]=data[col][0];
		for(row=1;row<numpts;row++){
			if(data[col][row]>max[col])
				max[col]=data[col][row];
			else if(data[col][row]<min[col])
				min[col]=data[col][row];
		}
	}
	*ymax=max[1];			/* initialize max/min of all y vals */
	*ymin=min[1];
	for(col=2;col<numcols;col++)
		if(max[col]>*ymax)*ymax=max[col];
		else if(min[col]<*ymin)*ymin=min[col];
	*xmin=min[0];			/* store x min and max */
	*xmax=max[0];
}
plot_texts(plotfil,header,xlabel,ylabel,wxmin,wxmax,wymin,wymax,xmin,xmax,ymin,ymax)
int	plotfil;
char	*header;		/* figure caption */
char	*xlabel;		/* label for x axis */
char	*ylabel;		/* --------- y ---- */
double	xmin,xmax;		/* min, max of all x-values */
double	ymin,ymax;		/* min, max of all y-values */
double	wxmin,wxmax,wymin,wymax;/* window bounds */
{
	text_alignment(plotfil,TA_CENTER,TA_TOP,0.0,0.0);	/* header */
	character_height(plotfil,.04*(wymax-wymin));
	text2d(plotfil,(wxmin+wxmax)/2.,wymax,
		header,VDC_TEXT,FALSE);
	text_alignment(plotfil,TA_CENTER,TA_TOP,0.0,0.0);	/* x-axis */
	character_height(plotfil,.04*(wymax-wymin));
	text2d(plotfil,(float)(wxmin+wxmax)/2.,(float)(wymin+ymin)/2.,
		xlabel,VDC_TEXT,FALSE);
	text_path(plotfil,PATH_DOWN);			/* y-axis */
	text_alignment(plotfil,TA_CENTER,TA_HALF,0.,0.);
	character_height(plotfil,.04*(wymax-wymin));
	text2d(plotfil,(wxmin+wxmin+xmin)/3.,(wymin+wymax)/2.,
		ylabel,VDC_TEXT,FALSE);
}
plot_tics(plotfil,xmin,xmax,xdelta,ymin,ymax,ydelta,wxmin,wxmax,wymin,wymax)
int	plotfil;
double	xmin,xmax;		/* min, max of all x-values */
double	ymin,ymax;		/* min, max of all y-values */
double	xdelta,ydelta;		/* increment for x/y tick marks */
double	wxmin,wxmax,wymin,wymax;/* window bounds */
{
	int i=0,j=0;
	char number[80];
	float numlargeticks;
	float x, y;

	text_path(plotfil,PATH_RIGHT);
	text_alignment(plotfil,TA_CENTER,TA_CONTINUOUS_VERTICAL,0.0,1.2);
	character_height(plotfil,.03*(wymax-wymin));
	line_type(plotfil,0);
	
	x=xmin;				/* x axis */
	sprintf(number,"%5.1lf",x);	/* char version of axis number */
	text2d(plotfil,x,ymin,number,VDC_TEXT,FALSE);
	numlargeticks=(((xmax-xmin)/xdelta)/5);
	for(i=numlargeticks;i--;){	/* large tick loop */
		for(j=5;j--;){		/* small tick loop */
			move2d(plotfil,x,ymin);	/* draw small tick */
			draw2d(plotfil,x,ymin+((ymax-ymin)*.015));
			x+=xdelta;		/* x for next small tick */
		}
		move2d(plotfil,x,ymin);		/* next large tick */
		draw2d(plotfil,x,ymin+((ymax-ymin)*.03));
		sprintf(number,"%5.1lf",x);	/* put number at large tick */
		text2d(plotfil,x,ymin,number,VDC_TEXT,FALSE);
	}
	text_alignment(plotfil,TA_CONTINUOUS_HORIZONTAL,TA_HALF,1.2,0.0);
	y=ymin;					/* y axis */
	sprintf(number,"%5.1lf",y);		/* string rep of # */
	text2d(plotfil,xmin,y,number,VDC_TEXT,FALSE);
	numlargeticks=(((ymax-ymin)/ydelta)/5);
	for (i=numlargeticks;i--;){
		for(j=5;j--;){
			move2d(plotfil,xmin,y);
			draw2d(plotfil,xmin+(xmax-xmin)*.02,y);
			y+=ydelta;
		}
		move2d(plotfil,xmin,y);
		draw2d(plotfil,xmin+(xmax-xmin)*.03,y);
		sprintf(number,"%5.1lf",y);
		text2d(plotfil,xmin,y,number,VDC_TEXT,FALSE);
	}
}



