/* subtotal.c 

Usage: subtotal by by-columnlist on on-columnlist < reldb-table

Controls doing subtotals of the on-columns for each set of fixed
values of all the by-columns.

This program just scans its arguments and generates a 
new command of the form: project colnames | addup number,
where addup adds up the relevant columns (assuming they
are in a decent order - making life much simpler).

Revision history:
	Original author:
		gunnar@hafro.is (1986 ?)
	Revisions due to incorrect string handling:
		gunnar@hafro.is (April, 1989)
*/
#include <stdio.h>
#ifdef BSD
#include <sys/wait.h>
#endif
#include <strings.h>
#define MAXCMD 1000
main(argc,argv)
int	argc;
char	*argv[];
{
	char	command[MAXCMD];
	char	*usage="Usage : subtotal by b1 b2 b3 ... on d1 d2 d3 ... < file\n";
	char	*ptr=command;
	int	count=0;
	int	debug=0;

	++argv;
	if(!strcmp(*argv,"-d")){
		debug=9;	/* assume full debug wanted */
		fprintf(stderr,"subtotal-debug level 9 used\n");
		argc--;
		++argv;
	}
	if(strcmp(*argv,"by"))
		errlog(usage);
	argv++;
	argc--;
	argc--;
	if(debug)fprintf(stderr,"subtotal: setting up project command\n");
	strcpy(ptr,"project ");
	ptr+=strlen(ptr);
	while(strcmp(*argv,"on")){
		strcpy(ptr,*argv);
		if(debug)fprintf(stderr,"\tby-column:%s\n",*argv);
		ptr+=strlen(ptr);
		*ptr++=' ';
		count++;
		argc--;argv++;
		if(argc<=0)
			errlog(usage);
	}
	argv++;argc--;
	if(debug)fprintf(stderr,"subtotal: finishing project command\n");
	while(argc){
		strcpy(ptr,*argv);
		if(debug)fprintf(stderr,"\ton-column:%s\n",*argv);
		ptr+=strlen(ptr);
		*ptr++=' ';
		argc--;argv++;
	}
	if(debug){
		sprintf(ptr," | addup %d %d\n",debug,count);
		fprintf(stderr,"COMMAND:->%s<-\n",command);
	} else {
		sprintf(ptr," | addup %d\n",count);
	}
	system(command);
#ifdef BSD
	wait((union wait *)0);
#else
        wait(0);
#endif
	exit(0);
}
errlog(s)
char	*s;
{
	fprintf(stderr,"%s",s);
	exit(1);
}
