/* recode:

	Author: gunnar@hafro.is (early 1988)

	Recodes first column in data (std. inp) according to
	1st+2nd column in filename of argument list.
*/
#include <stdio.h>
#define MAXOLD 10000	/* old values must be in the range 0 thru MAXOLD */
#define MAXLIN 1000	/* maximum length of input line */
#define USE "Usage : recode codefile < datafile \n"
main(argc,argv)
int argc;
char *argv[];
{
	char	inplin[MAXLIN];
	char	head[MAXLIN];	/* header: first of code file, then data file */
	char	*ptr;		/* temporary char pointer--loops over head*/
	char	*nmptr;		/* point to name of new code variable in head */
	int	o,n;		/* old/new codes from codefile */
	int	code[MAXOLD];	/* code transformations */
	FILE	*fp,*fopen();

	if((fp=fopen(argv[1],"r"))==NULL)	/* open code file */
		errlog(USE);
	fgets(head,MAXLIN,fp);			/* header line from code file */
	fgets(inplin,MAXLIN,fp);		/* skip second line */
	code[0] = -1;
	while(fgets(inplin,MAXLIN,fp)!=NULL){
		if(sscanf(inplin,"%d%d",&o,&n)!=2)	/* get code data */
			errlog("Error in code-file\n");
		o++;
		if(o<0||o>=MAXOLD)
			errlog("Error - old value outside range in codefile\n");
		code[o]=n;			/* store code data */
	}
	fclose(fp);				/* done with code file */
	for(ptr=head;*ptr!='\t';ptr++)		/* skip name of old col*/
		;					/* from code file */
	nmptr= ++ptr;				/* points to new col name */
	while(*ptr!='\n')
		putchar(*ptr++);		/* put new code name */
	*ptr='\0';				/* end the name */
	putchar('\t');				/* end the first outcol.*/
	fgets(inplin,MAXLIN,stdin);		/* get old data header */
	fputs(inplin,stdout);			/* append to output line */
	for(ptr=nmptr;*ptr;ptr++)		/* output correct # dashes */
		putchar('-');
	putchar('\t');				/* and the tab */
	fgets(inplin,MAXLIN,stdin);		/* get the dataline of dashes */
	fputs(inplin,stdout);			/* append to above dashes */
	while(fgets(inplin,MAXLIN,stdin)!=NULL){/* read a data line */
		if(sscanf(inplin,"%d",&o)!=1)
			errlog("recode : cannot read code from dataline\n");
		o++;
		if(o<0||o>MAXOLD)
			errlog("recode : code in data outside range \n");
		printf("%d\t%s",code[o],inplin);
	}
}
errlog(s)
char	*s;
{
	fprintf(stderr,"%s",s);
	exit(1);
}

