#!/bin/sh
#
# plot -- plot filter; controls execution of filter for
#                      appropriate device.
#
# DOES NOT CONTAIN AT&T CODE.
#
# There are currently available PD filters for at least HPGL, X11
# and Postscript. The first two are included in the reldb distribution,
# as the xplot program is new and the hpglplot program has been extended
# somewhat to accept a few extended plot(5)-commands.
#
# These three filters would seem to suffice for a very large number
# of applications. Development of general utilities which use the
# plot(5) output format would therefore seem to be of potentially 
# great use.
#
#
case $1 in
-T*)	devarg=$1
	shift ;;
*)	echo "Usage: plot -Tfilter [otherargs]"
	exit 1 ;;
esac
case $devarg in
-Thpgl)		hpglplot $* ;;
-TX*|-Tx*)	xplot $* ;;
-Tps*)		psplot $* ;;
-Tgrap*)	graplot $* ;;
esac
exit 0
