
#include <sgtty.h>
#include <stdio.h>
#include <math.h>

/* HP-GL plot(5) library				*/
/* - does NOT do line locking				*/
/* - aspect ratio is not maintained			*/
/* Jim Constantine	               	 		*/
/* Copyright 1985 Sun Microsystems Inc.			*/
/* Extensions by asta@hafro.is (March, 1989) 		*/
/* Prepared for redistribution by gunnar@hafro.is	*/
/* Notable features, which are really bugs: This 
   program assumes it is writing to a device. That 
   causes problems when writing to e.g. hpgl2ps filters.
   Use of some special HPGL escape sequences may also cause
   problems						*/

openpl()
{
    struct sgttyb   sgarg;
    int local;

    ioctl( fileno(stdout), TIOCGETP, &sgarg);
    ioctl( fileno(stdout), TIOCLGET, &local);
    sgarg.sg_ispeed = sgarg.sg_ospeed = B9600;
    sgarg.sg_erase = sgarg.sg_kill = '#';
    sgarg.sg_flags = EVENP | ODDP;
    local = LDECCTQ;
    ioctl( fileno(stdout), TIOCSETP, &sgarg);
    ioctl( fileno(stdout), TIOCLSET, &local);

    /*printf("IN;\033.P1:");		/* out - gs */
    printf("IN;");
    fflush(stdout);

    printf("PG;AP 3;CA 10;CC 20;SR 0.6,1.2;SP 1;\n");
    fflush(stdout);
}

move(x, y)
{
    printf("PU %d,%d;\n", x, y);
}

line(x1, y1, x2, y2)
{
    printf("PU %d,%d PD %d,%d;\n", x1, y1, x2, y2);
}

label(s)
    char   *s;
{
    printf("LB%s\03;\n", s);
}

erase()
{
    printf("PG;AF;\n");		/* feed page if paper has been writen on */
}

point(x, y)
{
    printf("PU %d,%d PD PU;\n", x, y);
}

cont(x, y)
{
    printf("PD %d,%d;\n", x, y);
}

space(x1, y1, x2, y2)
{
    printf("SC %d,%d %d,%d;\n", x1, x2, y1, y2);
}

arc(xc, yc, x1, y1, x2, y2)
{
    /* args are:  center, start, end */
    float angle;

    angle = atan((float) (y2 - y1) / (float) (x2 - x1)) * 5.729578e+01;
    if ((x2 - x1) < 0) angle = 180.0 + angle;
    move(x2,y2);
    printf("AA %d,%d;%6.3f\n", x1, y1, angle);
}

circle(x, y, r)
{
    move(x,y);
    printf("CI %d;\n",r);
}

linemod(s)			/* line style */
    char *s;
{
    switch(s[3]) {

    case 't': /* dotTed */
	printf("LT 1;\n");
	break;

    case 'i': /* solId */
    default:
	printf("LT ;\n");
	break;
 
    case 'g': /* lonGdashed */
	printf("LT 3;\n");
	break;

    case 'r': /* shoRtdashed */
	printf("LT 2;\n");
	break;

    case 'd': /* dotDashed */
	printf("LT 4;\n");
	break;
    }
}

labelrotation(s)
    char *s;
{

    switch(s[1]) {

    case 'h': /* horizontal */
	printf("DI 1,0;\n");
	break;

    case 'v': /* vertical */
	printf("DI 0,1;\n");
	break;
    } 
}


labelplace(s)
    char *s;
{

    switch(s[1]) {

    case 'u': /* center the label under the point */
	printf("LO16;\n");
	break;

    case 'o': /* center the label over the point */
	printf("LO14;\n");
	break;

    case 'l': /* center the label left at the point */
	printf("LO18;\n");
	break;

    case 'r': /* center the label right at the point */
	printf("LO12;\n");
	break;

    case 'c': /* center the label at the point */
	printf("LO15;\n");
	break;

    default: /* center the label at the point */
	printf("LO15;\n");
	break;
    } 
}

selectcolor(s)
    char *s;
{

    switch(s[1]) {

    case '1': /* select pen 1 */
	printf("SP 1;\n");
	break;

    case '2': /* select pen 2 */
	printf("SP 2;\n");
	break;

    case '3': /* select pen 3 */
	printf("SP 3;\n");
	break;

    case '4': /* select pen 4 */
	printf("SP 4;\n");
	break;

    case '5': /* select pen 5 */
	printf("SP 5;\n");
	break;

    case '6': /* select pen 6 */
	printf("SP 6;\n");
	break;

    case '7': /* select pen 7 */
	printf("SP 7;\n");
	break;

    case '8': /* select pen 8 */
	printf("SP 8;\n");
	break;

    default: /* select pen 1 */
	printf("SP 1;\n");
	break;
    } 
}

closepl()
{
    printf ("SP;NR;PG;\n");
}

