#!/bin/sh
#
# testdb -- user script for testing reldb programs.
#

RELDBDIR=/usr/local/src/Reldb/testdb

if [ ! -d $RELDBDIR ]
then
	echo "I can't seem to find the test data and programs"
	echo "Please edit my RELDBDIR variable properly"
	echo "(It is now set to $RELDBDIR, which is incorrect)"
	exit 1
fi

# Go home first - no need to clutter discs
cd
if [ ! -d testdb ]
then
	mkdir testdb
fi
cd testdb
PWD=`pwd`
echo Testing reldb programs in $PWD
echo "Copying programs and data - hold on ..."
cp $RELDBDIR/* .
echo "Running 'make' - this willl result in a number of .tmp-files"
make
echo "Feel free to examine the .tmp-files. If everything is"
echo "working properly, they should be identical to the"
echo "corresponding .res-files"
