#!/bin/sh 
#
# Shell script to rename columns in a reldb data file.
#
# Usage :  rename old1 new1 old2 new2 old3 new3 ...
#
# The script simply builds a (fairly complex) sed-command.
# The command is inserted into the string cmd and
# is later piped into the shell, along with the data.
# Note that echo will not work due to tab-expansion
cmd=sed
while(true)
do
	if [ X$1 != X ]
	then
		name1=$1
		name2=$2
		shift
		shift
		cmd="$cmd -e "\""1s/\\(	*\\)$name1\\(	*\\)/\\1$name2\\2/"\"
	else
		( cat <<xxxx==
$cmd
xxxx==
cat - )  | sh
		exit
	fi
done

