/*
	matrix:

	A program for setting up a simple frequency table,
	based on (count,x,y)-data
								*/
#include <stdio.h>
#define MAXX 250
#define MAXY 50
#define MINX 0
#define MINY 0
#define MAXLIN 500
#define MAXNAM 10
main(argc,argv)
int argc;
char *argv[];
{
	char line[MAXLIN],xname[MAXNAM],yname[MAXNAM],dum[MAXNAM];
	char *format="\t%f";	/* Output table default format */
	
	static float freq[MAXX][MAXY];	/* the frequencies */
	float marg[MAXX];		/* marginal frequencies */
	int x,y;		/* input data : x,y, freq of x,y */
	float n;
	int testmarg=1;		/* =1=>skip empty lines =0=>print them*/
	int minx,maxx,miny,maxy;/* computed bounds on input data */
	
	while(--argc){
		if(argv[1][0]=='-'){
			if(argv[1][1]=='e')
				testmarg=0;	/* print empty lines */
			else{
				fprintf(stderr,"Incorrect argument to matrix\n");
				fprintf(stderr,"Usage : matrix [-e] [format]\n");
				fprintf(stderr,"         -e : print empty lines\n");
				fprintf(stderr,"          format : C printf format, default : %s\n",format);
				exit(1);
			}
		} else {
			format=argv[1];
		}
		argv++;
	}
	fgets(line,MAXLIN,stdin);	/* Reldb header line */
	sscanf(line,"%s %s %s",dum,xname,yname);/* get names of columns */
	fgets(line,MAXLIN,stdin);	/* Reldb dash-line */

	minx=MAXX;maxx=MINX;miny=MAXY;maxy=MINY;
	while(fgets(line,MAXLIN,stdin)!=NULL){
		sscanf(line,"%f %d %d",&n,&x,&y);
		if(x>=MAXX||y>=MAXY){
			fprintf(stderr,"Bound error : %s\n",line);
			continue;
		}
		++x;++y;
		freq[x][y]+=n;
		marg[x]+=n;
		if(x>=maxx)maxx=x;
		if(y>=maxy)maxy=y;
		if(x<=minx)minx=x;
		if(y<=miny)miny=y;
	}
	printf("%s",xname);
	for(y=miny-1;y<maxy;){
		printf("\t%s%d",yname,y++);
	}
	printf("\n--");
	for(y=miny-1;y<maxy;y++){
		printf("\t----");
	}
	printf("\n");
	for(x=minx;x<=maxx;x++){
		if(marg[x]==0&&testmarg)
			continue;		/* skip empties */
		printf("%d",x-1);
		for(y=miny-1;y<maxy;){
			printf(format,freq[x][++y]);
		}
		printf("\n");
	}
} /* main */
