/* program to join many length distributions into one file.
	Just for fun, we compute these as a percentage distribution.

	Use: joinle files

	The only thing to watch out for is that lines may be
	missing in some files and the max/min-lengths will
	not be the same in all files.

Those not concerned with marine research might not be so hot
on length distributions -- let me know if you can transform this
into something more generally useful.
*/
#include <stdio.h>
#define MAXFILES 50			/* max # of files */
#define MAXLEN=350			/* max fish length*/
#define MAXLINE 1000			/* max length of input line */
int matrix[MAXLEN][MAXFILES]; /*Matrix of length distributions */
main(argc,argv)
int argc;
char **argv;
{
	FILE *fp;
	FILE *fopen();
	char **filelist=argv;
	char *curfile;
	
	int minlen=999999;
	int maxlen= -999999;
	int le,colnr;			/* indices into file no & length */
	int fj;
	int debug=0;			/* -d gives debug */
	char inpline[MAXLINE];

	int totals[MAXFILES];

	curfile= *++filelist;
	if(!strncmp(*filelist,"-d",2)){
		debug=1;
		*filelist++;
		*argv++;
		argc--;
	}

	/* Now go through all the files */

	for(colnr=1;colnr<argc;colnr++) {
		/* first verify that the next argument is a file */
		curfile= *filelist;
		if(debug)fprintf(stderr,"Next file, %s", curfile);
		if(debug)fprintf(stderr,".a.");
		if((fp = fopen(*filelist++,"r"))==NULL){
			fprintf(stderr,"Cannot open named file, %s\n",curfile);
			exit(1);
		}
		totals[colnr]=0;
		if(debug)fprintf(stderr,".b.");
		if(debug)fprintf(stderr,"Reading input file %s",curfile);
		if(debug)fprintf(stderr,".c.");
		fgets(inpline,MAXLINE,fp);	/* skip header */
		fgets(inpline,MAXLINE,fp);	/* skip header */
		if(debug)fprintf(stderr,".d.");
		while(fgets(inpline,MAXLINE,fp)!=NULL){
			if(debug)fprintf(stderr,".e.");
			sscanf(inpline,"%d %d",&le,&fj);
			if(le<0 || le > MAXLEN){
				fprintf(stderr,"Illegal length in file %s\n",*--filelist);
				fprintf(stderr,"Line is %s\n",inpline);
				exit(1);
			}
			if(le<minlen)minlen=le;
			if(le>maxlen)maxlen=le;
			matrix[le][colnr]=fj;
			totals[colnr]+=fj;
		}
		fclose(fp);
		if(debug)fprintf(stderr,"\n");
	}
	printf("le");
	for(colnr=1;colnr<argc;colnr++){
		printf("	%s",*++argv);
	}
	printf("\n");
	printf("--");
	for(colnr=1;colnr<argc;colnr++){
		printf("	--------");
	}
	printf("\n");
	for(le=minlen;le<=maxlen;le++){
		printf("%d",le);
		for(colnr=1;colnr<argc;colnr++){
			printf("	%.2lf",100.*(double)matrix[le][colnr]/
				(double)totals[colnr]);
		}
		printf("\n");
	}
}
