#!/bin/sh
#
# check - checks sanity of reldb tables.
#
# The initial sed-command simply places dots in between two
# adjacent tabs, to guarantee that they are regarded as two
# fields by awk.
for i 
do
	sed 's/		/	.	/g
	s/		/	.	/g' < $i |\
	awk 'BEGIN {FS="	"}
	NR==1{
		reclen=NF
		error=0}
	NR==2{
		if(NF!=reclen){
			print "Dashes do not match column heads"
			error=1
		}
	}
	NR>2 {
		if(NF!=reclen){
			print "Error in line number ",NR,"fields ",NF," headers ",reclen;error=1
		}
	}
	END {
		if(error==0)
		print "Table '$i' is ok"
	}'
done
