/*
	Procedure addup.

Usage: addup p < data

	Typical input line : a(1) a(2) ... a(p) b(1) ... b(nb)
	Output : For each level of (a(1),...,a(p)), print
		the sum  of all the b's.
	The a's are referred to as the 'by'-variables;
	The b's are the 'on'-variables.

Revision history:
	Original author : 
			gunnar@hafro.is (sometime in 86)
	All sorts of additions
		Mainly incorrect string manipulations
		also some dubious use of intermixed float and double -
		now all double.
			gunnar@hafro.is (April, 1989)
General comments:
	This program is rarely used directly by a human.
	Rather, it is a piece of the subtotal program,
	- subtotal call first project to order the by-variables
	first and then pipes the output into addup.
	This is what's called quick-and-dirty programming,
	but it's a heck of a lot simpler than having to
	build project into subtotal.
						*/


#include <stdio.h>
#include <strings.h>

#ifndef DEBUG
#define DEBUG 0		/* Define positive for debug (can override in Makefile*/
#endif

#define MAXV 25		/* maximum number of a-variables */
#define MAXLIN 150	/* maximum line length */

int debug=DEBUG;	/* debug level*/
int p;			/* numerical equiv. of arguments = number of by-vbls*/
int nonvar;		/* number of on-variables */
int i;			/* index */
double x[MAXV];		/* input b-vbls (i.e. one line at a time) */

main(argc,argv)
int argc;
char *argv[];
{
	char line[MAXLIN];	/* input line */
	char oldline[MAXLIN];	/* previous input line */
	int c;
	double sum[MAXV];	/* vector of sums for a b-val*/

        /* read argument = # vbls into p */
	if(debug)
		fprintf(stderr,"Into addup-routine\n");
	if(argc==2 ){
        	if(sscanf(argv[1], "%d", &p) != 1) {
			printf("usage: addup  p \n or: addup debuglevel p\n");
                	return(-1);
        	}
	} else if (argc==3){
        	if(sscanf(argv[1], "%d", &debug) != 1) {
			printf("usage: addup  p \n or: addup debuglevel p\n");
                	return(-1);
        	}
        	if(sscanf(argv[2], "%d", &p) != 1) {
			printf("usage: addup  p \n or: addup debuglevel p\n");
                	return(-1);
        	}
	} else {
		printf("usage: addup  p \n or: addup debuglevel p\n");
                return(-1);
	}
	if(debug>=2)
		fprintf(stderr,"Got argument:->%d<-\n",p);
	if(fgets(oldline,MAXLIN,stdin)==NULL){
		fprintf(stderr,"Cannot read first line of input\n");
		exit(1);
	}
	if(debug>=5)
		fprintf(stderr,"Got header:->%s<-\n",oldline);
	fputs(oldline,stdout);
	if(fgets(oldline,MAXLIN,stdin)==NULL){
		fprintf(stderr,"Cannot read second line of input\n");
		exit(1);
	}
	fputs(oldline,stdout);
	c=getline(oldline,p,x);
	nonvar=c;
	if(debug>=5){
		fprintf(stderr,"Got first dataline(on-part):->%s<-\n",oldline);
		fprintf(stderr,"\tGot sum-variable:->%d<-\n",x[0]);
		fprintf(stderr,"\t# on vars:%d\n",nonvar);
		}
	addup(sum);
	while(c!=EOF){
		c=getline(line,p,x);
		if(debug>=5){
			fprintf(stderr,"Got dataline(on-part):->%s<-\n",line);
			fprintf(stderr,"\tGot sum-variable:->%lf<-\n",x[0]);
			fprintf(stderr,"\t# on vars:%d\n",c);
		}
		if(	c!=EOF && 
			strlen(oldline)==strlen(line) && 
			!strcmp(oldline,line)	){

			if(debug>=5){
				fprintf(stderr,"Same by-columns-adding\n");
			}
			addup(sum);/* same a-vbls;add */
		}else{
			if(debug>=5){
				fprintf(stderr,"New by-cols-print old line(%s):\n",oldline);
			}
			output(oldline,sum);	/* output */
			if(debug>=5){
				fprintf(stderr,"\told line>%s< becomes >%s<",oldline,line);
			}
			(void)strcpy(oldline,line);	/* copy header */
			if(c!=EOF)
				addup(sum);/* new and final a's*/
		}
	}
        return(0);
}

getline(line,p,x)
char line[MAXLIN];	/* remainder of input line (the b's=by-columns)*/
int p;			/* no of vbls */
double x[MAXV];		/* columns to be summed */
{
	int i=0;
	int count=1;
	int	c;
	char	tmplin[MAXLIN];
	if((c=getchar())==EOF)
		return(EOF);
	do {
		line[i++]=c;
		while((c=getchar())!='\t')	/* get 'by' part as a string */
			line[i++]=c;
		count++;
	}while(count<=p);
	line[i]='\0';
	if(debug>=5)fprintf(stderr,"Input:by-vbls >%s<\n",line);
	count=0;
	do {
		i=0;
		c=getchar();
		while(c!='\t'&&c!='\n'){
			tmplin[i++]=c;
			c=getchar();
		}
		tmplin[i]='\0';
		if(debug>=5)fprintf(stderr,"\t next on-vbl >%s<\n",tmplin);
		if(i!=0){
			sscanf(tmplin,"%lf",&x[count]);	/* get 'on' variables */
			if(debug>=5)fprintf(stderr,"\t on-vbl:%lf\n",x[count]);
		} else {
			if(debug>=5)fprintf(stderr,"\t empty on-vbl\n");
			x[count]=0.;
		}
		count++;
	} while(c!='\n');
	return(count);

}	/* getline */

addup(sum)
double sum[MAXV];	/* vector of sums */
{
	static int first=1;
	if(debug>=2)
		fprintf(stderr,"Adding up:\n");
	if(first){
		if(debug>=5)
			fprintf(stderr,"\tinit\n");
		for(i=0;i<nonvar;i++){
			sum[i]=0.;		/* initialize*/
		first=0;
		}
	}
	for(i=0;i<nonvar;i++){
		if(debug>=5)
			fprintf(stderr,"\tAdding %lf to %lf\n",x[i],sum[i]);
		sum[i]+=x[i];		/* sum for vbl i */
	}
}	/* addup */
	
output(oldline,sum)
char oldline[MAXLIN];	/* previous input line, a-values (on) */
double sum[MAXV];	/* vector of sums (b's-on vbls) for a fixed a-val*/
{
	for(i=0;i<MAXLIN&&oldline[i]!='\0'&oldline[i]!='\n';i++)
		printf("%c",oldline[i]);	/* print text in beg. of line */
	for(i=0;i<nonvar;i++){			/* cut down digits output */
		if((double)(int)sum[i] == sum[i])
			printf("	%ld",(long)sum[i]);
		else if((double)(int)sum[i]<sum[i]-.00001||sum[i]<1.)
			printf("	%lf",sum[i]);
		else
			printf("	%ld",(long)sum[i]);
		sum[i]=0;
	}
	printf("\n");
}
