/* definitions for rk_button, written by John Darragh, Calgary, revised 3-89
 */
#include <ctype.h>
#include <stdio.h>

#define false		0
#define true		1
#define nil		((NodePtr)0)
#define MAX_SET		128	     /* max # of different symbols (ASCII) */
#define TOP_K		10

#define START		0            /* values for state variables         */
#define SCANNING	1
#define FOUND		2
#define END		3

typedef struct node {                /** variable length Markov tree node **/
        char           value;        /*  ASCII symbol value (to MAX_SET-1) */
        char           count;        /*  frequency count (to max_freq)     */
        struct node    *next;        /*  alternative predictions at this k */
        struct node    *up;          /*  next k level up, eg 3 points to 4 */
} Node;
typedef Node  *NodePtr;              /** a pointer to a tree node	  **/
typedef NodePtr Buffer[TOP_K+1];     /*  k ptrs into the tree k contexts   */

NodePtr scan_up(), move_up();
char    first_pred();
