/* LINTLIBRARY */

#include "file+rk.h"		/* JJD 3-89 */
#include "rk_button.h"		/* JJD 9-86 */
#include "functions.h"		/* MLJ 5-89 */
#include <sys/types.h>
#include <sys/time.h>
#include <sys/errno.h>
#include <sys/stat.h>  
#include <signal.h>
#include <sys/wait.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <stdio.h>
#include <sys/file.h>
char           *getenv();
#include <pwd.h>

/* struct passwd *pwd; */

/* Global Variables */

extern          errno;

int             pty_master, pty_slave, tty;
struct sgttyb   new_stdin, old_stdin;

struct sgttyb   pty_sgtty;

char            tc_ent[1024], tc_seq_buf[1024], *clear_to_eol;
char           *cursor_left, *cursor_right;
char           *enter_insert_mode, *exit_insert_mode;
char           *pre_insert_char, *post_insert_char;
char           *enter_delete_mode, *exit_delete_mode, *delete_a_char;
char           *clear_screen;
char           *enter_standout_mode, *exit_standout_mode;	/* JJD 9-86 */

char            pred_buff[MAX_CMD_LINE_LENGTH];	/* JJD 9-86 */
char            pred_on_display = 0;	/* JJD 9-86 */
char            pred_mode = 1;	/* JJD 9-86 */
int             pred_number = 0;/* JJD 9-86 */
char		show_eol_mode = 1;
char            nl_truncate_mode = 1;	/* JJD 9-86 */
char            eol_only_mode = 1;	/* JJD 9-86 */
char            eol_longer_mode = 1;	/* JJD 9-86 */
char            lisp_mode = 0;
char		add_space_mode = 0;
char		silent=0;
char		login=1;

int             (*keymap[128][MAXEXTENSIONS]) ();
char            meta_prefixes[MAXEXTENSIONS][MAXEXTENSIONS];
int		meta_map[MAXEXTENSIONS][MAXEXTENSIONS];
int		current_key_map=0;
char		next_free_map=1;
char	       *shellname;

ED_STRUCT       editor_data;

char            output_string[1024], temp_str[1024];
int             output_string_length;
int 		finished=0;
int		childid;

int		num_buffers=64;


void childdied()
{
	union wait      w;
	register int    pid;

	while ((pid = wait3(&w, WUNTRACED | WNOHANG, 0)) > 0) {
		if (WIFSTOPPED(w)) {
			fprintf(stderr,"Stopped.\r\n");
		} else if (WIFEXITED(w)) {
		} else if (WIFSIGNALED(w)) {
			fprintf(stderr,"Killed.\r\n");
		}

				/* if this is our shell who died, shut down */
		if(pid==childid){	
			abortit("\r\n",0);
		}
	}
	return;
}

void cleanup()
{
	abortit("Segmentation fault, aborting...\n",-1);
}



int READ(d, buf, nbytes)
int d;
char *buf;
int nbytes;
{
	int ret;
	static int count=0;
	
	if((ret=read(d,buf,nbytes))<-1){
		if(errno==EBADF){
			if(count){
				perror("Read");
				abortit("",-1);
			} else {
				count++;
				sleep(1);  /* wait for the signal */
			}
		} else {
			perror("Read");
			abortit("",-1);
		}
	} else {
		return(ret);
	}
}

main(argc, argv)
	int             argc;
	char          *argv[];
{

	char           *getenv();	/* JJD 3-89 added */
	get_termcap_stuff();
	get_command_line_arguments(argc,argv);
	set_up_keymap();
	get_key_bindings(); 
	init();
	set_up_buffers();
	file();
	/*NOTREACHED*/
	shutdown_pty_and_tty();
	shutdown_();
	abortit("",1);		/* JJD 3-89 added 1 */
}


get_termcap_stuff()
{

	char           *termname, *tbuf, *getenv(), *tgetstr();

	termname = getenv("TERM");
	if (!termname) {
		enter_insert_mode = exit_insert_mode = pre_insert_char =
			post_insert_char = 0;
		enter_delete_mode = exit_delete_mode = delete_a_char = 0;
		cursor_right = 0;
		cursor_left = "\010";
		clear_screen = 0;
		enter_standout_mode = exit_standout_mode = 0;	/* JJD 9-86 */
		return;
	}
	tbuf = tc_seq_buf;
	if (tgetent(tc_ent, termname) != 1) {
		enter_insert_mode = exit_insert_mode = pre_insert_char = 0;
		post_insert_char = enter_delete_mode = exit_delete_mode = 0;
		delete_a_char = cursor_right = clear_screen = 0;
		cursor_left = "\010";
		enter_standout_mode = exit_standout_mode = 0;	/* JJD 9-86 */
		return;
	}
	if (tgetflag("bs"))
		cursor_left = "\010";
	else
		cursor_left = tgetstr("bc", &tbuf);

	clear_to_eol = tgetstr("ce", &tbuf);
	cursor_right = tgetstr("nd", &tbuf);
	enter_insert_mode = tgetstr("im", &tbuf);
	exit_insert_mode = tgetstr("ei", &tbuf);
	pre_insert_char = tgetstr("ic", &tbuf);
	post_insert_char = tgetstr("ip", &tbuf);
	enter_delete_mode = tgetstr("dm", &tbuf);
	exit_delete_mode = tgetstr("ed", &tbuf);
	delete_a_char = tgetstr("dc", &tbuf);
	clear_screen = tgetstr("cl", &tbuf);
	enter_standout_mode = tgetstr("so", &tbuf);	/* JJD 9-86 */
	exit_standout_mode = tgetstr("se", &tbuf);	/* JJD 9-86 */

	if (!enter_standout_mode || !exit_standout_mode)	/* JJD 9-86 */
		enter_standout_mode = exit_standout_mode = 0;

	if (!enter_delete_mode || !exit_delete_mode)
		enter_delete_mode = exit_delete_mode = 0;

	if (!enter_insert_mode || !exit_insert_mode)
		enter_insert_mode = exit_insert_mode = 0;
}

#define LETTERS "pqr"

init()
{
	int             i = 48, c = 0;
	char            buf[100];
	struct sgttyb   master_sgttyb,slave_sgttyb;
	int             pid;




	while (--i >= 0) {
		sprintf(buf, "/dev/pty%c%x", LETTERS[c >> 4], c & 15);
		if ((pty_master = open(buf, (O_RDWR | O_EXCL))) != -1)
			break;
		c++;
	}
	if (i <= 0) {
		printf("Unable to open a pty, aborting...\r\n");
		abortit("",-1);
	}
	ioctl(0, TIOCGETP, &old_stdin);
	ioctl(0, TIOCGETP, &new_stdin);
	new_stdin.sg_flags |= (CBREAK|RAW|CRMOD);
	new_stdin.sg_flags &= ~(ECHO);
	ioctl(0, TIOCSETP, &new_stdin);

	ioctl(pty_master, TIOCGETP, &master_sgttyb);
	master_sgttyb.sg_flags &= ~(RAW | CBREAK| LCASE);
	master_sgttyb.sg_flags |= (ECHO | CRMOD | FF0);
	master_sgttyb.sg_ospeed = old_stdin.sg_ospeed;
	master_sgttyb.sg_ispeed = old_stdin.sg_ispeed;
	ioctl(pty_master, TIOCSETP, &master_sgttyb);

	switch (pid = fork()) {
	case -1:
		perror("Fork");
		abortit("",-1);
		break;
	case 0:
		signal(SIGINT, SIG_DFL);
		signal(SIGQUIT, SIG_DFL);
		if ((tty = open("/dev/tty", O_RDWR)) < 0) {
			perror("/dev/tty");
			abortit("",-1);
		}
		ioctl(tty, TIOCNOTTY, &pid);
		close(tty);
		close(pty_master);
		close(0);
		sprintf(buf, "/dev/tty%c%x", LETTERS[c >> 4], c & 15);
		if ((pty_slave = open(buf, (O_RDWR | O_EXCL))) < 0) {
			perror(buf);
			abortit("",-1);
		}
		dup2(0, 1);
		dup2(0, 2);
		ioctl(0, TIOCGETP, &slave_sgttyb);
		slave_sgttyb.sg_flags &= ~(RAW | CBREAK| LCASE);
		slave_sgttyb.sg_flags |= (ECHO | FF0 | CRMOD );
		slave_sgttyb.sg_ospeed = old_stdin.sg_ospeed;
		slave_sgttyb.sg_ispeed = old_stdin.sg_ispeed;
		ioctl(0, TIOCSETP, &slave_sgttyb);
		pid = getpid();
		if (setpgrp(0, pid) < 0) {
			perror("Setpgrp");
			abortit("",-1);
		}
		ioctl(0, TIOCSPGRP, &pid);
		shellname = (char *)getenv ("SHELL");
		if(!shellname)
			shellname="/bin/csh";
		if(login){
			if (execl(shellname, "-", (char *) 0) < 0) {
				perror("execl");
				abortit("",-1);
			}
		} else {
			if (execl(shellname, "csh", (char *) 0) < 0) {
				perror("execl");
				abortit("",-1);
			}
		}
			
		break;

	default:childid=pid;
		break;
	}
}

set_up_buffers()
{

	int             num_buffs;
	struct ed_buffs *prev_ptr;

	editor_data.current_ed_buff_ptr =
		(struct ed_buffs *) malloc(sizeof(struct ed_buffs));

	prev_ptr = editor_data.current_ed_buff_ptr;
	prev_ptr->dot = prev_ptr->string;
	prev_ptr->mark = prev_ptr->string;	/* JJD 3-89 added */

	for (num_buffs = num_buffers - 1; num_buffs; --num_buffs) {
		prev_ptr->next_ptr =
			(struct ed_buffs *) malloc(sizeof(struct ed_buffs));
		prev_ptr->next_ptr->prev_ptr = prev_ptr;
		prev_ptr = prev_ptr->next_ptr;
		prev_ptr->dot = prev_ptr->string;
		prev_ptr->mark = prev_ptr->string;	/* JJD 3-89 added */
		*(prev_ptr->dot) = '\0';
	}

	prev_ptr->next_ptr = editor_data.current_ed_buff_ptr;
	editor_data.current_ed_buff_ptr->prev_ptr = prev_ptr;

	editor_data.current_input_char = '\0';
	editor_data.universal_argument = 1;
	editor_data.current_buffer = editor_data.current_ed_buff_ptr->string;
	editor_data.dot = editor_data.current_buffer;
	/* JJD 3-89 added */
	editor_data.mark = editor_data.current_ed_buff_ptr->mark;
	editor_data.current_buffer[0] = '\0';
	output_string[0] = '\0';
	output_string_length = 0;
	temp_str[0] = '\0';
}


set_up_keymap()
{
	int x,y;
	char buf[4];

	buf[1]=0;

	for(y=0;y<MAXEXTENSIONS;y++){
		for(x=0;x<MAXEXTENSIONS;x++){
			meta_prefixes[x][y]=0;
			meta_map[x][y]=0;
		}
	}

	for(y=0;y<MAXEXTENSIONS;y++){
		for(x=0;x<128;x++){
			keymap[x][y]=BOGUS;
		}
	}



	bind_to_key("^@",set_mark);/* CTRL-@ or CTRL-sp *//* JJD 3-89 */
   	bind_to_key("^A",beginning_of_line);	/* CTRL-A */
	bind_to_key("^B",backward_char);	/* CTRL-B */
	bind_to_key("^C",file_completion);	/* CTRL-C *//* JJD 2-89 */
	bind_to_key("^D",delete_char);	/* CTRL-D */
	bind_to_key("^E",end_of_line);	/* CTRL-E */
	bind_to_key("^F",forward_char);	/* CTRL-F */
	bind_to_key("^G",backspace_word);	/* CTRL-G *//* JJD 2-89 */
	bind_to_key("^H",backspace_char);	/* CTRL-H & backspace key */
	bind_to_key("^I",self_insert);	/* CTRL-I & TAB key       */
	bind_to_key("^J",finish_editing_line);	/* CTRL-J */
	bind_to_key("^K",discard_rest_of_line);	/* CTRL-K */
	bind_to_key("^L",clear_display);	/* CTRL-L */
	bind_to_key("^M",finish_editing_line);	/* CTRL-M */
	bind_to_key("^N",next_line);	/* CTRL-N */
	bind_to_key("^O",previous_pred);	/* CTRL-O *//* JJD 9-86 */
	bind_to_key("^P",previous_line);	/* CTRL-P */
	bind_to_key("^Q",accept_forward_char);	/* CTRL-Q *//* JJD 9-86 */
	bind_to_key("^R",next_pred);	/* CTRL-R *//* JJD 9-86 */
	bind_to_key("^S",accept_to_end_of_line);	/* CTRL-S *//* JJD 9-86 */
	bind_to_key("^T",twiddle_chars);	/* CTRL-T */
	bind_to_key("^U",increment_universal_argument);	/* CTRL-U */
	bind_to_key("^V",quote_char);	/* CTRL-V *//* JJD 9-86 */
	bind_to_key("^W",accept_forward_word);	/* CTRL-W *//* JJD 9-86 */
	bind_to_key("^X",show_mark);	/* CTRL-X *//* JJD 3-89 */
	bind_to_key("^Y",yank_from_kill_buffer);	/* CTRL-Y */
	bind_to_key("^Z",insert_suspend_char);	/* CTRL-Z */
	bind_to_key("^\\",command_completion);	/* CTRL-\ */ 
	bind_to_key("\035",BOGUS);
	bind_to_key("^^",insert_stop_char);	/* CTRL-^ *//* JJD 9-86 */
	bind_to_key("^_",insert_start_char);	/* CTRL-_ *//* JJD 9-86 */
	for(x=' ';x<'(';x++){
		buf[0]=x;
		bind_to_key(buf,self_insert);
	}
	bind_to_key("(",open_paren);	/* electric-( *//* Elec-( */
	bind_to_key(")",close_paren);	/* electric-) *//* Elec-) */
	for(x='*';x< '\\';x++){
		buf[0]=x;
		bind_to_key(buf,self_insert);
	}
	bind_to_key("\\\\",self_insert); /* need 4 \'s ! */
	bind_to_key("]",self_insert);
	bind_to_key("\\^",self_insert);
	for(x='_';x<= '~';x++){
		buf[0]=x;
		bind_to_key(buf,self_insert);
	}

	bind_to_key("\177",insert_interrupt_char);	/* DEL key *//* JJD 2-89 */
	

	bind_to_key("^[^[",discard_current_edit_line);	/* ESC-ESC */
	bind_to_key("^[ ",toggle_add_space_mode);	/* ESC-space */
	bind_to_key("^[(",backward_paren);	/* ESC-( */
	bind_to_key("^[)",forward_paren);	/* ESC-) */
	bind_to_key("^[-",ul_to_dash_word);	/* ESC--  */
	bind_to_key("^[=",previous_line);	/* ESC-=  */
	bind_to_key("^[?",describe_bindings);	/* ESC-?  */
	bind_to_key("^[E",toggle_eol_only_mode);	/* ESC-E  *//* JJD 9-86 */
	bind_to_key("^[C",describe_arguments);
	bind_to_key("^[F",toggle_eol_longer_mode);	/* ESC-F  *//* JJD 9-86 */
	bind_to_key("^[L",toggle_lisp_mode);	/* ESC-L  */
	bind_to_key("^[N",toggle_nl_truncate_mode);	/* ESC-N  *//* JJD 9-86 */
	bind_to_key("^[P",toggle_pred_mode);	/* ESC-P  *//* JJD 9-86 */
	bind_to_key("^[Q",insert_quit_char);	/* ESC-Q  *//* JJD 3-89 */
	bind_to_key("^[S",toggle_show_eol_mode);
	bind_to_key("^[_",dash_to_ul_word);	/* ESC-_  */
	bind_to_key("^[b",backward_word);	/* ESC-b  */
	bind_to_key("^[c",capitalize_word);	/* ESC-c  */
	bind_to_key("^[d",delete_word);	/* ESC-d  */
	bind_to_key("^[e",toggle_eol_only_mode);	/* ESC-e  *//* JJD 9-86 */
	bind_to_key("^[f",forward_word);	/* ESC-f  */
	bind_to_key("^[g",prime_from_file);	/* ESC-g  *//* JJD 9-86 */
	bind_to_key("^[h",backspace_word);	/* ESC-h  */
	bind_to_key("^[k",delete_region_to_killbuffer);	/* ESC-k  *//* JJD 3-89 */
	bind_to_key("^[l",lowercase_word);	/* ESC-l  */
	bind_to_key("^[m",run_mesg);	/* ESC-m  */
	bind_to_key("^[o",run_pp);/* ESC-o  *//* JJD 9-86 */
	bind_to_key("^[p",toggle_pred_mode);	/* ESC-p  *//* JJD 9-86 */
	bind_to_key("^[q",show_free_nodes);	/* ESC-q  *//* JJD 1-87 */
	bind_to_key("^[r",run_tty_program);	/* ESC-r  */
	bind_to_key("^[t",BOGUS);
	bind_to_key("^[t",run_talk);	/* ESC-t  */
	bind_to_key("^[u",uppercase_word);	/* ESC-u  */
	bind_to_key("^[v",show_version);	/* ESC-v  *//* JJD 3-89 */
	bind_to_key("^[w",run_write);	/* ESC-w  */
	bind_to_key("^[z",run_ruptime);	/* ESC-z  *//* JJD 2-89 */

	bind_termcap_key("ku",previous_line);	/* ESC-[-A */
	bind_termcap_key("kd",next_line);	/* ESC-[-B */
	bind_termcap_key("kl",backward_char);	/* ESC-[-C */
	bind_termcap_key("kr",forward_char);	/* ESC-[-D */
}


file()
{
	int             status;

	fd_set readfd;
	int num;
	char buf[1024];

	if(!silent){
		printf("Welcome to the Reactive Keyboard. \r\n");
		printf("Written at the University of Calgary. \r\n");
		printf("Version:%s\r\n",VERSION);
		printf("Please wait until your shell prompt appears (ESC-? for help).\r\n");
	}
	init_reactive();	/* MAY TAKE TIME CREATING FREE LIST,     JJD
				 * 9-86 */
	signal(SIGCHLD, childdied);
	signal(SIGSEGV, cleanup);
	if (pred_mode) make_a_prediction (pred_buff); 
	while(1){
		if (pred_mode && pred_buff[0]) {
			/*
			 * if (pred_mode && !(eol_only_mode &&
			 * *(editor_data.dot))) JJD 9-86
			 */
			ioctl(pty_master, TIOCGETP, &pty_sgtty);
			if ((pty_sgtty.sg_flags & ECHO) &&
			    !(pty_sgtty.sg_flags & (RAW | CBREAK)))
				display_pred_buffer(&editor_data);
		}
		FD_ZERO(&readfd);
		FD_SET(0,&readfd);
		FD_SET(pty_master,&readfd);
		if(select(getdtablesize(),&readfd,0,0,0)<0){
			if( errno == EINTR ){
				errno = 0;
				continue;
			}
			else
				perror("Select");
		}
		if( FD_ISSET(0,&readfd)){
			ioctl(pty_master, TIOCGETP, &pty_sgtty);
			if ((pty_sgtty.sg_flags & ECHO) &&
			  !(pty_sgtty.sg_flags & (RAW | CBREAK))) {
				num = edit_line(buf);
			} else
			num = READ(0, buf, 1024);
			write(pty_master, buf, num);
		}
		if( FD_ISSET(pty_master,&readfd)){
			if (pred_on_display)
				erase_pred_buffer(&editor_data);	/* JJD9-86 */
			erase_current_edit_line (&editor_data);
			/* JJD: no FILE, keep bigger read size */
			num = READ(pty_master, buf, 1024);
			write(1, buf, num);
		}	
	}
}


shutdown_pty_and_tty()
{
	close(pty_master);
	ioctl(0, TIOCSETP, &old_stdin);
}


int 
edit_line(c)
	char           *c;
{

	char            ch;
	int             status, num;
	fd_set readfd;
	char            tstring[1024], *cptr;
	int             count;
	struct stat     buf;	/* JJD 3-89 was 512 */

	struct ed_buffs *buf_to_use, *cur_line;
	FILE           *from, *popen();

	status = OK;

	buf_to_use = editor_data.current_ed_buff_ptr;
	while ((status == OK) || (status == HAVE_CHAR)) {
		FD_ZERO(&readfd);
		FD_SET(0,&readfd);
		FD_SET(pty_master,&readfd);
		if(select(getdtablesize(),&readfd,0,0,0)<0){
			if( errno == EINTR ){
				errno = 0;
				continue;
			}
			else
				perror("Select");
		}
		if( FD_ISSET(0,&readfd)){
			READ(0, &ch, 1);
			ch &= 127;	/* Must do this due to parity bit
					 * over dial-up lines */
			/* Possibly needed for other lines too.          */
			editor_data.current_input_char = ch;
			if (pred_on_display)
					erase_pred_buffer(&editor_data);
				status = keymap[(int) ch][0] (&editor_data);
			if (pred_mode && ((status == OK) || (status == HAVE_CHAR))) {
				make_a_prediction(pred_buff);
				if (pred_buff[0])
					display_pred_buffer(&editor_data);
			}
		}else{
			num = READ(pty_master, temp_str, 32);
			if(num){
				erase_current_edit_line(&editor_data);
				write(1, temp_str, num);
				draw_current_edit_line (&editor_data);
				if (pred_buff[0]&&pred_mode)
					display_pred_buffer(&editor_data);
			}

		}
		/* MOVED if (pred_mode... up into if (readfds... above */
	}

	switch (status) {
	case FINISHED_EDITING:
		strcpy(c, editor_data.current_buffer);
		if ((strlen(c) != 0)) {
			if (stat(c, &buf) != -1) {	/* if just a directory
							 * name on command line,
							 * assume cd  */

				/*
				 * JJD: this is kind of dicey as is, assumes
				 * a bit too much about dir names
				 */
				/*
				 * it should check that it is the only thing
				 * on the line for one thing
				 */

				if ((buf.st_mode & S_IFMT) == S_IFDIR) {
					if (strcmp(".", c) != 0) {	/* JJD 3-89 del . case
									 * for ed... */
						strcpy(tstring, "cd ");
						strcat(tstring, c);
						strcpy(c, tstring);
					}
				}
			}
		}
		/*
		 * JJD: to be really useful, this should also know about
		 * pushd and popd
		 */

		if ((strncmp(c, "cd ", 3) == 0) ||
		    (strncmp(c, "chdir ", 6) == 0) ||
		    (strcmp(c, "cd") == 0) ||
		    (strcmp(c, "chdir") == 0)) {
			if (strncmp(c, "cd ", 3) == 0)
				cptr = &c[2];	/* JJD 3-89, c[-1]  */
			else
				cptr = &c[5];
			while ((*cptr == ' ') || (*cptr == '\t'))
				cptr++;
			if ((*cptr == '\0') ||
			    (strcmp(c, "chdir") == 0) ||
			    (strcmp(c, "cd") == 0))
				strcpy(tstring, getenv("HOME"));
			else {
				tstring[0] = '\0';
				if (*cptr == '~') {	/* JJD 3-89 added
							 * abspath, rewrote */
					char           *optr = cptr;
					if (*(++cptr)) {
						while ((*cptr != '\0') && (*cptr != ';'))
							cptr++;
						*cptr = '\0';
						if(myabspath(optr, tstring))
							strcpy(tstring,".");
							/* we have an error so stay in the current dir */
					} else {
						strcpy(tstring, getenv("HOME"));
					}	/* ... to here */
					count = strlen(tstring);
				} else 
					count = 0;
				for (; (*cptr != '\0') && (*cptr != ';'); cptr++, count++)
					tstring[count] = *cptr;
				tstring[count] = '\0';
	
			}
			chdir(tstring);
		}
		strcat(c, "\n");/* JJD 2-89 changed ^M to \n */
		cur_line = editor_data.current_ed_buff_ptr;
		cur_line->dot = editor_data.dot;
		cur_line->mark = editor_data.mark;
		if (cur_line != buf_to_use) {
			strcpy(buf_to_use->string, cur_line->string);
			buf_to_use->dot =
				&buf_to_use->string[cur_line->dot - cur_line->string];
			buf_to_use->mark =
				&buf_to_use->string[cur_line->mark - cur_line->string];

		}
		if (*(buf_to_use->string)) {
			editor_data.current_ed_buff_ptr = buf_to_use->next_ptr;
			editor_data.current_ed_buff_ptr->dot =
				editor_data.current_ed_buff_ptr->string;
			editor_data.dot = editor_data.current_ed_buff_ptr->dot;
			/*
			 * editor_data.current_ed_buff_ptr->mark =
			 * editor_data.current_ed_buff_ptr->string;
			 */
			editor_data.mark = editor_data.current_ed_buff_ptr->mark;
			*editor_data.dot = '\0';
			editor_data.current_buffer = editor_data.dot;
		} else {
			editor_data.current_ed_buff_ptr = buf_to_use;
			editor_data.current_buffer = buf_to_use->string;
			editor_data.dot = buf_to_use->dot;
			editor_data.mark = buf_to_use->mark;
		}

		strcat(c, "");
		update_the_model(c);	/* JJD 9-86 */
		if (pred_mode)
			make_a_prediction(pred_buff);	/* JJD 9-86 */
		return strlen(c);
		break;

	case FINISHED_BUT_DONT_ADD_CTRL_M:
		strcpy(c, editor_data.current_buffer);
		editor_data.dot = editor_data.current_buffer;
		editor_data.mark = editor_data.current_buffer;
		*editor_data.dot = '\0';
		return (strlen(c));
		break;
	}
	strcpy(c, "");
	return 0;
}


int 
get_display_length(s)
	char           *s;
{

	char           *cptr;
	int             len;

	cptr = s;
	len = 0;
	while (*cptr) {
		if ((*cptr < 32) || (*cptr == 127))
			len += 2;
		else
			len++;
		++cptr;
	}
	return len;
}

int 
get_char_display_length(c)
	char            c;
{

	int             len;

	len = 0;
	if ((c < 32) || (c == 127))
		len = 2;
	else
		len++;
	return len;
}

int 
display_string_into_output_string(s)
	char           *s;
{

	int             len;
	char           *cptr;

	cptr = s;
	len = 0;
	while (*cptr) {
		if (*cptr < 32) {
			len += 2;
			output_string[output_string_length++] = '^';
			output_string[output_string_length++] =
				*cptr++ + '@';
		} else if (*cptr == 127) {
			len += 2;
			output_string[output_string_length++] = '^';
			output_string[output_string_length++] = '?';
			++cptr;
		} else {
			len++;
			output_string[output_string_length++] = *cptr++;
		}
	}

	return len;
}

int 
display_char_into_output_string(c)
	char            c;
{

	int             len;

	len = 0;
	if (c < 32) {
		len += 2;
		output_string[output_string_length++] = '^';
		output_string[output_string_length++] = c + '@';
	} else if (c == 127) {
		len += 2;
		output_string[output_string_length++] = '^';
		output_string[output_string_length++] = '?';
	} else {
		len++;
		output_string[output_string_length++] = c;
	}

	return len;
}

int 
erase_current_edit_line(e)
	ED_STRUCT      *e;
{

	int             num_to_erase, count;
	char           *old_dot;

	/*
	 * added to deal with META-prefixes which turn pred display on...may
	 * not work for all cases
	 */
	if (pred_on_display)
		erase_pred_buffer(e);	/* JJD 9-86 */
	old_dot = e->dot;
	beginning_of_line(e);
	e->dot = old_dot;
	output_string_length = 0;

	num_to_erase = get_display_length(e->current_buffer);
	for (count = num_to_erase; count; --count)
		output_string[output_string_length++] = ' ';
	for (count = num_to_erase; count; --count)
		tputs(cursor_left, ONE_LINE, append_to_output_string);
	write(1, output_string, output_string_length);

	return OK;
}

int 
draw_current_edit_line(e)
	ED_STRUCT      *e;
{

	int             count;

	output_string_length = 0;
	display_string_into_output_string(e->current_buffer);
	count = get_display_length(e->dot);
	for (; count; --count)
		tputs(cursor_left, ONE_LINE, append_to_output_string);
	write(1, output_string, output_string_length);

	return OK;
}
