#define ZERO_FREQ_FILE "/.rk.zero_freq"
#define PRIME_FILE "/.rk.log_file"
#define KEY_FILE "/.rk.keys"

#include "file+rk.h"
#include "rk_button.h"
#include "sys/file.h"
#include <stdio.h>

print_help()
{
	printf("RK command line arguments:\n");

	printf("	-b <buffers>	The number of buffers used by rk to save previous\n");
	printf("			 commands used by 'previous_line'. Default: 60.\n\n");

	printf("	-e <length>	The maximum length of predictions at the end of the\n");
	printf("			line. Default: 40.\n\n");


	printf("	-f <count>	The maximum frequency count for any given context\n");
	printf("			Default: 128\n\n");

	printf("	-i <length>	The maximum length of predictions in the middle of\n");
	printf("			the line. Default: 8.\n\n");

	printf("	-k <keys file>	The file to read key bindings from.\n");
	printf("			Default:$HOME/.rk.keys\n\n");

	printf("	-n <nodes>	The amount of memory to allocate initially to speed\n");
	printf("			up creation of nodes.  After this memory is used up,\n");
	printf("			more will be allocated, but this will be slower.\n");
	printf("			Default: 64*1024 nodes.\n\n");

	printf("	-o <order>	This argument controls how deep a tree will be built\n");
	printf("			by rk inorder to make predictions.  As order\n");
	printf("			increases, the accuracy of predictions increases,\n");
	printf("			but the speed decreases. Default: 8.\n\n");
	printf("	-p <prime file>	The file used to prime the Reactive Keyboard.\n");
	printf("			Default:$HOME/.rk.log_file.\n\n");


	printf("	-s <startup>	The maximum number of characters to be read from the\n");
	printf("			 prime file at startup. Default: 16*1024.\n\n");

	printf("	-z <zero freq>	The zero frequency file name.\n");
	printf("			Default:$HOME/.rk.zero_freq\n\n");

	printf("	-A	Toggle add_space_mode\n");
	printf("	-E	Toggle eol_only mode.\n");
	printf("	-L	Toggle eol_longer mode.\n");
	printf("	-N	Toggle truncate at newline mode.\n");
	printf("	-P	Toggle predictions on/off.\n");
	printf("	-S	Toggle show_eol_mode.\n");
	printf("	-g	Make this not a login shell.\n");
	printf("	-h	Print this help.\n");
	printf("	-l	Toggle lisp mode.\n");
	printf("	-m	Start up silently.\n");
	printf("	-v	Print Version.\n");

}

print_version()
{
	char            tbuf[128];
	printf("RK_Button Version:%s.\n", RK_VERSION);
}

extern ED_STRUCT editor_data;


get_command_line_arguments(argc,argv)
int argc;
char *argv[];
{
	extern int optind;
	extern char *optarg;
	int i;

	extern num_buffers;
	extern char *zero_freq_file;
	static char z_freq_buf[256];
	extern char *prime_file;
	static char prime_buf[256];
	extern char *key_file;
	static char key_buf[256];
	extern	max_len;
	extern	max_eol;
	extern	maxk;
	extern	maxprime;
	extern  max_freq;
	extern  max_nodes;
	extern  char silent;
	extern  char login;
	extern  char pred_mode,
		     pred_on_display,
		     lisp_mode,
		     nl_truncate_mode,
		     eol_only_mode,
		     eol_longer_mode,
	             add_space_mode,
		     show_eol_mode;
	
	zero_freq_file=prime_file=key_file=NULL;

	while ((i = getopt(argc, argv,"b:e:f:i:k:n:o:p:s:z:AELNPSghlmv")) 
				!= EOF) {
		switch( i ) {
		case 'b': num_buffers=atoi(optarg)+1;
			if(num_buffers<1)
				abortit("-b:Buffers must be larger than 1.\n",-1);
			break;
			/* 1.. MAXINT*/
		case 'e': max_eol=atoi(optarg);
			if((max_eol<1)||(max_eol>132))
				abortit("-e:End of line length must be between 1 and 132.\n",-1);
			break;
			/* 1..132 */
		case 'f': max_freq=atoi(optarg);
			if((max_freq<3)||(max_freq>255))
				abortit("-f:Maximum Frequency must be between 3 and 255.\n",-1);
			break;
		case 'i': max_len=atoi(optarg);
			if((max_len<1)||(max_len>132))
				abortit("-i:Inline Length must be between 1 and 132.\n",-1);
			break;
			/* 1..132 */
		case 'k':
			if( key_file ) {
				fprintf(stderr,"%s: Too many -k options\n",argv[0]);
				abortit("",1);
			}
			key_file=optarg;
			/* check for existance */
			if(access(key_file,R_OK)){
				perror(key_file);
				abortit("",-1);
			}		
		 	break;
		case 'n': max_nodes=atoi(optarg);
			if(max_nodes<0)
				abortit("-n:Number of nodes must be positive.\n",-1);
			break;				
		case 'o': maxk=atoi(optarg);
			if((maxk<3)||(maxk>TOP_K)){
				fprintf(stderr,"-o: Order must be between 3 and %d.\n",TOP_K);
				abortit("",-1);
			}
			break;
		case 'p':
 			if( prime_file ) {
				fprintf(stderr, "%s: Too many -p options\n",argv[0]);
				abortit("",1);
			}
			prime_file=optarg;
			/* check for existance */
			if(access(prime_file,(R_OK|W_OK))){
				perror(prime_file);
				abortit("",-1);
			}		
			break;
		case 's': maxprime=atoi(optarg); break;

		case 'z': 
 			if( zero_freq_file ) {
				fprintf(stderr, "%s: Too many -z options\n",argv[0]);
				abortit("",1);
			}
			zero_freq_file=optarg;
			/* check for existance */
			if(access(zero_freq_file,(R_OK|W_OK))){
				perror(zero_freq_file);
				abortit("",-1);
			}		
			break;
		case 'A': add_space_mode=!add_space_mode;	break;
		case 'E': eol_only_mode=!eol_only_mode;		break;
		case 'L': eol_longer_mode=!eol_longer_mode;	break;
		case 'N': nl_truncate_mode=!nl_truncate_mode;	break;
		case 'P': pred_mode=!pred_mode;			break;
		case 'S': show_eol_mode=!show_eol_mode;		break;
		case 'g': login=!login; 			break;
		case 'h': print_help();	abortit("",0);		break;
		case 'l': lisp_mode=!lisp_mode;			break;
		case 'm': silent=1;				break;
		case 'v': print_version();abortit("",0);	break;
		

		default:
			fprintf(stderr,"\r%s: Use -h for help\r\n", argv[0]);
			abortit("",-1);
		}
	
	}
	
	if(zero_freq_file==NULL){
		strcpy(z_freq_buf, getenv("HOME"));
		strcat(z_freq_buf, ZERO_FREQ_FILE );
		zero_freq_file=z_freq_buf;
	}
	if(prime_file==NULL){
		strcpy(prime_buf, getenv("HOME"));
		strcat(prime_buf, PRIME_FILE );
		prime_file=prime_buf;
	}
	if(key_file==NULL){
		strcpy(key_buf, getenv("HOME"));
		strcat(key_buf, KEY_FILE );
		key_file=key_buf;
	}

}
