/* "FILE's" link to rk_button, written by John Darragh, Calgary, revised 3-89
 *
 * these are the main function used by file+rk.c to generate predictions
 */
#include "rk_button.h"
#include "file+rk.h"

extern int	 pred_number;		      /* Defined in file+rk.c   */
extern char	 nl_truncate_mode,
		 eol_only_mode,
		 eol_longer_mode;
		 show_eol_mode;
extern ED_STRUCT editor_data;

extern char   first[MAX_SET],		      /* Defined in rk_button.c */
              context[MAX_CMD_LINE_LENGTH],
              old_context[MAX_CMD_LINE_LENGTH];
extern Buffer Buf, CBuf;
extern char   *prime_file;
extern char   pred_on_display;
int max_len=8;
int max_eol=30;
int maxk=8;
int max_freq=127;
int max_nodes=256*1024;  			/* 256K */


static char   temp[1024];			  /* scratch string buf */


make_a_prediction (s) char *s; {    /* sets s to the current prediction */

	char *a = temp; int length, i;
	
	if (eol_only_mode && *(editor_data.dot)) { *s = '\0'; return; }
        strcpy (temp, context);
	strcat (temp, editor_data.current_buffer);
	length = strlen (temp) - strlen (editor_data.dot);
	temp[length] = '\0';
	if (length > maxk) a = &temp[length - maxk];

	if (strcmp (old_context, a)) pred_number = 0;
	strcpy (old_context, a);
	
	for (i=1; i<=maxk; i++) CBuf[i] = nil;
	while (*a) {
	    for (i=maxk; i>0; i--) CBuf[i] = scan_up(CBuf[i-1],*a);
	    a++;
	}
	find_first(CBuf);
        build_menu(CBuf, s);
    }

update_the_model (s) char *s; { /* adds s into the model & updates log */

	char *a = s, *c = s; int length, i; FILE *to;

	if (strlen(s) < maxk) {
            strcpy (temp, context);
    	    strcat (temp, s);
	    length = strlen (temp);
	    if (length > maxk) a = &temp[length - maxk];
	    else a = temp;
	}
	strcpy (context, a);
	while (*c) {
	    for (i=maxk; i>0; i--) Buf[i] = move_up(Buf[i-1],*c);
	    c++;
	}			/* do not save "empty" lines in the log file */
	    			/* reopen to append log, otherwise create it */
        if (s[0] != '\n') {	/* now log can be manipulated and still used */
	    if ((to = fopen (prime_file, "a")) == NULL) {
		sprintf (temp, "cannot reopen or create: %s\n", prime_file);
		abortit (temp, -1);
	    }
	    fputs (s, to); fflush (to);
	    fclose(to);
	}
}

build_menu(buf,s) Buffer buf; char *s; { /* fill out prediction in s */

	int i,j,length; Buffer tbuf; char *bptr = s, c;

	if (eol_longer_mode && !(*(editor_data.dot))) {
	    length = max_eol
	    	     - get_display_length(editor_data.current_buffer);
	    if (length < max_len) length = max_len;
	} else length = max_len;

	c = first[pred_number];
	for (i=0; i<=maxk; i++) tbuf[i] = buf[i];
	for (i=1; i<=length; i++) {
		if (show_eol_mode)
			*bptr++ = c;
		else if((c != '\n') || (i==1))
			*bptr++ = c;
		if (nl_truncate_mode && (c == '\n')) goto bp;
		for (j=maxk; j>=1; j--) tbuf[j] = scan_up (tbuf[j-1],c);
		c = first_pred(tbuf);
	    }
bp:	*bptr = '\0';
}


shutdown_() {
    FILE *to;
    if ((to = fopen (prime_file, "a")) != NULL) {
        fputs ("\07", to);  fflush (to);  fclose(to);
    }
}

abortit (message, status)
char *message;
int status;
{
    if(pred_on_display)
	erase_pred_buffer(&editor_data);
    shutdown_pty_and_tty();
    shutdown_();
    fprintf (stderr, "%s", message);
    fflush (stdout); fflush (stderr);
    exit (status);
}
