#include "rk_button.h"		     
#include "file+rk.h"

extern maxk;
extern max_nodes;
extern max_freq;
int maxprime=16*1024;

				     /** shared with rk_file/file+rk **/
char   first[MAX_SET],		     /* the first letter of each pred */
       context[MAX_CMD_LINE_LENGTH] = "\07",   /* last chars entered */
       old_context[MAX_CMD_LINE_LENGTH] = "\07";
Buffer Buf, CBuf;		     /* ptrs into the model k levels  */
char   *prime_file;		     /* file to prime from and log to */
int    next_free = 0;		     /* index of next free node avail */
long   psize;			     /* # chars to prime from prime_file*/
				     /* zero freqs, maybe overwritten */
static char zero_freq[128] = {	     /* by a user supplied $home/file */
  '\n',   ' ',   'e',   's',   't',   'r',   'a',   'l',
   'n',   '.',   'c',   'i',   'm',   'o',   'd',   'h',
   'p',   'u',   'f',   'b',   'w',   'g',   '-',   'y',
   '/',   'v',   'k',   '*',   'x',   '5',   '1',   '2',
   '4',   '>',   'q', '\07',   '3',   'z',   '0',   'j',
   'M',   'I',   '6',  '\'',   'E',   '~',   'A',   ',',
   'S',   'D',   'R',   '?',   'C',   '|',   'B',   'T',
   'P',   'U',   '!',   '_',   '<',   'N',   '8',   '@',
   '&',   '7',  '\\',   '"',   'J',   ')',   '(',   '[',
   ']',   'F',   'L',   ':',   'O',   'K',   '9',   'H',
   '+',   '$',   'W',   'Y',   '=',   'G',   ';',   '^',
   '{',   'X',   'Q',   '#',   '}',   'V',   '%',   'Z',
   '`',  '\b',  '\t', '\26', '\00', '\01', '\02', '\03',
 '\04', '\05', '\06', '\13',  '\f',  '\r', '\16', '\17',
 '\20', '\21', '\22', '\23', '\24', '\25', '\27', '\30',
 '\31', '\32', '\33', '\34', '\35', '\36', '\37','\177',};

char *zero_freq_file;

static char    pred_set[MAX_SET];    /* flags chars already in first[]*/

static NodePtr free_nodes;	     /* now use malloc to get at init */
static NodePtr root;		     /* the root of the k model trie  */

NodePtr create_node() {		     /* return ptr to a new node or abort */
	if (next_free >= max_nodes) {
		char *malloc(); NodePtr nptr;
		nptr = (NodePtr) malloc((unsigned) sizeof(Node));
		if (nptr == nil)         /* SHOULD FORGET AND CONTINUE ON */
			abortit ("Out of memory in create_node.\n",-1);
		next_free++;		      /* just for show_free_nodes */
	        return(nptr);			  /* if more are needed   */
	} else  return(&free_nodes[next_free++]); /* first nodes upto MAX */
}

NodePtr move_up(nptr, c) NodePtr nptr; char c; {

	NodePtr xptr, fxptr, last_ptr, last_fptr; int state;

	if (nptr == nil) xptr = nil;
	else {
         if (nptr->up == nil) state = START;
         else {
            fxptr = xptr = nptr->up;  last_fptr = last_ptr = nil;
            state = SCANNING;
            do {
               if (xptr == nil) state = END;
               else {
                  if (fxptr->count > xptr->count) {
		     last_fptr = last_ptr;  fxptr = xptr; }
                  if (xptr->value == c) {
                     state = FOUND;
                     if (fxptr != xptr) {
                        if (last_fptr == nil) nptr->up = xptr;
                        else last_fptr->next = xptr;
                        last_ptr->next = xptr->next;  xptr->next = fxptr;
                  }  } else { last_ptr = xptr;  xptr = xptr->next; }
            }  } while (state == SCANNING);
         }
         switch (state) {
         case FOUND:
	 	if (++(xptr->count) == max_freq) { /* Forgets on halving 1 */
		    /*last_fptr =*/ fxptr = nptr->up;
		    while (fxptr != nil) {		 /* JJD 9-86 */
			fxptr->count++;
			fxptr->count >>= 1;
/* DOESN'T FORGET A NODES SUBTREE NODES YET SO DON'T DO IT */
/* MAY HAcE TO INCREASE max_freq TO REDUCE HALcING & OcERHEAD */
/* 			if (fxptr->count == 0) {
			    last_fptr->next = fxptr->next;
write(1,"1/2 free\n",9);
			    Free(fxptr);
			    fxptr = last_fptr->next;
			} else {
			    last_fptr = fxptr; */
			    fxptr = fxptr->next;
			
		    }
		}
		break;
         case START: case END:
               xptr = create_node();
               xptr->value = c;  xptr->count = 1;
               xptr->up = xptr->next = nil;
	       if (state == START) nptr->up = xptr;
	       else last_ptr->next = xptr;
               break;
	}}
	return (xptr);
}

find_first(buf) Buffer buf; { /* find 1st char of all pred in context */

	int i, order = 0; NodePtr xptr; char *p;

        for (p= &pred_set[0]; p< &pred_set[MAX_SET]; p++) *p = '\0';
	for (i=maxk-1; i>=0; i--) {      
	    if (buf[i] != nil)
	    if (buf[i]->up != nil) {
		xptr = buf[i]->up;
		while (xptr != nil) {
		    if (!pred_set[(int)xptr->value]) {
			pred_set[(int)xptr->value]++;
			first[order++] = xptr->value;
		    }  
		    xptr = xptr->next;
	}   }	}
        for (p= &zero_freq[0]; p< &zero_freq[MAX_SET]; p++)
	    if (!pred_set[(int)*p]) first[order++] = *p;
}

char first_pred(buf) Buffer buf; {
    int i = maxk-1;
    for (;;) {
	if (buf[i] != nil)
	    if (buf[i]->up != nil) return (buf[i]->up->value);
	if (i == 0) return((char)1);
	i--;
    }
}

NodePtr scan_up(nptr,c) NodePtr nptr; char c; {

	NodePtr xptr;
	if (nptr == nil) return(nil);
	else {
		xptr = nptr->up;
		for (;;) {
			if (xptr == nil) return (nil);
			else if (xptr->value == c) return(xptr);
			else xptr = xptr->next;
	}	}
}

init_reactive() {
	double atof(), u;
	register int i; FILE *from, *popen();
	char c, *b, *rindex(), tbuf[256], home[128];
	char cbuf[32+1], *cstart, *cend, *end; int full; long size;

				/* get a bunch of nodes for starters	    */
	free_nodes = (NodePtr) malloc((unsigned) (max_nodes * sizeof(Node)));
        if (free_nodes == nil) {
            sprintf (tbuf, "cannot allocate %d nodes.\n", max_nodes);
            abortit (tbuf, -1);
	}
				/* set up root and pointers into model      */
	CBuf[0] = Buf[0]	    = root = create_node();
	root->up    = root->next = nil;
	root->count = 1;
	for (i=1; i<=maxk; i++) Buf[i] = nil;
        if ((from = fopen (zero_freq_file, "r")) != NULL) {
		i = 0;
		while (((int)(c = getc(from))) != EOF) {
		    zero_freq[i++] = c;
		    if (((int)(c = getc(from))) == EOF) break; /* del NL */
		    if (i>127) break;			 /* test if okay */
		}
	} /* else use built in zero_freq[] */
				/* calc amount to prime, sys load dependent*/
	if ((from = popen ("uptime", "r")) != NULL) {
	    fgets (tbuf, 128, from);
	    b = rindex (tbuf, ':');  b++;
	    u = atof(b);
	    pclose (from);
	} else u = 1.0;
	if (u > 1.0) psize = (long) ((double)((double) maxprime) / u);
	else	     psize = (long) (maxprime);
				/* if user has .rk.log_file, prime from it */
        if ((from = fopen (prime_file, "r")) != NULL) {
	    fseek (from, 0L, 2);		/* find out how long it is */
	    size = ftell (from);
	    if (size > psize) {			/* prime max chars at end  */
		fseek (from, -psize, 2);           /* start after ^G mark  */
/* on second thought, if not "logged" by rk, may be no ^Gs in the file     */
/* 	        while ((((int)(c = getc(from))) != EOF) && (c != '\07')) ;*/
	    } else rewind (from);
	    cstart = cend = cbuf; end = &cbuf[maxk]; full = 0;
	    while (((int)(c = getc(from))) != EOF) {
		*cstart = c;
		if (full) { ++cstart; if (cstart > end) cstart = cbuf; }
		if (++cend > end) { cend = cbuf; full = 1; }
		*cend = '\0';
        	for (i=maxk; i>0; i--) Buf[i] = move_up(Buf[i-1],c);
	    }
	    i = 0;		/* align the context */
	    while (cstart != cend) {
		context[i] = old_context[i] = *cstart++; i++;
		if (cstart > end) cstart = cbuf;
	    }
	    fclose (from);	
	}
}

