#include "file+rk.h"
#include "rk_button.h"
#include <sys/ioctl.h>
#include <stdio.h>

extern char *cursor_left, *cursor_right;
extern char *enter_insert_mode, *exit_insert_mode;
extern char *pre_insert_char, *post_insert_char;
extern char *enter_delete_mode, *exit_delete_mode, *delete_a_char;
extern char *clear_screen;
extern char *enter_standout_mode, *exit_standout_mode;	/* JJD 9-86 */
extern int  current_key_map;
extern char meta_prefixes[MAXEXTENSIONS][MAXEXTENSIONS];
extern int  meta_map[MAXEXTENSIONS][MAXEXTENSIONS];

extern pred_number;
extern pty_master;
extern char output_string[],temp_str[];
extern output_string_length;
extern char pred_mode,pred_on_display,lisp_mode,nl_truncate_mode,eol_only_mode,eol_longer_mode,add_space_mode,show_eol_mode;
extern char pred_buff[];
extern (*keymap[128][MAXEXTENSIONS]) ();
extern char trace_mode;
extern struct sgttyb   new_stdin, old_stdin;
extern int maxk;
extern int maxprime;
extern max_freq;
extern max_nodes;

append_to_output_string(c)
	char            c;
{
	output_string[output_string_length++] = c;
}

int 
accept_forward_word(e)
	ED_STRUCT      *e;
{				/* JJD 9-86 */
	char           *ch;
	int             how_many, num_to_advance;

	if (!pred_mode)
		return forward_word(e);
	how_many = e->universal_argument;
	num_to_advance = 0;
	/* truncate prediction to after first NL */
	if (ch = index(pred_buff, '\n'))
		*(++ch) = '\0';
	ch = &pred_buff[0];	/* changed from editor data */

	while (how_many--) {
		if ((!isalnum(*ch)) && (*ch != '-') && (*ch != '_'))
			while (*ch && (!isalnum(*ch)) && (*ch != '-') && (*ch != '_'))
				num_to_advance++, ch++;

		while (*ch && (isalnum(*ch) || (*ch == '-') || (*ch == '_')))
			num_to_advance++, ch++;
		if(isspace(*ch)&&add_space_mode&&(*ch!='\n'))
			num_to_advance++, ch++;
		if (*ch == '\0')
			how_many = 0;
	}

	e->universal_argument = num_to_advance;
	return accept_forward_char(e);	
}

int BOGUS(e)
	ED_STRUCT      *e;
{
	    e->universal_argument = 1;
	    write (1, "\07", 1);
	    return(OK);
}

int 
forward_word(e)
	ED_STRUCT      *e;
{

	char           *ch;
	int             how_many, num_to_advance;

	how_many = e->universal_argument;
	num_to_advance = 0;
	ch = e->dot;

	while (how_many--) {
		if ((!isalnum(*ch)) && (*ch != '-') && (*ch != '_'))
			while (*ch && (!isalnum(*ch)) && (*ch != '-') && (*ch != '_'))
				num_to_advance++, ch++;

		while (*ch && (isalnum(*ch) || (*ch == '-') || (*ch == '_')))
			num_to_advance++, ch++;

		if (*ch == '\0')
			how_many = 0;
	}

	e->universal_argument = num_to_advance;
	return forward_char(e);
}


int 
backward_word(e)
	ED_STRUCT      *e;
{

	char           *ch, *cb;
	int             num_to_go, how_many;

	cb = e->current_buffer;
	ch = e->dot;
	num_to_go = 0;
	how_many = e->universal_argument;

	if (ch-- == cb)
		return OK;

	while (how_many--) {
		while ((ch >= cb) && (!isalnum(*ch)) && (*ch != '-') && (*ch != '_'))
			num_to_go++, ch--;

		while ((ch >= cb) &&
		       (isalnum(*ch) ||
			(*ch == '-') ||
			(*ch == '_')))
			num_to_go++, ch--;

		if (ch < e->current_buffer)
			how_many = 0;
	}

	e->universal_argument = num_to_go;
	return backward_char(e);
}


int 
delete_word(e)
	ED_STRUCT      *e;
{

	char           *ch;
	int             how_many, num_to_advance;

	how_many = e->universal_argument;
	num_to_advance = 0;
	ch = e->dot;

	while (how_many--) {
		if ((!isalnum(*ch)) && (*ch != '-') && (*ch != '_'))
			while (*ch && (!isalnum(*ch)) && (*ch != '-') && (*ch != '_'))
				num_to_advance++, ch++;

		while (*ch && (isalnum(*ch) || (*ch == '-') || (*ch == '_')))
			num_to_advance++, ch++;

		if (*ch == '\0')
			how_many = 0;
	}

	e->universal_argument = num_to_advance;
	return delete_char(e);
}


int 
backspace_word(e)
	ED_STRUCT      *e;
{

	char           *ch, *cb;
	int             num_to_go, how_many;

	cb = e->current_buffer;
	ch = e->dot;
	num_to_go = 0;
	how_many = e->universal_argument;

	if (ch-- == cb)
		return OK;

	while (how_many--) {
		while ((ch >= cb) && (!isalnum(*ch)) && (*ch != '-') && (*ch != '_'))
			num_to_go++, ch--;

		while ((ch >= cb) &&
		       (isalnum(*ch) ||
			(*ch == '-') ||
			(*ch == '_')))
			num_to_go++, ch--;

		if (ch < e->current_buffer)
			how_many = 0;
	}

	e->universal_argument = num_to_go;
	return backspace_char(e);
}


int 
forward_paren(e)
	ED_STRUCT      *e;
{

	char           *ch = e->dot - 1;	/* pretend to go back one */
	int             paren_count = 1;
	int             num_to_advance = 0;

	while (*++ch && paren_count) {
		num_to_advance++;
		if (*ch == ')')
			paren_count--;	/* a ')' with no intervening ()'s */
		else if (*ch == '(')	/* search for ) matching this ( */
			while (*++ch && paren_count) {
				num_to_advance++;
				if (*ch == ')')
					paren_count--;
				else if (*ch == '(')
					paren_count++;
			}
	}

	e->universal_argument = num_to_advance;
	return forward_char(e);
}


int 
backward_paren(e)
	ED_STRUCT      *e;
{

	char           *ch, *cb;
	int             paren_count = 1;
	int             num_to_go = 0;

	ch = e->dot;
	cb = e->current_buffer;

	if (ch != cb)		/* not already at the beginning */
		while ((--ch >= cb) && paren_count) {
			num_to_go++;
			if (*ch == '(')
				paren_count--;	/* a '(' with no intervening
						 * ()'s */
			else if (*ch == ')')	/* search for ( matching this
						 * ) */
				while ((--ch >= cb) && paren_count) {
					num_to_go++;
					if (*ch == '(')
						paren_count--;
					else if (*ch == ')')
						paren_count++;
				}
		}

	e->universal_argument = num_to_go;
	return backward_char(e);
}

int 
toggle_lisp_mode(e)
	ED_STRUCT      *e;
{
	lisp_mode = !lisp_mode;
	return OK;
}

int 
toggle_add_space_mode(e)
	ED_STRUCT      *e;
{
	add_space_mode = !add_space_mode;
	return OK;
}

int 
toggle_show_eol_mode(e)
	ED_STRUCT      *e;
{
	show_eol_mode = !show_eol_mode;
	if (pred_on_display)
		erase_pred_buffer(e);
	if (pred_mode)
		make_a_prediction(pred_buff);
	return OK;
}

int 
toggle_nl_truncate_mode(e)
	ED_STRUCT      *e;
{				/* JJD 9-86 */
	nl_truncate_mode = !nl_truncate_mode;
	if (pred_on_display)
		erase_pred_buffer(e);
	if (pred_mode)
		make_a_prediction(pred_buff);
	return OK;
}

int 
toggle_eol_only_mode(e)
	ED_STRUCT      *e;
{				/* JJD 9-86 */
	eol_only_mode = !eol_only_mode;
	if (pred_on_display)
		erase_pred_buffer(e);
	if (pred_mode)
		make_a_prediction(pred_buff);
	return OK;
}

int 
toggle_eol_longer_mode(e)
	ED_STRUCT      *e;
{				/* JJD 9-86 */
	eol_longer_mode = !eol_longer_mode;
	if (pred_on_display)
		erase_pred_buffer(e);
	if (pred_mode)
		make_a_prediction(pred_buff);
	return OK;
}

int 
toggle_pred_mode(e)
	ED_STRUCT      *e;
{				/* JJD 9-86 */
	pred_mode = !pred_mode;
	if (pred_on_display)
		erase_pred_buffer(e);
	if (pred_mode)
		make_a_prediction(pred_buff);
	return OK;
}

int 
show_free_nodes(e)
	ED_STRUCT      *e;
{				/* JJD 1-87, revised 3-89 */
	extern int      next_free;
	char            tbuf[128];	/* extern in rk_button */
	extern long     psize;
	sprintf(tbuf, "\015\nK=%d, COUNT=%d, NODES=%d, PRIME=%d; psize=%d, nodes=%d\015\n",
		maxk, max_freq, max_nodes, maxprime, psize, next_free);
	write(1, tbuf, strlen(tbuf));
	write(1, "Continue: ", 10);	/* JJD 3-89 added */
	draw_current_edit_line(e);	/* JJD 3-89 added */
	return OK;
}

int 
show_version(e)
	ED_STRUCT      *e;
{				/* JJD 3-89 added */
	char            tbuf[128];
	sprintf(tbuf, "\015\nRK_Button Version: %s", RK_VERSION);
	strcat(tbuf, ", with file_completion (^C).\015\n");
	write(1, tbuf, strlen(tbuf));
	write(1, "Continue: ", 10);
	draw_current_edit_line(e);
	return OK;
}

int 
prime_from_file(e)
	ED_STRUCT      *e;
{				/* JJD 9-86 */
	char            filename[256];
	FILE           *from;
	int             i;
	char            c;
	extern Buffer   Buf;	/* externs in rk_button */
	extern char     context[MAX_CMD_LINE_LENGTH];

	erase_current_edit_line(e);
	e->dot = e->current_buffer;
	e->mark = e->current_buffer;
	*(e->dot) = '\0';

	ioctl(0, TIOCGETP, &new_stdin);
	ioctl(0, TIOCSETP, &old_stdin);
	strcpy(filename, "");
	printf("File to prime from ([RETURN] to cancel): ");
	fflush(stdout);
	gets(filename);
	if (filename[0] == '\0') {
		printf("Command cancelled.\r\n");
		fflush(stdout);
	} else {
		if ((from = fopen(filename, "r")) == NULL) {
			printf("cannot open: %s\r\n", filename);
			fflush(stdout);
		} else {
			while (((int) (c = getc(from))) != EOF)
				for (i = maxk; i > 0; i--)
					Buf[i] = move_up(Buf[i - 1], c);
			fclose(from);
			show_free_nodes(e);
		}
	}
	ioctl(0, TIOCSETP, &new_stdin);

	return OK;
}


int 
close_paren(e)
	ED_STRUCT      *e;
{

	char           *old_dot;

	if (!lisp_mode)
		return self_insert(e);

	old_dot = e->dot;
	if (*old_dot != ')')	/* if not on a ')', insert one */
		self_insert(e);

	forward_char(e);	/* skip past ')' so bkd-prn works */
	backward_paren(e);	/* flash back to matching '(' */
	sleep(1);

	e->universal_argument = 1 + old_dot - e->dot;
	return forward_char(e);	/* skip ahead to old dot + 1 */
}


int 
open_paren(e)
	ED_STRUCT      *e;
{

	char           *old_dot;

	self_insert(e);		/* stick in an open_paren */
	if (!lisp_mode)
		return OK;

	old_dot = e->dot;
	if ((*old_dot == ')') || (*old_dot == 0)) {
		e->current_input_char = ')';	/* if on a ')' or at the end */
		self_insert(e);	/* then insert matching ')' */
		backward_char(e);	/* and go back inside () */
	}
	return OK;
}


int 
increment_universal_argument(e)
	ED_STRUCT      *e;
{

	if (e->universal_argument > UNIVERSAL_ARGUMENT_MAXIMUM)
		write(1, "\07", 1);
	else
		e->universal_argument *= 4;

	return OK;
}


int 
clear_display(e)
	ED_STRUCT      *e;
{

	e->universal_argument = 1;
	output_string_length = 0;
	if (clear_screen) {
		tputs(clear_screen, ONE_LINE, append_to_output_string);
		write(1, output_string, output_string_length);
	} else
		write(1, "\r\n\r\n", 2);
	draw_current_edit_line(e);

	return OK;
}



int 
previous_line(e)
	ED_STRUCT      *e;
{

	int             how_many;

	how_many = e->universal_argument;
	e->current_ed_buff_ptr->dot = e->dot;
	e->current_ed_buff_ptr->mark = e->mark;
	erase_current_edit_line(e);
	for (; how_many; --how_many)
		e->current_ed_buff_ptr = e->current_ed_buff_ptr->prev_ptr;
	e->current_buffer = e->current_ed_buff_ptr->string;
	e->dot = e->current_ed_buff_ptr->dot;
	e->mark = e->current_ed_buff_ptr->mark;
	draw_current_edit_line(e);
	e->universal_argument = 1;
	return OK;
}


int 
previous_pred(e)
	ED_STRUCT      *e;
{				/* JJD 9-86 */

	if (pred_number)
		pred_number--;
	return OK;
}

int 
next_pred(e)
	ED_STRUCT      *e;
{				/* JJD 9-86 */

	if (++pred_number > 127)
		pred_number = 127;
	return OK;
}

int 
next_line(e)
	ED_STRUCT      *e;
{

	int             how_many;

	how_many = e->universal_argument;
	e->current_ed_buff_ptr->dot = e->dot;

	e->current_ed_buff_ptr->mark = e->mark;

	erase_current_edit_line(e);
	for (; how_many; --how_many)
		e->current_ed_buff_ptr = e->current_ed_buff_ptr->next_ptr;
	e->current_buffer = e->current_ed_buff_ptr->string;
	e->dot = e->current_ed_buff_ptr->dot;

	e->mark = e->current_ed_buff_ptr->mark;

	draw_current_edit_line(e);
	e->universal_argument = 1;
	return OK;
}


int 
discard_current_edit_line(e)
	ED_STRUCT      *e;
{

	strcpy(e->kill_buffer, e->current_buffer);
	erase_current_edit_line(e);
	e->dot = e->current_buffer;

	e->mark = e->current_buffer;

	*e->dot = '\0';

	return OK;
}


int 
discard_rest_of_line(e)
	ED_STRUCT      *e;
{

	strcpy(e->kill_buffer, e->dot);
	e->universal_argument = strlen(e->dot);

	if (e->universal_argument == 0) {
		e->universal_argument = 1;
		return OK;
	} else

	{
		if (e->mark > e->dot)
			e->mark = e->dot;
		return delete_char(e);
	}

}


int 
yank_from_kill_buffer(e)
	ED_STRUCT      *e;
{

	int             count;

	output_string_length = 0;
	strcpy(temp_str, e->dot);
	strcpy(e->dot, e->kill_buffer);

	if (e->mark > e->dot)
		e->mark += strlen(e->kill_buffer);

	e->dot = e->dot + strlen(e->kill_buffer);
	strcpy(e->dot, temp_str);
	display_string_into_output_string(e->kill_buffer);
	count = display_string_into_output_string(temp_str);
	for (; count; --count)
		tputs(cursor_left, ONE_LINE, append_to_output_string);
	write(1, output_string, output_string_length);

	return OK;
}



int 
display_pred_buffer(e)
	ED_STRUCT      *e;
{				/* JJD 9-86 ???? */

	int             count;

	output_string[0] = '\0';
	output_string_length = 0;

	if (enter_standout_mode)
		tputs(enter_standout_mode, ONE_LINE, append_to_output_string);
	count = display_string_into_output_string(pred_buff);
	if (enter_standout_mode)
		tputs(exit_standout_mode, ONE_LINE, append_to_output_string);
	count += display_string_into_output_string(e->dot);

	for (; count; --count)
		tputs(cursor_left, ONE_LINE, append_to_output_string);
	write(1, output_string, output_string_length);
	pred_on_display = 1;

	return OK;
}


int 
erase_pred_buffer(e)
	ED_STRUCT      *e;
{				/* JJD 9-86 */

	int             num_to_erase, count;

	output_string[0] = '\0';
	output_string_length = 0;

	if (enter_standout_mode)
		tputs(exit_standout_mode, ONE_LINE, append_to_output_string);
	display_string_into_output_string(e->dot);

	num_to_erase = get_display_length(pred_buff);
	for (count = num_to_erase; count; --count)
		output_string[output_string_length++] = ' ';
	num_to_erase += get_display_length(e->dot);
	for (count = num_to_erase; count; --count)
		tputs(cursor_left, ONE_LINE, append_to_output_string);
	write(1, output_string, output_string_length);
	pred_on_display = 0;

	return OK;
}

int 
insert_interrupt_char(e)
	ED_STRUCT      *e;
{

	struct tchars   pty_tchars;

	ioctl(pty_master, TIOCGETC, &pty_tchars);

	erase_current_edit_line(e);
	e->dot = e->current_buffer;

	e->mark = e->current_buffer;

	*(e->dot++) = pty_tchars.t_intrc;
	*(e->dot) = '\0';
	return FINISHED_BUT_DONT_ADD_CTRL_M;
}

int 
insert_quit_char(e)
	ED_STRUCT      *e;
{

	struct tchars   pty_tchars;

	ioctl(pty_master, TIOCGETC, &pty_tchars);

	erase_current_edit_line(e);
	e->dot = e->current_buffer;
	e->mark = e->current_buffer;
	*(e->dot++) = pty_tchars.t_quitc;
	*(e->dot) = '\0';
	return FINISHED_BUT_DONT_ADD_CTRL_M;
}

int 
insert_stop_char(e)
	ED_STRUCT      *e;
{				/* JJD 9-86 */

	struct tchars   pty_tchars;

	ioctl(pty_master, TIOCGETC, &pty_tchars);

	erase_current_edit_line(e);
	e->dot = e->current_buffer;
	e->mark = e->current_buffer;
	*(e->dot++) = pty_tchars.t_stopc;
	*(e->dot) = '\0';
	return FINISHED_BUT_DONT_ADD_CTRL_M;
}

int 
insert_start_char(e)
	ED_STRUCT      *e;
{				/* JJD 9-86 */

	struct tchars   pty_tchars;

	ioctl(pty_master, TIOCGETC, &pty_tchars);

	erase_current_edit_line(e);
	e->dot = e->current_buffer;
	e->mark = e->current_buffer;
	*(e->dot++) = pty_tchars.t_startc;
	*(e->dot) = '\0';
	return FINISHED_BUT_DONT_ADD_CTRL_M;
}

int 
insert_eof_char(e)
	ED_STRUCT      *e;
{				/* JJD 9-86 */

	struct tchars   pty_tchars;

	ioctl(pty_master, TIOCGETC, &pty_tchars);

	erase_current_edit_line(e);
	e->dot = e->current_buffer;
	e->mark = e->current_buffer;
	*(e->dot++) = pty_tchars.t_eofc;
	*(e->dot) = '\0';
	return FINISHED_BUT_DONT_ADD_CTRL_M;
}

int 
insert_suspend_char(e)
	ED_STRUCT      *e;
{

	struct ltchars  pty_ltchars;

	ioctl(pty_master, TIOCGLTC, &pty_ltchars);

	erase_current_edit_line(e);
	e->dot = e->current_buffer;
	e->mark = e->current_buffer;
	*(e->dot++) = pty_ltchars.t_suspc;
	*(e->dot) = '\0';
	return FINISHED_BUT_DONT_ADD_CTRL_M;
}



int 
twiddle_chars(e)
	ED_STRUCT      *e;
{

	char            temp_char;
	int             num_to_back_up, count;

	output_string_length = 0;

	if (strlen(e->current_buffer) == 0) {
		*e->dot++ = '\024';
		*e->dot = '\0';
		return FINISHED_BUT_DONT_ADD_CTRL_M;
	} else if ((e->dot - e->current_buffer) < 2)
		write(1, "\07", 1);
	else {
		temp_char = *(e->dot - 1);
		*(e->dot - 1) = *(e->dot - 2);
		*(e->dot - 2) = temp_char;
		num_to_back_up = get_char_display_length(*(e->dot - 2));
		num_to_back_up += get_char_display_length(*(e->dot - 1));
		for (count = num_to_back_up; count; --count)
			tputs(cursor_left, ONE_LINE, append_to_output_string);
		display_char_into_output_string(*(e->dot - 2));
		display_char_into_output_string(*(e->dot - 1));
		write(1, output_string, output_string_length);
	}

	e->universal_argument = 1;

	return OK;
}

int 
beginning_of_line(e)
	ED_STRUCT      *e;
{

	e->universal_argument = 1;
	output_string[0] = '\0';
	output_string_length = 0;
	while (e->dot != e->current_buffer) {
		e->dot--;
		if ((*(e->dot) < 32) || (*(e->dot) == 127)) {
			tputs(cursor_left, ONE_LINE, append_to_output_string);
			tputs(cursor_left, ONE_LINE, append_to_output_string);
		} else
			tputs(cursor_left, ONE_LINE, append_to_output_string);
	}

	write(1, output_string, output_string_length);

	return OK;
}

int 
end_of_line(e)
	ED_STRUCT      *e;
{

	e->universal_argument = 1;
	output_string[0] = '\0';
	output_string_length = 0;
	display_string_into_output_string(e->dot);
	e->dot = &(e->current_buffer[strlen(e->current_buffer)]);

	write(1, output_string, output_string_length);

	return OK;
}

int 
quote_char(e)
	ED_STRUCT      *e;
{

	char            quoted_char;

	READ(0, &quoted_char, 1);
	quoted_char &= 127;
	if (quoted_char == '\0') {
		write(1, "\07", 1);
		return OK;
	} else {
		e->current_input_char = quoted_char;
		return self_insert(e);
	}
}

meta_prefix(e)
	ED_STRUCT      *e;
{
	char            metad_char;
	int		i=0;
	int		status;

	if(e==0)
		abortit("meta_prefix passed a nil pointer, aborting...\n",-1);

	while((i<MAXEXTENSIONS) && (meta_prefixes[i][current_key_map]) &&
	      (e->current_input_char!=meta_prefixes[i][current_key_map]))
		i++;
	if(i==MAXEXTENSIONS)
		return(BOGUS(e));
	current_key_map=meta_map[i][current_key_map];

	if (pred_mode && pred_buff[0] && !pred_on_display)
		display_pred_buffer(e);	/* JJD 9-86 */
	READ(0, &metad_char, 1);
	if (pred_on_display) erase_pred_buffer (e);	/* JJD 3-89 added */
	metad_char &= 127;	/* clear high bit */
	e->current_input_char = metad_char;
	status  = (keymap[(int) metad_char][current_key_map])(e);
	current_key_map=0;
	return(status);
}


	


int 
backward_char(e)
	ED_STRUCT      *e;
{

	int             num_to_go, count, needs_beep;

	output_string[0] = '\0';
	output_string_length = 0;

	if ((e->dot - e->universal_argument) < e->current_buffer)
		num_to_go = e->dot - e->current_buffer, needs_beep = 1;
	else
		num_to_go = e->universal_argument, needs_beep = 0;

	count = num_to_go;
	while (count-- > 0) {
		e->dot--;
		tputs(cursor_left, ONE_LINE, append_to_output_string);
		if ((*(e->dot) < 32) || (*(e->dot) == 127))
			tputs(cursor_left, ONE_LINE, append_to_output_string);
	}

	if (needs_beep)
		output_string[output_string_length++] = '\07';

	write(1, output_string, output_string_length);

	e->universal_argument = 1;

	return OK;
}

int 
accept_to_end_of_line(e)
	ED_STRUCT      *e;
{				/* JJD 9-86 */

	char           *ptr;

	if (!pred_mode)
		return end_of_line(e);
	/* truncate prediction to after first NL */
	if (ptr = index(pred_buff, '\n')){
		*(++ptr) = '\0';
	}
	/* only go to end of prediction */
	e->universal_argument = strlen(pred_buff);
	return accept_forward_char(e);
}

int 
accept_forward_char(e)
	ED_STRUCT      *e;
{				/* JJD 9-86 */

	int             num_to_go, count, needs_beep, finished = 0;

	if (!pred_mode)
		return forward_char(e);
	if (pred_buff[0] == '\n')
		return finish_editing_line(e);
	output_string[0] = '\0';
	output_string_length = 0;

	num_to_go = strlen(pred_buff);
	if (e->universal_argument > num_to_go)	/* to end of prediction */
		needs_beep = 1;
	else
		num_to_go = e->universal_argument, needs_beep = 0;

	/* there is at most 1 NL at the end of the prediction */
	if (pred_buff[num_to_go - 1] == '\n') {
		num_to_go--;
		finished = 1;
	}
	pred_buff[num_to_go] = '\0';
	display_string_into_output_string(pred_buff);
	strcat(pred_buff, e->dot);
	strcpy(e->dot, pred_buff);
	if (e->mark > e->dot)
		e->mark += num_to_go;
	e->dot += num_to_go;
	count = display_string_into_output_string(e->dot);
	for (; count; --count)
		tputs(cursor_left, ONE_LINE, append_to_output_string);

	if (needs_beep)
		output_string[output_string_length++] = '\07';
	write(1, output_string, output_string_length);
	e->universal_argument = 1;

	if (finished)
		return finish_editing_line(e);
	else
		return OK;
}

int 
forward_char(e)
	ED_STRUCT      *e;
{

	int             num_to_go, count, needs_beep;

	output_string[0] = '\0';
	output_string_length = 0;

	if (e->universal_argument > strlen(e->dot))
		num_to_go = strlen(e->dot), needs_beep = 1;
	else
		num_to_go = e->universal_argument, needs_beep = 0;

	count = num_to_go;
	while (count-- > 0)
		display_char_into_output_string(*(e->dot++));

	if (needs_beep)
		output_string[output_string_length++] = '\07';

	write(1, output_string, output_string_length);

	e->universal_argument = 1;

	return OK;
}


int 
backspace_char(e)
	ED_STRUCT      *e;
{

	int             rest_of_line_display_length, count;
	int             num_to_delete;
	char           *c, *new_dot;
	char           *old_dot = e->dot;	/* JJD 3-89 added */

	output_string[0] = '\0';
	output_string_length = 0;

	if ((e->dot - e->current_buffer) < e->universal_argument)
		new_dot = e->current_buffer;
	else
		new_dot = e->dot - e->universal_argument;

	num_to_delete = 0;
	for (c = e->dot - 1; c >= new_dot; --c)
		if ((*c < 32) || (*c == 127))
			num_to_delete += 2;
		else
			num_to_delete++;

	if (delete_a_char) {
		for (count = num_to_delete; count; --count)
			tputs(cursor_left, ONE_LINE, append_to_output_string);

		if (enter_delete_mode)
			tputs(enter_delete_mode, ONE_LINE, append_to_output_string);

		for (count = num_to_delete; count; --count)
			tputs(delete_a_char, ONE_LINE, append_to_output_string);

		if (enter_delete_mode)
			tputs(exit_delete_mode, ONE_LINE, append_to_output_string);
	} else {
		for (count = num_to_delete; count; --count)
			tputs(cursor_left, ONE_LINE, append_to_output_string);

		rest_of_line_display_length =
			display_string_into_output_string(e->dot);

		for (count = num_to_delete; count; --count)
			output_string[output_string_length++] = ' ';

		for (count = num_to_delete + rest_of_line_display_length; count; --count)
			tputs(cursor_left, ONE_LINE, append_to_output_string);
	}

	if (e->dot - e->universal_argument < e->current_buffer)
		output_string[output_string_length++] = '\07';

	strcpy(temp_str, e->dot);
	strcpy(new_dot, temp_str);
	e->dot = new_dot;
	if (e->mark >= new_dot)
		e->mark -= (old_dot - new_dot);
	e->universal_argument = 1;
	write(1, output_string, output_string_length);

	return OK;
}

int 
delete_char(e)
	ED_STRUCT      *e;
{

	int             count;
	int             num_to_delete, num_to_back_up;
	char           *c, *new_dot;
	char           *old_dot = e->dot;	/* JJD 3-89 added */

	if (*(e->dot) == '\0') {
		struct tchars   pty_tchars;
		ioctl(pty_master, TIOCGETC, &pty_tchars);
		erase_pred_buffer(e);
		erase_current_edit_line(e);
		*(e->dot++) = pty_tchars.t_eofc;
		*(e->dot) = '\0';
		return FINISHED_BUT_DONT_ADD_CTRL_M;
	}
	output_string[0] = '\0';
	output_string_length = 0;

	if (e->universal_argument > strlen(e->dot))
		new_dot = e->dot + strlen(e->dot);
	else
		new_dot = e->dot + e->universal_argument;

	num_to_delete = 0;
	for (c = e->dot; c < new_dot; ++c)
		if ((*c < 32) || (*c == 127))
			num_to_delete += 2;
		else
			num_to_delete++;

	if (delete_a_char) {
		if (enter_delete_mode)
			tputs(enter_delete_mode, ONE_LINE, append_to_output_string);

		for (count = num_to_delete; count; --count)
			tputs(delete_a_char, ONE_LINE, append_to_output_string);

		if (enter_delete_mode)
			tputs(exit_delete_mode, ONE_LINE, append_to_output_string);
	} else {
		num_to_back_up = display_string_into_output_string(new_dot);
		for (count = num_to_delete; count; --count)
			output_string[output_string_length++] = ' ';
		for (count = num_to_back_up + num_to_delete; count; --count)
			tputs(cursor_left, ONE_LINE, append_to_output_string);
	}

	if (e->universal_argument > strlen(e->dot))
		output_string[output_string_length++] = '\07';

	strcpy(temp_str, new_dot);
	strcpy(e->dot, temp_str);
	e->universal_argument = 1;
	if (e->mark >= new_dot)
		e->mark += (old_dot - new_dot);
	write(1, output_string, output_string_length);

	return OK;
}


int 
finish_editing_line(e)
	ED_STRUCT      *e;
{

	char           *old_dot;

	e->universal_argument = 1;
	old_dot = e->dot;
	beginning_of_line(e);
	e->dot = old_dot;	/* necessary to preserve cursor position
				 * accross newlines                      */
	return FINISHED_EDITING;
}


int 
self_insert(e)
	ED_STRUCT      *e;
{

	int             num_to_back_up, count;
	char           *old_dot = e->dot;	/* JJD 3-89 added */

	strcpy(output_string, "");
	output_string_length = 0;

	if (*(e->dot) == '\0') {
		for (count = e->universal_argument; count; --count)
			display_char_into_output_string(e->current_input_char);
	} else {
		if (enter_insert_mode || pre_insert_char) {
			if (enter_insert_mode)
				tputs(enter_insert_mode, ONE_LINE, append_to_output_string);

			for (count = e->universal_argument; count; --count) {
				if (pre_insert_char)
					tputs(pre_insert_char, ONE_LINE, append_to_output_string);
				if ((e->current_input_char < 32)) {
					output_string[output_string_length++] = '^';
					if (post_insert_char)
						tputs(post_insert_char, ONE_LINE,
						   append_to_output_string);
					if (pre_insert_char)
						tputs(pre_insert_char, ONE_LINE,
						   append_to_output_string);
					output_string[output_string_length++] =
						e->current_input_char + '@';
				} else if (e->current_input_char == 127) {
					output_string[output_string_length++] = '^';
					if (post_insert_char)
						tputs(post_insert_char, ONE_LINE,
						   append_to_output_string);
					if (pre_insert_char)
						tputs(pre_insert_char, ONE_LINE,
						   append_to_output_string);
					output_string[output_string_length++] = '?';
				} else
					output_string[output_string_length++] =
						e->current_input_char;

				if (post_insert_char)
					tputs(post_insert_char, ONE_LINE, append_to_output_string);
			}

			if (enter_insert_mode)
				tputs(exit_insert_mode, ONE_LINE, append_to_output_string);
		} else {
			for (count = e->universal_argument; count; --count)
				display_char_into_output_string(e->current_input_char);
			num_to_back_up =
				display_string_into_output_string(e->dot);
			for (count = num_to_back_up; count; --count)
				tputs(cursor_left, ONE_LINE, append_to_output_string);
		}
	}

	strcpy(temp_str, e->dot);
	for (count = e->universal_argument; count; --count)
		*(e->dot++) = e->current_input_char;
	strcpy(e->dot, temp_str);
	if (e->mark > old_dot)
		e->mark += (e->dot - old_dot);
	write(1, output_string, output_string_length);

	e->universal_argument = 1;
	return OK;
}


run_program_connected_to_standard_tty(cmd)
	char           *cmd;
{

	int             status;
	void		(*sig)();

	ioctl(0, TIOCGETP, &new_stdin);
	ioctl(0, TIOCSETP, &old_stdin);
	printf("Now running \"%s\"\r\n", cmd);
	sig=signal(SIGCHLD,SIG_DFL); 
	status = system(cmd);
	signal(SIGCHLD,sig); 
	printf("Finished running \"%s\"\r\n", cmd);
	ioctl(0, TIOCSETP, &new_stdin);
	write(1, "Continue: ", 10);
	return status;
}


quietly_run_program_connected_to_standard_tty(cmd)
	char           *cmd;
{

	int             status;
	void		(*sig)();
	
	ioctl(0, TIOCGETP, &new_stdin);
	ioctl(0, TIOCSETP, &old_stdin);
	sig=signal(SIGCHLD,SIG_DFL); 
	status = system(cmd);
	signal(SIGCHLD,sig); 
	ioctl(0, TIOCSETP, &new_stdin);
	return status;
}



int 
uppercase_word(e)
	ED_STRUCT      *e;
{

	char           *ch, *cb;

	cb = e->current_buffer;
	ch = e->dot;

	if (ch != cb)		/* not at beginning of buffer */
		while ((ch >= cb) && (!isalnum(*ch)) && (*ch != '-') && (*ch != '_'))
			ch--;	/* search backwards until in a word */

	while ((ch >= cb) && (isalnum(*ch) || (*ch == '-') || (*ch == '_')))
		ch--;		/* find first letter in word */

	while (isalnum(*++ch) || (*ch == '-') || (*ch == '_'))
		if ((*ch >= 'a') && (*ch <= 'z'))
			*ch -= 32;	/* uppercase all lowers */

	erase_current_edit_line(e);
	draw_current_edit_line(e);
	return OK;
}

int 
lowercase_word(e)
	ED_STRUCT      *e;
{

	char           *ch, *cb;

	cb = e->current_buffer;
	ch = e->dot;

	if (ch != cb)		/* not at beginning of buffer */
		while ((ch >= cb) && (!isalnum(*ch)) && (*ch != '-') && (*ch != '_'))
			ch--;	/* search backwards until in a word */

	while ((ch >= cb) && (isalnum(*ch) || (*ch == '-') || (*ch == '_')))
		ch--;		/* find first letter in word */

	while (isalnum(*++ch) || (*ch == '-') || (*ch == '_'))
		if ((*ch >= 'A') && (*ch <= 'Z'))
			*ch += 32;	/* lowercase all uppers */

	erase_current_edit_line(e);
	draw_current_edit_line(e);
	return OK;
}


int 
capitalize_word(e)
	ED_STRUCT      *e;
{

	char           *ch, *cb;
	int             subword_flag = 0;

	cb = e->current_buffer;
	ch = e->dot;

	if (ch != cb)		/* not at beginning of buffer */
		while ((ch >= cb) && (!isalnum(*ch)) && (*ch != '-') && (*ch != '_'))
			ch--;	/* search backwards until in a word */

	while ((ch >= cb) && (isalnum(*ch) || (*ch == '-') || (*ch == '_')))
		ch--;		/* find first letter in word */

	if ((*++ch >= 'a') && (*ch <= 'z'))
		*ch -= 32;	/* uppercase first letter */

	while (isalnum(*++ch) || (*ch == '-') || (*ch == '_'))
		if (!isalnum(*ch))
			subword_flag = 1;	/* next char starts subword */
		else if (subword_flag) {
			subword_flag = 0;
			if ((*ch >= 'a') && (*ch <= 'z'))
				*ch -= 32;	/* uppercase first letter */
		} else if ((*ch >= 'A') && (*ch <= 'Z'))
			*ch += 32;	/* lowercase subsequent letters */

	erase_current_edit_line(e);
	draw_current_edit_line(e);
	return OK;
}

int 
ul_to_dash_word(e)
	ED_STRUCT      *e;
{

	char           *ch, *cb;

	cb = e->current_buffer;
	ch = e->dot;

	if (ch != cb)		/* not at beginning of buffer */
		while ((ch >= cb) && (!isalnum(*ch)) && (*ch != '-') && (*ch != '_'))
			ch--;	/* search backwards until in a word */

	while ((ch >= cb) && (isalnum(*ch) || (*ch == '-') || (*ch == '_')))
		ch--;		/* find first letter in word */

	while (isalnum(*++ch) || (*ch == '-') || (*ch == '_'))
		if (*ch == '_')	/* replace underscores with hyphens */
			*ch = '-';

	erase_current_edit_line(e);
	draw_current_edit_line(e);
	return OK;
}

int 
dash_to_ul_word(e)
	ED_STRUCT      *e;
{

	char           *ch, *cb;

	cb = e->current_buffer;
	ch = e->dot;

	if (ch != cb)		/* not at beginning of buffer */
		while ((ch >= cb) && (!isalnum(*ch)) && (*ch != '-') && (*ch != '_'))
			ch--;	/* search backwards until in a word */

	while ((ch >= cb) && (isalnum(*ch) || (*ch == '-') || (*ch == '_')))
		ch--;		/* find first letter in word */

	while (isalnum(*++ch) || (*ch == '-') || (*ch == '_'))
		if (*ch == '-')	/* replace hyphens with underscores */
			*ch = '_';

	erase_current_edit_line(e);
	draw_current_edit_line(e);
	return OK;
}


/*
int 
describe_bindings(e)
	ED_STRUCT      *e;
{

	char            cmd[256];

	erase_current_edit_line(e);
	write(1, "One moment. . .", 15);
	strcpy(cmd, "/usr/ucb/more ");
	strcat(cmd, getenv("HOME"));
	strcat(cmd, ".rk.key_map");
	quietly_run_program_connected_to_standard_tty(cmd);
	write(1, "Continue: ", 10);
	draw_current_edit_line(e);
	return OK;
}
*/

		

run_tty_program(e)
	ED_STRUCT      *e;
{

	char            cmd[512];

	erase_current_edit_line(e);
	e->dot = e->current_buffer;
	e->mark = e->current_buffer;
	*(e->dot) = '\0';

	ioctl(0, TIOCGETP, &new_stdin);
	ioctl(0, TIOCSETP, &old_stdin);
	strcpy(cmd, "");
	printf("Command to run ([RETURN] to cancel): ");
	fflush(stdout);
	gets(cmd);
	if (cmd[0] == '\0') {
		printf("Command cancelled.\r\n");
		ioctl(0, TIOCSETP, &new_stdin);
	} else {
		ioctl(0, TIOCSETP, &new_stdin);
		run_program_connected_to_standard_tty(cmd);
	}

	return OK;
}

run_talk(e)
	ED_STRUCT      *e;
{

	char            cmd[256], *who_to;

	erase_current_edit_line(e);
	e->dot = e->current_buffer;
	e->mark = e->current_buffer;
	*(e->dot) = '\0';

	ioctl(0, TIOCGETP, &new_stdin);
	ioctl(0, TIOCSETP, &old_stdin);
	strcpy(cmd, "talk ");
	who_to = &cmd[5];
	printf("Talk to whom ([RETURN] to cancel): ");
	fflush(stdout);
	gets(who_to);
	if (who_to[0] == '\0') {
		printf("Talk cancelled.\r\n");
		ioctl(0, TIOCSETP, &new_stdin);
	} else {
		ioctl(0, TIOCSETP, &new_stdin);
		run_program_connected_to_standard_tty(cmd);
	}

	return OK;
}

run_write(e)
	ED_STRUCT      *e;
{

	char            cmd[256], *who_to;

	erase_current_edit_line(e);
	e->dot = e->current_buffer;
	e->mark = e->current_buffer;
	*(e->dot) = '\0';

	ioctl(0, TIOCGETP, &new_stdin);
	ioctl(0, TIOCSETP, &old_stdin);
	strcpy(cmd, "write ");
	who_to = &cmd[6];
	printf("write to whom ([RETURN] to cancel): ");
	fflush(stdout);
	gets(who_to);
	if (who_to[0] == '\0') {
		printf("Write cancelled.\r\n");
		ioctl(0, TIOCSETP, &new_stdin);
	} else {
		ioctl(0, TIOCSETP, &new_stdin);
		run_program_connected_to_standard_tty(cmd);
	}

	return OK;
}

run_pp(e)
	ED_STRUCT      *e;
{				/* JJD 9-86 */

	char            cmd[256], *who_to;

	erase_current_edit_line(e);
	e->dot = e->current_buffer;
	e->mark = e->current_buffer;
	*(e->dot) = '\0';

	ioctl(0, TIOCGETP, &new_stdin);
	ioctl(0, TIOCSETP, &old_stdin);
	strcpy(cmd, "pp ");
	who_to = &cmd[3];
	printf("pp what file ([RETURN] to cancel): ");
	fflush(stdout);
	gets(who_to);
	if (who_to[0] == '\0') {
		printf("pp cancelled.\r\n");
		ioctl(0, TIOCSETP, &new_stdin);
	} else {
		ioctl(0, TIOCSETP, &new_stdin);
		run_program_connected_to_standard_tty(cmd);
	}

	return OK;
}

run_mesg(e)
	ED_STRUCT      *e;
{

	char            cmd[256], *on_or_off;

	erase_current_edit_line(e);
	e->dot = e->current_buffer;
	e->mark = e->current_buffer;
	*(e->dot) = '\0';

	ioctl(0, TIOCGETP, &new_stdin);
	ioctl(0, TIOCSETP, &old_stdin);
	strcpy(cmd, "mesg ");
	on_or_off = &cmd[5];
	printf("Do you want \"mesg y\" or \"mesg n\" ");
	printf("(type y or n and press [RETURN]): ");
	fflush(stdout);
	gets(on_or_off);
	if (!strncmp(on_or_off, "on", 2))
		strcpy(on_or_off, "y");
	else if (!strncmp(on_or_off, "off", 3))
		strcpy(on_or_off, "n");
	else if (*on_or_off == 'y' || *on_or_off == 'n')
		on_or_off[1] = '\0';
	else if (on_or_off[0] == '\0') {
		printf("Mesg cancelled.\r\n");
		ioctl(0, TIOCSETP, &new_stdin);
		return OK;
	} else {
		printf("Mesg cancelled because you didn't respond with y or n.\r\n");
		ioctl(0, TIOCSETP, &new_stdin);
		return OK;
	}

	ioctl(0, TIOCSETP, &new_stdin);
	run_program_connected_to_standard_tty(cmd);
	return OK;
}

int describe_arguments(e)
	ED_STRUCT      *e;
{
	extern num_buffers;
	extern  char silent;
	extern  char login;
	extern	max_len;
	extern	max_eol;
	extern char *zero_freq_file;
	extern char *prime_file;
	extern char *key_file;


	printf("\r\nCurrent Command Line Argument Values:\r\n");
	printf("	-b (Number of buffers)  = %d\r\n", num_buffers);
	printf("	-e (End of Line length)	= %d\r\n",max_eol);
	printf("	-f (Maximum Frequency)	= %d\r\n",max_freq);
	printf("	-i (Inline Length)	= %d\r\n",max_len);
	printf("	-k (Key Bindings File)	= \"%s\"\r\n",key_file);
	printf("	-n (Nodes to allocate)	= %d\r\n",max_nodes);
	printf("	-o (Order of model)	= %d\r\n",maxk);
	printf("	-p (Prime File)		= \"%s\"\r\n",prime_file);
	printf("	-s (Maximum to prime)	= %d\r\n",maxprime);
	printf("	-z (Zero Frequency File)= \"%s\"\r\n",zero_freq_file);
	printf("	-A (add_space_mode)	= %s\r\n",add_space_mode?"TRUE":"FALSE");
	printf("	-E (eol_only_mode)	= %s\r\n",eol_only_mode?"TRUE":"FALSE");
	printf("	-L (eol_longer_mode)	= %s\r\n",eol_longer_mode?"TRUE":"FALSE");
	printf("	-N (nl_truncate_mode)	= %s\r\n",nl_truncate_mode?"TRUE":"FALSE");
	printf("	-P (pred_mode)		= %s\r\n",pred_mode?"TRUE":"FALSE");
	printf("	-S (show_eol_mode)	= %s\r\n",show_eol_mode?"TRUE":"FALSE");
	printf("	-g (login shell)	= %s\r\n",login?"TRUE":"FALSE");
	printf("	-l (lisp_mode)		= %s\r\n",lisp_mode?"TRUE":"FALSE");
	printf("	-m (silent startup)	= %s\r\n",silent?"TRUE":"FALSE");
	write(1, "Continue: ", 10);
	draw_current_edit_line(e);
	return OK;
}
