#include <alloca.h>	    /* JJD: some other alloc may be better to use  */
#include <stdio.h>
#include <sys/file.h>
#include <sys/types.h>
#include <sys/dir.h>
#include <sys/stat.h>  
#include <sys/param.h>	    /* JJD 3-89 added to get MAXPATHLEN and CANBSIZ*/
#include "file+rk.h"
#include "functions.h"


#define FILECOMPLETION 3	/* change if you need to change the binding of
				   filecompletion */

/* MAX_FILENAME_LENGTH must be less than MAX_CMD_LINE_LENGTH (CANBSIZ, 256)*/
/*									   */
/* dir.h MAXNAMLEN is 255 (+1 for char [])	   JJD 3-89 #define	   */

#define MAX_DIR_TO_SEARCH	16		/* WARNING: just a guess!  */
#define MAX_FILES_TO_SAVE	1024		/* WARNING: just a guess!  */
#define MAX_FILENAME_LENGTH     MAXNAMLEN 	/*          store bounds   */
#define MAX_PATHNAME_LENGTH     MAXPATHLEN

extern num_buffers;
extern char *cursor_left;
extern char output_string[];
extern output_string_length;
extern char pred_mode,pred_on_display;
extern char pred_buff[];
extern (*keymap[128][MAXEXTENSIONS]) ();

int run_ruptime (e) ED_STRUCT *e; {
  
      write (1, "\015\n", 2);					/* JJD 3-89*/
      quietly_run_program_connected_to_standard_tty ("uptime"); /* JJD 3-89*/
      write (1, "Continue: ", 10);
      draw_current_edit_line (e);
      return OK;
}

/* AN IDEA: a better way would look ahead a next char, if not this, put     */
/*	    in the read buffer and return, else stay here - write (un)getc. */
  
int file_completion (e) ED_STRUCT *e; {
      char *cwd,
           *getcwd(),
           *tdot,
           *tchar,chr,
           *f_name[MAX_FILES_TO_SAVE],		/* JJD 3-89 to ptrs, defines*/
           tstring[MAX_CMD_LINE_LENGTH + 1],
           de_name[MAX_FILENAME_LENGTH + 1],    /* JJD 3-89 dir entry name  */
           full_path[MAXPATHLEN];

      DIR  *opendir(),
           *dir_pointer;

      struct direct *readdir(),
                    *d_entry;
      int match=0,
          length,
          past_first=0,
          strncmp(),
          ful_path=0,
          count,
          cmatch,
          return_this = OK;	    		 /* JJD 2-89 added */
			/* now look for start of filename to match */
     for (tdot=e->dot;((*tdot != ' ') && (tdot != e->current_buffer));tdot--);

			/* if we aren't at the start of the whole buffer
			   then move ahead a char (to skip the space) */
      if (tdot != e->current_buffer) tdot++;
                        /* and save the string to look for */
      strcpy(tstring, tdot);
      for (tchar=tstring;((*tchar != '\/')&&(*tchar!='\0'));tchar++);
      if (*tchar == '\/') {
	ful_path = 1;
	strcpy(full_path,tstring);
	tchar=full_path;
	while (*tchar!='\0') tchar++;
	while ((*tchar!='\/') && (tchar != full_path)) tchar--;
        if (tchar != full_path) {
	  *tchar = '\0';
	  tchar++;strcpy(tstring,tchar);
	}
      }
      if (ful_path){
	cwd = full_path;
      }
      else {
	void	(*sig)();
	sig=signal(SIGCHLD,SIG_DFL); 
	getcwd(full_path);cwd=full_path;	    /* get working directory */
	signal(SIGCHLD,sig); 
      }
      if ((dir_pointer = opendir(cwd)) == NULL){    /* and open it to look */
	write(1, "\07",1);
	return OK;
      }			/* now look for any matching filenames and
			   increment match if we find one */
      d_entry=readdir(dir_pointer);
      for (; d_entry != NULL; d_entry = readdir(dir_pointer)){
        strcpy (de_name, d_entry->d_name);
	if (strncmp(tstring, de_name, strlen(tstring)) == 0){
         if ((strcmp(".", de_name) != 0) &&
             (strcmp("..", de_name) != 0)){    /* JJD 3-89 del . .. */
	     f_name[match] = (char *) alloca (strlen(de_name) + 1);
	     strcpy(f_name[match],de_name);
	  if (++match >= MAX_FILES_TO_SAVE) {
	      goto tomany;   /* JJD 3-89 forget about the rest of them */
	  }
	 }
	}
      }
tomany:
      if (match == 0) {
	write(1,"\07",1);
	if (dir_pointer != NULL) closedir(dir_pointer); /* JJD 3-89 added if*/
	return OK;
      }
			/* else we found at least 1  match */      
      else {
        ssort (f_name, match); /* JJD 3-89, alpha */
	cmatch = 0;
again:	output_string_length = 0;
	if (!past_first) length=strlen(tstring);
	else {
	  if (cmatch == 0) length=strlen(f_name[match-1]);
	  else length=strlen(f_name[cmatch-1]);
	}
	if (ful_path) length = length + strlen(full_path)+1;
                              /* so move the cursor to the beginning
				 of the file name */
	for (; length; --length)
	  tputs (cursor_left, ONE_LINE,append_to_output_string);
                              /* set current dot to beginning of the
				 file name and copy in the filename*/ 
	e->dot = tdot;
	if (ful_path){
	  strcpy(e->dot,full_path);
	  strcat(e->dot,"\/");
	  strcat(e->dot,f_name[cmatch]);
	}

/* JJD: WARNING: prev and next str ops could overflow ed_buff, should test */

	else strcpy(e->dot,f_name[cmatch]);
			      /* reset dot to the end of the line */	
        if (e->mark > e->dot) e->mark += strlen (f_name[cmatch]);/*JJD 3-89*/
	e->dot += strlen(f_name[cmatch]);

/* JJD: WARNING: prev and next dot resets could overflow ed_buff, as above */

	if (ful_path) {
          if (e->mark > e->dot) e->mark += strlen(full_path)+1;
	  e->dot += strlen(full_path)+1;
	}
                              /* and concatenate onto output string the
				 filename, write it to screen */
	if (ful_path) {
	  display_string_into_output_string(full_path);
	  display_string_into_output_string("\/");
	}
	display_string_into_output_string (f_name[cmatch]);
        if (cmatch == 0)length=strlen(f_name[match-1])-strlen(f_name[cmatch]);
	else length=strlen(f_name[cmatch-1])-strlen(f_name[cmatch]);
	for (count=0;count<length;count++){
	  display_string_into_output_string(" ");
	}
	for (count=0;count<length;count++){
	  tputs (cursor_left, ONE_LINE,append_to_output_string);
	}
	write (1, output_string, output_string_length);
	if (pred_mode) {				 /* JJD 2-89 added */
	        make_a_prediction (pred_buff);
		if (pred_buff[0]) display_pred_buffer (e);
	}
	
	READ(0,&chr,1);
	chr &= 127;					 /* JJD 2-89 added */
        if (pred_on_display) erase_pred_buffer (e);      /* JJD 2-89 added */
	if (chr == FILECOMPLETION) {
	  past_first = 1;
	  if (cmatch < match-1) {
	    cmatch++;
	    goto again;
	  }
	  else {cmatch=0;goto again;}
	}
	else {
/* JJD: it would be better to ungetc and return */
          return_this = OK;				 /* JJD 2-89 added */
	  e->current_input_char = chr;
	  return_this = keymap[(int)chr][0](e); /* JJD 2-89 add return_this */
	  if (dir_pointer != NULL) closedir(dir_pointer); /* JJD 3-89 add if*/
	  return (return_this);		       /* JJD 2-89 add return_this */
	}
      }
    }


int command_completion (e) ED_STRUCT *e;{
  char *path_var,		/* points to the environment variable PATH */
       *tdot,
       *tchar, 
       chr,
	   *paths[MAX_DIR_TO_SEARCH],		/* JJD 3-89 changed to ptrs */
           *f_name[MAX_FILES_TO_SAVE],
           tstring[MAX_CMD_LINE_LENGTH + 1],
           d_name[MAX_PATHNAME_LENGTH + 1],
           de_name[MAX_FILENAME_LENGTH + 1],
           t_name[MAX_PATHNAME_LENGTH + MAX_FILENAME_LENGTH + 1],
       *getenv();
  int  count,
       num_dirs=0,		/* number of directories to look in */
       current_search_directory,/* the current directory to look at */
       cmatch,
       match=0,
       length,
       past_first=0,
       return_this = OK;	    		 /* JJD 2-89 added */

DIR  *opendir(),
     *dir_pointer;

struct direct *readdir(),
              *d_entry;
struct stat   buf;				 /* JJD 3-89 added */

				/* get the file name to match */  
  for (tdot=e->dot;((*tdot != ' ') && (tdot != e->current_buffer));tdot--);
  if (tdot != e->current_buffer) tdot++;
  strcpy(tstring, tdot);

  path_var = getenv("PATH");
  if (path_var == NULL) {		 	 /* JJD 3-89 added test */
    write(1,"\07",1);
    return OK;
  }
  else {
  tchar = path_var;				 /* skip the first :  */
/* JJD: this assumes a "normal" PATH, which it is 99.99% likely to be */
  if (path_var[0] == ':')  tchar++;		 /* JJD 3-89 added if */
  while(*tchar != '\0'){
    count=0;					 /* JJD 3-89 stay in bounds*/
    while ((*tchar != ':') && (*tchar != '\0'))  d_name[count++] = *tchar++;
    if (*tchar == ':') tchar++;  
    d_name[count] = '\0';
    paths[num_dirs] = (char *) alloca (strlen(d_name) + 1);
    strcpy (paths[num_dirs], d_name);
    if (++num_dirs >= MAX_DIR_TO_SEARCH) {
      goto tomanydirs; /* JJD 3-89 forget the rest*/
    }
  }
tomanydirs:
/* now have num_dirs directories to search for the command in */
/* JJD 3-89 NOW CHECKS FOR EXECUTE PERMISSION and NOT A DIRECTORY,      */
/* 	    THEN SORTS IN ALPHA ORDER, LEAVING IN DUPLICATED (are rare) */

 current_search_directory = 0;		    /* JJD 3-89 changed <= to < */
 for (;current_search_directory<num_dirs;current_search_directory++){
    strcpy (d_name, paths[current_search_directory]); strcat (d_name, "/");
    if ((dir_pointer = opendir(&paths[current_search_directory][0])) != NULL){
      d_entry=readdir(dir_pointer);
      for (;d_entry != NULL;d_entry = readdir(dir_pointer)){
        strcpy (de_name, d_entry->d_name);
        if (strncmp(tstring, de_name, strlen(tstring)) == 0){
         if ((strcmp(".", de_name) != 0) &&
             (strcmp("..", de_name) != 0)) {   /* JJD 3-89 del . .. */
	  strcpy (t_name, d_name); strcat (t_name, de_name);
	  if (access (t_name, X_OK) == 0) {	    /* executable */
 	   if (stat(t_name,&buf) == 0){
 	    if ((buf.st_mode & S_IFMT) != S_IFDIR){ /* not a dir */
	     f_name[match] = (char *) alloca (strlen(de_name) + 1);
	     strcpy(f_name[match],de_name);
	     if (++match >= MAX_FILES_TO_SAVE) {
	        goto tomanyfiles; /* JJD 3-89 above */
	     }
	    }
	   }
	  }
	 }
	}
      }
    }
tomanyfiles:
    if (dir_pointer != NULL) closedir(dir_pointer);
  }
  if (match == 0) {
    write(1,"\07",1);
    return OK;
  }
  			/* else we found at least 1  match */      
  else {
    ssort (f_name, match); /* JJD 3-89, alpha */
    cmatch = 0;
again:	output_string_length = 0;
    if (!past_first) length=strlen(tstring);
    else {
      if (cmatch == 0) length=strlen(f_name[match-1]);
      else length=strlen(f_name[cmatch-1]);
    }
    for (; length; --length)
      tputs (cursor_left, ONE_LINE,append_to_output_string);
/* set current dot to beginning of the file name and copy in the filename*/ 
    e->dot = tdot;
    strcpy(e->dot,f_name[cmatch]);

/* JJD: WARNING: prev strcpy could overflow ed_buff, should test */
/* JJD: WARNING: next dot reset could overflow ed_buff, as above */
			    /* reset dot to the end of the line */	

    if (e->mark > e->dot) e->mark += strlen (f_name[cmatch]); /* JJD 3-89 */
    e->dot += strlen(f_name[cmatch]);
    display_string_into_output_string (f_name[cmatch]);
    if (cmatch == 0) length=strlen(f_name[match-1])-strlen(f_name[cmatch]);
    else length=strlen(f_name[cmatch-1])-strlen(f_name[cmatch]);
    for (count=0;count<length;count++){
	  display_string_into_output_string(" ");
	}
	for (count=0;count<length;count++){
	  tputs (cursor_left, ONE_LINE,append_to_output_string);
	}
	write (1, output_string, output_string_length);
	if (pred_mode) {				 /* JJD 2-89 added */
	        make_a_prediction (pred_buff);
		if (pred_buff[0]) display_pred_buffer (e);
	}
	
	READ(0,&chr,1);
	chr &= 127;					 /* JJD 2-89 added */
        if (pred_on_display) erase_pred_buffer (e);      /* JJD 2-89 added */
	if (chr == (char)28) {				 /* JJD 2-89 made ^\*/
	  past_first = 1;
	  if (cmatch < match-1) {
	    cmatch++;
	    goto again;
	  }
	  else {cmatch=0;goto again;}
	}
	else {
/* JJD: it would be better to ungetc and return */
          return_this = OK;				 /* JJD 2-89 added */
	  e->current_input_char = chr;
	  return_this = keymap[(int)chr][0](e); /* JJD 2-89 add return_this */
	  if (dir_pointer != NULL) closedir(dir_pointer); /* JJD 3-89 add if*/
	  return (return_this);		       /* JJD 2-89 add return_this */
	}
  }
  }
}


set_mark (e) ED_STRUCT *e; {
  e->mark = e->dot;	     /* JJD 3-89 mark intialized in set_up_buffers()*/
  e->current_ed_buff_ptr->mark = e->dot;	          /* JJD 3-89 added */
}

show_mark (e) ED_STRUCT *e; {
  int num_to_go;
  if (e->mark > e->dot){
    e->universal_argument = num_to_go = e->mark - e->dot;
    forward_char (e);
    sleep(1);						/* JJD 3-89 change */
    e->universal_argument = num_to_go;
    backward_char (e);
  }
  else if (e->mark < e->dot){
    e->universal_argument = num_to_go = e->dot - e->mark;
    backward_char (e);
    sleep(1);						/* JJD 3-89 change */
    e->universal_argument = num_to_go;
    forward_char (e);
  }
}

delete_region_to_killbuffer (e) ED_STRUCT *e; {

  int length;

  if (e->dot > e->mark){
    length = e->dot - e->mark;
    strncpy(e->kill_buffer, e->mark, length);
    e->kill_buffer[length] = '\0';
    e->universal_argument = length;
    backward_char(e);
    e->universal_argument = length;
    e->mark = e->dot;
    return delete_char (e);
  }
  if (e->mark > e->dot){
    length = e->mark - e->dot;
    strncpy(e->kill_buffer, e->dot, length);
    e->kill_buffer[length] = '\0';
    e->universal_argument = length;
    e->mark = e->dot;
    return delete_char (e);
  }
  return OK;					    /* JJD 3-89 added */
}


int strstr(look, lookin) char *look, *lookin;{
    int counter = 0;
    for (counter = 0; (counter < (strlen(lookin) - strlen(look))); counter++){
        if (strncmp(look, &lookin[counter], strlen(look)) == 0)
	    return(0);
    }
    return(1);
}

/*      
send_message(message)
char *message;
{
     ioctl (0, TIOCGETP, &new_stdin_sgttyb);
     ioctl (0, TIOCSETP, &old_stdin_sgttyb);
     printf ("recvd message:%s\n", message);
     ioctl (0, TIOCSETP, &new_stdin_sgttyb);
}
*/

ssort (v, n) char *v[]; int n; {  /* JJD: Shell Sort alla p.108 K&R C book */
	int gap, i, j; char *temp;
	for (gap = n/2; gap > 0; gap /= 2)
		for (i= gap; i < n; i++)
			for (j = i-gap; j >= 0; j -= gap) {
			    	if (strcmp(v[j], v[j+gap]) <= 0) break;
				temp = v[j];
				v[j] = v[j+gap];
				v[j+gap] = temp;
			}
}
