static char rcsid[] = "@(#)$Header: /pdsrc/Local/RCS/ranlib.c,v 1.3 90/04/24 14:05:00 root Exp $";

/*
 * (C) Copyright 1990 Stephen A. Bleazard <Steve@Robobar.Co.Uk>
 * 
 * Permission is granted to redistribute this program and any derivatives
 * thereof in source or binary form, for any purpose, including commercial
 * use, provided that this copyright message is retained in the source code
 * and is reproduced in full in any documentation that accompanies such
 * redistribution.  Source code redistribution is encouraged, but is not
 * mandatory.  The rcsid string above must be retained unmodified in any 
 * redistributed binary.
 *
 * NO WARRANTY:  This software is licensed free of charge without any claim
 * regarding its fitness for any purpose.  The Licensor cannot accept
 * responsibility for any damage arising from the use or inability to use
 * this software for any purpose.
 */

/*
 * This is a replacement ranlib(CP) for SCO Xenix 386 System V.
 * I have only tested it on Xenix 2.3.2 with the 2.3 Development System:
 * your mileage may vary.
 *
 * This replacement ranlib is required when either:
 *
 *	a) you do not have a SCO Development system, but are hacking along
 *	   with PD, free, and GNU development tools,
 *
 * or	b) your library has external identifiers more than 40 characters
 *	   long, which is not uncommon if you happen to be using g++,
 *	   or indeed, most C++ compilers.
 *
 * Note that Xenix's ld seems perfectly happy to link objects with long
 * identifiers, but the utilities like ranlib and nm barf on them under some
 * circumstances which I am not going to bother to try to enumerate here
 * or anywhere. ld -r does NOT cope with long identifiers.  You Lose.
 *
 * CAVEAT: The Xenix struct ar_hdr as defined in /usr/include/ar.h depends
 * upon a Microsoft specific bodge (#pragma pack(2)) to force alignment
 * of a long on a 2 byte boundary.  This is not a problem if you are
 * compiling this ranlib with the Microsoft compiler.  Those wishing
 * to use my port of GCC to Xenix will require a version patched to understand
 * #pragma pack().  Such version can be identified when
 * 	$ /usr/local/lib/gcc-cc1 -version -quiet < /dev/null
 * reports "#pragma pack() support included", which was not available with
 * my original set of patches for GCC, and is in any case a non-compulsory
 * compile-time option.
 *
 * Enjoy,
 * Steve.
 */

/*
 * $Log:	ranlib.c,v $
 * Revision 1.3  90/04/24  14:05:00  root
 * Removed annoying ANSI prototypes.
 * fixed array memname size
 * 
 * Revision 1.2  90/04/23  07:56:07  root
 * fixed argument to fseek at line 262.
 * fixed -v message
 * 
 * Revision 1.1  90/04/23  07:50:18  root
 * Initial revision
 * 
 */

#include <stdio.h>
#include <varargs.h>
#include <string.h>
#include <ar.h>

typedef struct symbol_t {
	char *name;
	long mempos;
	struct symbol_t *next;
} Symbol;

#undef   i386
#define  XARMAG		0177545
#define  HDRSIZE	3
#define  NOERROR	0
#define  NODATA		1
#define  ILLSTRLEN	2
#define  EOFERR		3
#define  OMFNAMELENGTH  127
#define  MPUBDEF	0x90
#define  MPUB386	0x91


FILE *objfile;
int objerror = NOERROR;
int verbose = 0;	/* Say what we're doing */
int trace = 0;		/* Say EVERYTHING we're doing */
long ar_lib_start;	/* where the actual lib stuff starts */
Symbol *symtable, *current_sym;

usage()
{
	fprintf(stderr, "usage: ranlib [-v] [-t] archive...\n");
}

void vmsg(fmt, va_alist)
char *fmt;
va_dcl
{
	va_list args;

	va_start(args);
	if (verbose)
		vfprintf(stderr, fmt, args);
	va_end(args);
}

void tmsg(fmt, va_alist)
char *fmt;
va_dcl
{
	va_list args;

	va_start(args);
	if (trace)
		vfprintf(stderr, fmt, args);
	va_end(args);
}


void error(fmt, va_alist)
char *fmt;
va_dcl
{
	va_list args;

	va_start(args);
	fprintf(stderr, "error: ");
	vfprintf(stderr, fmt, args);
	va_end(args);
}

main(argc, argv)
int argc;
char **argv;
{
	int opt;
	extern optind;

	if (argc < 2)
	{
		usage();
		exit(1);
	}

	while ((opt = getopt(argc, argv, "vt")) != EOF)
	{
		switch (opt)
		{
		case 't':
			trace = 1;
			/*FALLTHROUGH*/
		case 'v':
			verbose = 1;
			vmsg("ranlib version:\n    %s\n", rcsid + 4);
			vmsg("Please report bugs to steve@robobar.co.uk.\n");
			break;
		case '?':
			usage();
			exit(1);
			break;
		}
	}
	tmsg("Options selected: %s%s\n", trace ? "-t " : "",
					 verbose ? "-v " : "");

	for ( ; optind < argc; optind++ )
		ranlib(argv[optind]);
	exit(0);
}

int rdbytes(buff, count)
char *buff;
int count;
{
	int retval;

	if (retval = (fread(buff, 1, count, objfile) != count))
		objerror = EOFERR;
	return !retval;
}

int checkcnt(from, count)
int *from, count;
{
	if ((*from - 1) < count)
	{
		objerror = NODATA;
		return 0;
	}
	*from -= count;
	return 1;
}


long rdvint(count, reclen)
int count;
int *reclen;
{
	long val = 0;
	unsigned char b;
	int i = 0;

	if (!checkcnt(reclen, count))
		return -1;
	while (i < count)
	{
		rdbytes(&b, 1);
		val = val | ((long)b << ( 8 * i));
		i++;
	}
	return val;
}

long rdoffset(i386, reclen)
int i386;
int *reclen;
{
	return rdvint(i386 ? 4 : 2, reclen);
}

unsigned int rdword(reclen)
int *reclen;
{
	return (unsigned int)rdvint(2, reclen);
}

unsigned char rdbyte(reclen)
int *reclen;
{
	unsigned char b;

	if (!checkcnt(reclen, 1))
		return 0;
	rdbytes(&b, 1);
	return b;
}

unsigned int rdindex(reclen)
int *reclen;
{
	unsigned char b, b1;

	b = rdbyte(reclen);
	if (b < 128)
		return b;
	b1 = rdbyte(reclen);
	return (((unsigned int)b & 0x7f) << 8) + b1;
}

void rdomfstr(name, reclen)
char *name;
int *reclen;
{
	unsigned char l;

	l = rdbyte(reclen);
	if (l > OMFNAMELENGTH)
	{
		name[0] = '\0';
		objerror = ILLSTRLEN;
		fseek(objfile, (long) *reclen, 1);
		return;
	}
	if (!checkcnt(reclen, l))
	{
		name[0] = '\0';
		return;
	}
	rdbytes(name, l);  name[l] = '\0';
}

pubdef(i386, reclen, pos)
int i386;
int reclen;
long pos;
{
	unsigned int grpindex, segindex, framenum;

	grpindex = rdindex(&reclen);
	segindex = rdindex(&reclen);
	if (grpindex == 0 && segindex == 0)
		framenum = rdword(&reclen);

	while (reclen > 1)
	{
		char symbol_name[OMFNAMELENGTH+2];
		unsigned long offset; 
		int type;

		rdomfstr(symbol_name, &reclen);
		offset = rdoffset(i386, &reclen);
		type = rdindex(&reclen);
		
		if (strncmp(symbol_name, "  ", 2) == 0)
		{
			tmsg("    skipping %s @ %#x\n", symbol_name, pos);
		}
		else
		{

			tmsg("    adding %s @ %#x\n", symbol_name, pos);
			current_sym->next = (Symbol *)malloc(sizeof(Symbol));
			current_sym = current_sym->next;
			current_sym->name=(char *)malloc(strlen(symbol_name)+1);
			strcpy(current_sym->name, symbol_name);
			current_sym->mempos = pos;
		}
	}
	fseek(objfile, (long)reclen, 1);
}


readsymbols(fp, pos, size)
FILE *fp;
long pos, size;
{
	unsigned char buff[HDRSIZE+2];
	unsigned int reclen, rectype;
	long startpos;
	long ftell();

	objfile = fp;  startpos = ftell(fp);  objerror = NOERROR;

	while (((ftell(fp) - startpos) < size) && rdbytes(buff, HDRSIZE))
	{
		int rectype, reclen;

		rectype = buff[0];
		reclen = buff[1] | ((int)buff[2] << 8);
		switch (rectype)
		{
		    case MPUBDEF:
			pubdef(0, reclen, pos);
			break;
		    case MPUB386:
			pubdef(1, reclen, pos);
			break;
		    default:
			fseek(objfile, (long)reclen, 1);
			break;
		}

		if (objerror != NOERROR)
		{
			error("invalid object file format\n");
			return;
		}
	}
}

copy_old_ar_to_new(oldar_fp, newar_fp)
FILE *oldar_fp, *newar_fp;
{
	char buffer[BUFSIZ];
	int size;

	fseek(oldar_fp, ar_lib_start, 0);
	while ((size = fread(buffer, 1, BUFSIZ, oldar_fp)) != 0)
		fwrite(buffer, 1, size, newar_fp);
}

typedef Symbol *TablePtr;

static void merge(h1, t1, h2, t2, precedes)
TablePtr *h1, *t1, h2, t2;
int (*precedes)();
{
	TablePtr saveTail, lop, prevlop;


#	define	invert	{ TablePtr h;\
		h = lop;  lop = h2;  h2 = h; h = *t1;  *t1 = t2;  t2 = h; }

	saveTail = t2->next;  lop = *h1;
	if ((*precedes)(h2, *h1))
	{
		invert
		*h1 = lop;
	}
	while (lop != *t1)
	{
		prevlop = lop;  lop = lop->next;
		if ((*precedes)(h2, lop))
		{
			prevlop->next = h2;
			invert
		}
	}
	(*t1)->next = h2;
	*t1 = t2;
	t2->next = saveTail;
}

static void localsort(maxseqlen, head, tail, precedes)
int maxseqlen;
TablePtr *head, *tail;
int (*precedes)();
{
	TablePtr nexthead, nexttail;
	int length;

	length = 1;  *tail = *head;
	nexthead = (*tail)->next;
	while ((length < maxseqlen) && (nexthead != (TablePtr)NULL))
	{
		localsort(length, &nexthead, &nexttail, precedes);
		merge(head, tail, nexthead, nexttail, precedes);
		nexthead = (*tail)->next;
		length *= 2;
	}
}

void chainsort(head, precedes)
TablePtr *head;
int (*precedes)();
{
	TablePtr finaltail;

	if ((*head)->next != (TablePtr)NULL)
		localsort(0x7fff, head, &finaltail, precedes);
}

static int lesser(p1, p2)
TablePtr p1, p2;
{
	return (strcmp(p1->name, p2->name) < 0);
}

write_new_ar(oldar_fp, name, symtable)
FILE *oldar_fp;
char *name;
Symbol *symtable;
{
	static char template[] = "ranXXXXXX";
	char *path;
	Symbol *current;
	unsigned short symbolCount;
	long symtableSize, relocationFactor;
	FILE *fp;
	unsigned short magic = XARMAG;
	struct ar_hdr sym_hdr;
	long time();
	long ftell();
	
	mktemp(template);
	if (strchr(name, '/') != NULL)	/* Has a path */
	{
		char *p, *tmpname;
		
		tmpname = (char *)malloc(strlen(name)+1);
		strcpy(tmpname, name);
		p = strrchr(tmpname, '/');  *p = '\0';
		path = (char *)malloc(strlen(tmpname) + strlen(template) + 5);
		sprintf(path, "%s/%s", tmpname, template);
		free(tmpname);
	}
	else
	{
		path = (char *)malloc(strlen(template) + 5);
		sprintf(path, "./%s", template);
	}
	tmsg("creating %s\n", path);

	chainsort(&symtable, lesser);
	current = symtable;  symbolCount = 0;  symtableSize = 2;
	while (current != NULL)
	{
		symtableSize += strlen(current->name) + 1 + 4;
		symbolCount++;
		tmsg("%s %#lx\n", current->name, current->mempos);
		current = current->next;
	}
	relocationFactor = symtableSize + sizeof(struct ar_hdr);
	if (relocationFactor & 1)
		relocationFactor++;
	relocationFactor -= ar_lib_start - 2;
	tmsg("adding %d symbols, %#lx(%ld) bytes, ", symbolCount, symtableSize, symtableSize);
	tmsg("relocation factor %#lx(%ld)\n", relocationFactor, relocationFactor);

	current = symtable;
	while (current != NULL)
	{
		current->mempos += relocationFactor;
		tmsg("%s %#lx\n", current->name, current->mempos);
		current = current->next;
	}

	if ((fp = fopen(path, "w")) == NULL)
	{
		fprintf(stderr,"ranlib: cannot open %s\n", path);
		exit(1);
	}
	fwrite((void *)&magic, sizeof(unsigned short), 1, fp);
	strncpy(sym_hdr.ar_name, "__.SYMDEF", 14);
	sym_hdr.ar_date = time((long *)0);
	sym_hdr.ar_uid = getuid();
	sym_hdr.ar_gid = getgid();
	sym_hdr.ar_mode = 0106644;
	sym_hdr.ar_size = symtableSize;
	fwrite((void *)&sym_hdr, sizeof(struct ar_hdr), 1, fp);

	fwrite((void *)&symbolCount, sizeof(unsigned short), 1, fp);
	current = symtable;
	while (current != NULL)
	{
		unsigned char len;

		len = (unsigned char)strlen(current->name);
		fwrite((void *)&len, 1, 1, fp);
		fwrite(current->name, len, 1, fp);
		fwrite((void *)&current->mempos, sizeof(long), 1, fp);
		current = current->next;
	}

	if (ftell(fp) & 1)
	{
		char nl = 0; 
		
		fwrite(&nl, 1, 1, fp);
	}
	copy_old_ar_to_new(oldar_fp, fp);
	fclose(fp);

	unlink(name);
	link(path, name);
	unlink(path);
}

ranlib(name)
char *name;
{
	FILE *fp;
	struct ar_hdr hdr;
	unsigned short magic = 0;
	long memoffset, ftell();
	int memcount;

	if ((fp = fopen(name, "r")) == NULL)
	{
		fprintf(stderr,"ranlib: cannot open %s\n", name);
		exit(1);
	}
	vmsg("processing %s...", name);
	tmsg("\n");

	if ((fread((void *)&magic, sizeof(unsigned short), 1, fp) != 1) ||
	    (magic != XARMAG))
	{
		error("%s not in archive format\n", name);
		return;
	}

	symtable = current_sym = (Symbol *)malloc(sizeof(Symbol));
	memoffset = ftell(fp);  memcount = 0;  ar_lib_start = 2;

	while (fread((void *)&hdr, sizeof(struct ar_hdr), 1, fp) == 1)
	{
		char memname[15];

		memname[14] = '\0';  strncpy(memname, hdr.ar_name, 14);
		vmsg("%s ", memname);
		tmsg("(pos = %#x, size = %ld)\n", memoffset, hdr.ar_size);
		if ((strcmp(memname, "__.SYMDEF") == 0) && !memcount)
		{
			ar_lib_start = memoffset + sizeof(struct ar_hdr)
				       + hdr.ar_size;
			if (ar_lib_start & 1)
				ar_lib_start++;
			tmsg("%s ", memname);
			vmsg("(skipped) ");
			tmsg("\n");
		}
		else
			readsymbols(fp, memoffset, hdr.ar_size);

		memcount++;
		memoffset += sizeof(struct ar_hdr) + hdr.ar_size;
		if (memoffset & 1) memoffset++;
		fseek(fp, memoffset, 0);
	}
	current_sym->next = NULL;
	current_sym = symtable;  symtable = symtable->next;  free(current_sym);

	write_new_ar(fp, name, symtable);
	fclose(fp);

	for (current_sym = symtable; current_sym != NULL;)
	{
		Symbol *refuse;

		refuse = current_sym;  current_sym = current_sym->next;
		free(refuse);
	}
	vmsg("\n");
}
