/* Public domain. */

#include <stdio.h>
#include <signal.h>
#include <errno.h>
extern int errno;
#include "sessutil.h"
extern unsigned short getuid();

main(argc,argv)
int argc;
char *argv[];
{
 struct pty_session ps;
 int uid;

 uid = getuid();

 if (pty_get_sess(0,uid,&ps) == -1)
  {
   (void) fputs("reconnect: fatal: cannot find session\n",stderr);
   (void) exit(1);
  }
 if (ps.uid != uid)
  {
   (void) fputs("reconnect: fatal: you don't own session\n",stderr);
   (void) exit(1);
  }
 if (argv[1])
   if (pty_get_rebyext(argv[1][0],argv[1][1],uid) == -1)
    {
     (void) fputs("reconnect: fatal: cannot find reconnector\n",stderr);
     (void) exit(1);
    }
 if (argv[1])
  {
   if (pty_set_sig(argv[1][0],argv[1][1],uid,&ps) == -1)
    {
     (void) fputs("reconnect: fatal: cannot set reconnector\n",stderr);
     (void) exit(1);
    }
   (void) printf("reconnect: %c%c set, will reconnect after %c%c drops\n",
		 argv[1][0],argv[1][1],ps.ext1,ps.ext2);
  }
 else
  {
   if (pty_unset_sig(uid,&ps) == -1)
    {
     (void) fputs("reconnect: fatal: cannot unset reconnector\n",stderr);
     (void) exit(1);
    }
   (void) printf("reconnect: unset, won't reconnect after %c%c drops\n",
		 ps.ext1,ps.ext2);
  }
 (void) exit(0);
}
