/* Copyright 1990, Daniel J. Bernstein. All rights reserved. */

#ifndef PTY_TTY_H
#define PTY_TTY_H

#include "config.h"
#include <sgtty.h>

struct ttymodes
 {
  int di;
  struct sgttyb sg;
  struct tchars tc;
  long lb;
  struct ltchars lt;
#ifdef TTY_WINDOWS
  struct winsize ws;
#endif
#ifdef TTY_AUXCHARS
  struct auxchars au;
#endif
 }
;

extern int tty_getctrl();
extern tty_setexcl(/* int fd */);
extern tty_setpgrp(/* int fd; int pg; */);
extern tty_dissoc(/* int fd */);
extern tty_getmodes(/* int fd; s ttymodes *tmo */);
extern tty_setmodes(/* int fd; s ttymodes *tmo */);
extern tty_modifymodes(/* int fd; s ttymodes *tmonew; s ttymodes *tmoold */);

/* The following don't do any ioctls; they just mangle internal ttymodes. */

extern void tty_copymodes(/* s ttymodes *tmonew; s ttymodes *tmoold */);
extern void tty_copywin(/* s ttymodes *tmonew; s ttymodes *tmoold */);
extern void tty_charmode(/* s ttymodes *tmo */);
extern void tty_mungemodes(/* s ttymodes *tmo;cbreak;new;echo;crmod;raw;crt */);
extern void tty_initmodes(/* s ttymodes *tmo;cbreak;new;echo;crmod;raw;crt */);

#endif
