/* Copyright 1990, Daniel J. Bernstein. All rights reserved. */

#ifndef PTY_SIG_H
#define PTY_SIG_H

#include "config.h"
#include <signal.h>

typedef void (*sig_handler)();
typedef SIGRET_TYPE (*sig_syshandler)();

extern void nothing();

#define SIGNUM 32
typedef int sig_num;

extern void sig_init();
extern void sig_restore();

extern void sig_ignore();
extern void sig_default();
extern void sig_handle();

#ifdef SIGINTERRUPT
extern void sig_interrupt();
#endif

extern void sig_sethandler();

extern void sig_startring();
extern void sig_stopring();

#endif
