/* Copyright 1990, Daniel J. Bernstein. All rights reserved. */

#ifndef PTY_CONFIG_H
#define PTY_CONFIG_H

/* It is recommended that you make local changes in the Makefile, */
/* except for feature control, which is best done here. */

/* Section 1: Feature control. */
/* Section 2: Pseudo-terminal pathnames. */
/* Section 3: Logging. */
/* Section 4: Protection. */
/* Section 5: Other. */
/* Section 6: Sanity checks. */

/* Each section starts with the necessary defines and finishes with */
/* an explanation. */


/* Section 1: Feature control. */

/*#define MUST_UTMP  /* force utmp logging */
/*#define NO_UTMP  /* prohibit utmp logging */
/*#define MUST_WTMP  /* force utmp logging */
/*#define NO_WTMP  /* prohibit wtmp logging */
/*#define MUST_SESSION  /* force disconnectable sessions (what for?) */
/*#define NO_SESSION  /* prohibit disconnectable sessions */
/*#define MUST_CHOWN  /* force changing pty owner */
/*#define NO_CHOWN  /* prohibit changing pty owner */
/*#define NO_FDPASSING  /* prohibit file descriptor passing */
/*#define NO_UNIXSOCKS  /* prohibit use of UNIX-domain sockets */
#define TTY_WINDOWS  /* have winsize, WINCH, etc. in tty (4.3) */
/*#define TTY_AUXCHARS  /* have systat, e.g. with ^T, in tty */
#define DESPERATE_ALARMS  /* if NDELAY may not be enough */
#define DONT_NDELAY  /* might as well, with DESPERATE_ALARMS */
#define SIGINTERRUPT  /* if you have siginterrupt() (4.3) */
#define USLEEP  /* if you have usleep() */

/* These are mostly self-explanatory. If your system doesn't support */
/* some feature, you should prohibit it by defining NO_WHATEVER. */

/* Any BSD 4.2 or 4.3 system should have UNIXSOCKS and FDPASSING. Look */
/* for /sys/h/un.h to see if you have UNIX-domain sockets. Look for */
/* msg_accrights in the man page for recvmsg() to see if you have */
/* file desriptor passing. (Sometimes fd passing is available but buggy, */
/* as it's a relatively new, powerful, and rarely exploited feature. In */
/* this case you should define NO_FDPASSING.) In the current version, */
/* NO_UNIXSOCKS implies NO_FDPASSING and NO_SESSION; see Section 6. */

/* For TTY_WINDOWS, look for struct winsize in /usr/include/sgtty.h. */
/* For TTY_AUXCHARS, look for struct auxchars in the same place. */
/* All BSD 4.3 systems should have winsize; auxchars isn't so common. */

/* Opening the slave side of a pty without a master should hang the */
/* process. Normally, opening with NDELAY gets around this effect; */
/* opening the slave side first is necessary for some security checks. */
/* On some systems, however, NDELAY doesn't do its job; you must */
/* define DESPERATE_ALARMS to forcibly interrupt each open(). There */
/* shouldn't be any problem in leaving this (and DONT_NDELAY) defined */
/* anyway. (On a few systems, you must have DONT_NDELAY for -xn.) */

/* Define SIGINTERRUPT if you have siginterrupt() (i.e., if you're */
/* running BSD 4.3). Without this call, there's no correct way to do */
/* per-process nonblocking I/O, and pty may block when it shouldn't */
/* (namely, when it has N bytes to write to the output, the output is */
/* a blocking pipe with M bytes of space, and N > M > 0). If you define */
/* SIGINTERRUPT, pty will take some extra effort to never, ever, ever */
/* block when it doesn't have to. (See OUTBUFSIZE, below.) */

/* Define USLEEP if you have usleep(). */


/* Section 2: Pathnames. */

#ifndef PTYDIR
#define PTYDIR "/usr/etc/pty"
#endif
#ifndef DEVMTY
#define DEVMTY "/dev/pty  "
#endif
#ifndef DEVSTY
#define DEVSTY "/dev/tty  "
#endif
#ifndef PTY1
#define PTY1 "pqrstuvwxyzabcdefghijklmno"
#endif
#ifndef PTY2
#define PTY2 "0123456789abcdef"
#endif
#ifndef TTYNAMELEN
#define TTYNAMELEN 30
#endif

/* PTYDIR is where pty sessions store their information. You should */
/* create it mode 700, owner pty, group irrelevant. You must define */
/* PTYDIR as something even if you don't allow sessions. If you don't */
/* set up PTYDIR at all but you do allow sessions, pty will switch */
/* out of setuid after grabbing a pty, then set up session information */
/* in the user's home directory. This isn't totally secure but it's */
/* at least partially workable. */

/* DEVMTY and DEVSTY are the basenames of the master and slave ptys */
/* respectively. They must each end with two spaces, filled in with */
/* characters from PTY1 and PTY2 respectively. If your ptys aren't */
/* labelled by this convention, I'm surprised you have anything working; */
/* either set up a new pty bank with normal names or change the pty code */
/* that allocates ptys. Note that convention allows you to only have */
/* some of a pty bank, as long as one of them is there; the first letter */
/* in PTY2 must indicate that one. */

/* The order of PTY1 and PTY2 is the pty searching order. pty allows */
/* (and, as a break from tradition, uses by default) random searches, */
/* starting from random spots in PTY1 and PTY2 rather than the beginning. */
/* This has several good effects, although you may think utmp will look */
/* a bit ugly. */

/* If you want to gradually convert your system to using this program, */
/* PTY1 and PTY2 shouldn't reference all your ptys. Instead, pick a */
/* large enough subset of your ptys to be usable, and try things out */
/* with just those. If everything works and you like pty's capabilities, */
/* remove your old ptys, or recompile pty to reference all of them. */

/* TTYNAMELEN should be the maximum length of a tty (not just pty!) */
/* name. TTYNAMELEN shouldn't have to be there; it's used to work */
/* around some fundamental failures in the current tty/pty model. */


/* Section 3: Logging. */

#ifndef PTYUTMP_FILE
#define PTYUTMP_FILE "/etc/utmp"
#endif
#ifndef PTYWTMP_FILE
#define PTYWTMP_FILE "/usr/adm/wtmp"
#endif
#ifndef PTYUTMP_OFFSET
#define PTYUTMP_OFFSET 5
#endif
#ifndef PTYWTMP_OFFSET
#define PTYWTMP_OFFSET PTYUTMP_OFFSET
#endif
#ifndef PTYUTMP_HOST
#define PTYUTMP_HOST "pty"
#endif
#ifndef PTYWTMP_HOST
#define PTYWTMP_HOST PTYUTMP_HOST
#endif
#ifndef PTYUTMP_SWHOST
#define PTYUTMP_SWHOST PTYUTMP_HOST
#endif
#ifndef PTYWTMP_SWHOST
#define PTYWTMP_SWHOST "pty-sessuser"
#endif

/* These are straightforward. FILE is where you want the logs. utmp and */
/* wtmp are about as sensible as /etc/passwd and unfortunately just as */
/* popular; typically they're in /etc/utmp and /usr/adm/wtmp, and the */
/* utility programs in this package support that convention. (wtmp logs */
/* all ins and outs. utmp only has one entry per line, namely the last */
/* wtmp entry for it.) OFFSET is the number of chars from a pty extension */
/* to remove from a log entry; usually this is 5, to make /dev/ttyxx into */
/* ttyxx. Finally, HOST is the name that you want in the ``remote'' field */
/* of the log; that field is rather illogical, but it's there. */

/* SWHOST is a variant of HOST, for what's logged upon a session uid */
/* switch. */

/* If you're using pty under telnet/login/whatever, which do their own */
/* utmp and wtmp handling, then pty will usually have -xUW, so these */
/* defines aren't too important. Except for SWHOST, which is necessary */
/* for sessuser's action to make sense. */


/* Section 4: Protection. */

#ifndef USEDPTYMODE
#define USEDPTYMODE 0600
#endif
#ifndef UNUSEDPTYMODE
#define UNUSEDPTYMODE 0600
#endif
#ifndef PTYOWNER
#define PTYOWNER euid
#endif
#ifndef PTYGROUP
#define PTYGROUP 4
#endif

/* pty -xc will change the owner of the pty back to PTYOWNER after the */
/* child has exited. This should be euid, for the effective uid of the */
/* pty process. If a user runs pty as himself, he won't get to change */
/* the owner of the pseudo-terminal in the first place. */

/* PTYGROUP should be the ``tty'' group in /etc/group, normally 4. All */
/* ptys and ttys should be in this group at all times. */

/* USEDPTYMODE is the mode of ptys while they're being used. 600 is a */
/* good choice; it means messages off. If you want msgs y by default, */
/* try 620. Don't use the old 622: it's exceedingly insecure. */

/* UNUSEDPTYMODE is the mode of ptys while they're unused. Traditionally */
/* this would be 666, so that any process needing a pty can just grab */
/* one. However, this leads to quite a few security holes. If you have */
/* lots of programs like emacs that really, really, really want to use */
/* ptys and don't support this interface, try 0660, and make those */
/* programs setgid tty. Otherwise, stick to 0600. */


/* Section 5: Other. */

#ifndef SIGRET_TYPE
#define SIGRET_TYPE int
#endif

#ifndef OUTBUFSIZE
#define OUTBUFSIZE 16384
#endif

#ifndef GENERIC
#define GENERIC char
#endif

#ifdef TTY_AUXCHARS
#define USESTAT
#endif

/* SIGRET_TYPE is the type returned by signal handlers. Logically, it */
/* should be void, but C and signals were around before void was. */

/* OUTBUFSIZE is the size of the extra buffers provided by pty, both */
/* for data coming in to the pseudo-terminal and for data going out. */

/* It should be possible to cast any pointer to a GENERIC * pointer */
/* and back. Again, void makes the most sense and is the best choice */
/* under ANSI, but char is correct and much more portable. */

/* Setting USESTAT is necessary for systems supporting auxchars. */


/* Section 6: Sanity checks. */

#ifdef NO_UNIXSOCKS
#define NO_FDPASSING
#define NO_SESSION
#endif

#ifdef NO_SESSION
#ifdef MUST_SESSION
#undef MUST_SESSION
#endif
#endif

#ifdef NO_UTMP
#ifdef MUST_UTMP
#undef MUST_UTMP
#endif
#endif

#ifdef NO_WTMP
#ifdef MUST_WTMP
#undef MUST_WTMP
#endif
#endif

#ifdef NO_CHOWN
#ifdef MUST_CHOWN
#undef MUST_CHOWN
#endif
#endif

#endif
