/* Public domain. */
#include <stdio.h>
#include <utmp.h>
#include <strings.h>
#include <time.h>
extern char *ttyname();
#define PTYUTMP_FILE "/etc/utmp"

main(argc,argv)
int argc;
char *argv[];
{
 FILE *fi;
 struct utmp ut;
 char fn[100];
 char ttyn[100];
 char hostname[120];
 int whoami = 0;
 
 if (argc > 3) exit(0);
 if (argc > 2)
  {
   whoami = 1;
   if (!isatty(0))
    {
     fprintf(stderr,"who: Not a tty\n");
     exit(1);
    }
   (void) strcpy(ttyn,ttyname(0) + 5);
   (void) gethostname(hostname,120);
  }
 if (argc == 2)
   (void) strncpy(fn,argv[1],100);
 else
   (void) strncpy(fn,PTYUTMP_FILE,100);

 if ((fi = fopen(fn,"r")) == NULL)
  {
   (void) sprintf(hostname,"who: %s",fn);
   (void) perror(hostname);
   (void) exit(1);
  }

 while (fread((char *) &ut,sizeof(ut),1,fi))
  {
   if (ut.ut_name[0] || (argc > 1))
     if ((!whoami) || (!strncmp(ut.ut_line,ttyn,8)))
      {
       if (whoami)
	 (void) printf("%s!",hostname);
       (void) printf("%-8.8s %-8.8s%-12.12s",ut.ut_name,ut.ut_line,
		     asctime(localtime(&ut.ut_time)) + 4);
       if (ut.ut_host[0])
	 (void) printf("	(%.16s)",ut.ut_host);
       (void) printf("\n");
      }
  }
 (void) fclose(fi);
 (void) exit(0);
}
