/* Public domain. */

#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <utmp.h>
#include <pwd.h>
#include <signal.h>
#include <strings.h>
#include "sessutil.h"
extern unsigned short getuid();
extern unsigned short geteuid();
#define PTYUTMP_FILE "/etc/utmp"

main()
{
 struct pty_session ps;
 int uid;
 int euid;
 register FILE *fi;
 struct utmp ut;
 struct stat st;
 struct passwd *pw;
 char *username;

 uid = getuid();
 euid = geteuid();

 if (pty_get_sess(0,euid,&ps) == -1) /* i.e., as root */
  {
   (void) fputs("sessuser: fatal: cannot find session\n",stderr);
   (void) exit(1);
  }
 if (fstat(0,&st) == -1)
  {
   (void) fputs("sessuser: fatal: cannot stat tty\n",stderr);
   (void) exit(1);
  }
 if (st.st_uid != uid)
  {
   (void) fputs("sessuser: fatal: you don't own tty\n",stderr);
   (void) exit(1);
  }
 if (ps.slavepid != getppid())
  {
   (void) fputs("sessuser: fatal: not child of session slave\n",stderr);
   (void) exit(1);
  }
 if (!(pw = getpwuid(uid)))
  {
   (void) fputs("sessuser: fatal: cannot find your username\n",stderr);
   (void) exit(1);
  }
 username = pw->pw_name;
 if (!(fi = fopen(PTYUTMP_FILE,"r")))
  {
   (void) perror("sessuser: fatal: cannot open /etc/utmp");
   (void) exit(1);
  }
 else
   while (fread((char *) &ut,sizeof(ut),1,fi))
     if ((ut.ut_line[3] == ps.ext1) && (ut.ut_line[4] == ps.ext2)
       &&(ut.ut_line[5] == '\0'))
       if (!strncmp(ut.ut_name,username,8))
	{
	 ps.uid = uid;
	 if (pty_set_sess(0,uid,&ps) == -1)
	  {
           (void) fputs("sessuser: fatal: cannot set session\n",stderr);
           (void) exit(1);
	  }
	 if (kill(ps.masterpid,SIGUSR2) == -1)
	  {
           (void) fputs("sessuser: fatal: cannot communicate new user\n",stderr);
           (void) exit(1);
	  }
	 (void) fchown(0,euid,-1);
	 (void) exit(0);
	}
       else
	 (void) exit(1);
 (void) exit(1);
}
