/* Public domain. */

#include <stdio.h>
#include <strings.h>
#include "sessutil.h"
extern unsigned short getuid();

main(argc,argv)
int argc;
char *argv[];
{
 struct pty_session ps;
 int uid;
 char buf[100];
 int s;

 uid = getuid();

 if (pty_get_sess(0,uid,&ps) == -1)
  {
   (void) fputs("sessname: fatal: cannot find session\n",stderr);
   (void) exit(1);
  }
 if (ps.uid != uid)
  {
   (void) fputs("sessname: fatal: you don't own session\n",stderr);
   (void) exit(1);
  }
 if (ps.slavepid != getppid())
  {
   (void) fputs("sessname: fatal: not child of session slave\n",stderr);
   (void) exit(1);
  }
 if (argc == 1)
   if (pty_get_sessname(0,uid,buf,sizeof(buf)) == -1)
     (void) printf("session %c%c unnamed\n",ps.ext1,ps.ext2);
   else
     (void) printf("session %c%c: %s\n",ps.ext1,ps.ext2,buf);
 else
  {
   s = strlen(argv[1]) + 1;
   if (s > 100)
     s = 100;
   if (pty_set_sessname(0,uid,argv[1],s) == -1)
    {
     (void) fputs("sessname: fatal: renaming failed\n",stderr);
     (void) exit(1);
    }
  }
  
 (void) exit(0);
}
