/* Public domain. */

#include <stdio.h>
#include <signal.h>
#include <errno.h>
extern int errno;
#include "sessutil.h"
extern unsigned short getuid();

main(argc,argv)
int argc;
char *argv[];
{
 struct pty_session ps;
 int uid;

 uid = getuid();

 if (!argv[1])
  {
   (void) fputs("Usage: sesskill ext\n",stderr);
   (void) exit(1);
  }
 if (pty_get_sessbyext(argv[1][0],argv[1][1],uid,&ps) == -1)
  {
   (void) fputs("sesskill: fatal: cannot find session\n",stderr);
   (void) exit(1);
  }
 if (ps.uid != uid)
  {
   (void) fputs("sesskill: fatal: you don't own session\n",stderr);
   (void) exit(1);
  }
 if ((kill(ps.slavepid,0) != -1) || (errno != ESRCH))
  {
   /* If all goes wrong, this test could allow a denial of service */
   /* attack. Sigh. */
   (void) fputs("sesskill: fatal: session slave still alive\n",stderr);
   (void) exit(1);
  }
 if (kill(ps.masterpid,SIGXCPU) == -1)
  {
   (void) perror("sesskill: fatal: cannot kill session master");
   (void) exit(1);
  }
 (void) exit(0);
}
