/* Public domain. */

#include <stdio.h>
#include <signal.h>
#include "sessutil.h"
extern unsigned short getuid();

main()
{
 struct pty_session ps;
 int uid;

 uid = getuid();

 if (pty_get_sess(0,uid,&ps) == -1)
  {
   (void) fputs("sessname: fatal: cannot find session\n",stderr);
   (void) exit(1);
  }
 if (ps.uid != uid)
  {
   (void) fputs("sessname: fatal: you don't own session\n",stderr);
   (void) exit(1);
  }
 if (ps.slavepid != getppid())
  {
   (void) fputs("sessname: fatal: not child of session slave\n",stderr);
   (void) exit(1);
  }
 if (kill(ps.siglerpid,SIGUSR1) == -1)
  {
   (void) perror("sessname: fatal: cannot disconnect");
   (void) exit(1);
  }
 (void) exit(0);
}
