/* Copyright 1990, Daniel J. Bernstein. All rights reserved. */

#include "config.h"
#include "texts.h"

char *ptyauthor[] = {
"pty was written by Daniel J. Bernstein." ,
"Internet address: brnstnd@acf10.nyu.edu." ,
0 } ;

char *ptyversion[] = {
"pty version 3.001, August 21, 1990." ,
"Copyright (c) 1990, Daniel J. Bernstein." ,
"All rights reserved." ,
0 } ;

char *ptycopyright[] = {
"pty version 3.001, August 21, 1990." ,
"Copyright (c) 1990, Daniel J. Bernstein." ,
"All rights reserved." ,
"" ,
"I want this program to be distributed freely in original form." ,
"" ,
"Once you've received a legal copy of this program, you can use it." ,
"Forever. Nobody can take that right away from you. You can make changes" ,
"and backup copies for your use (or, if you're an organization, for the" ,
"use of everyone in the organization). You can distribute patches (though" ,
"not patched versions). You'd have all these rights even if I didn't tell" ,
"you about them." ,
"" ,
"I do grant you further rights, as detailed in the source package. Don't" ,
"worry about them unless you're planning to distribute further copies." ,
"" ,
"If you have questions about this program or about this notice, or if you" ,
"would like additional rights beyond those granted above, or if you have" ,
"a patch that you don't mind sharing, please contact me on the Internet" ,
"at brnstnd@acf10.nyu.edu." ,
0 } ;

char *ptywarranty[] = {
"Daniel J. Bernstein disclaims all warranties to the extent permitted" ,
"by applicable law. He is not and shall not be liable for any damages" ,
"arising from the use of this program. This disclaimer shall be governed" ,
"by the laws of the state of New York." ,
"" ,
"In other words, use this program at your own risk." ,
"" ,
"If you have questions about this program or about this disclaimer of" ,
"warranty, please feel free to contact me at brnstnd@acf10.nyu.edu on" ,
"the Internet." ,
0 } ;

char *ptyusage[] = {
"Usage: pty [ -qQve3EdDjJsStT0FACHUVW ] [ -fn ] [ -p[cCdDeEnNrRsS0] ]" ,
"           [ -x[cCeEnNoOrRsSuUwWxX ] program [ arg ... ]" ,
"Help:  pty -H" ,
0 } ;

char *ptyhelp[] = {
"pty runs a program under a pseudo-terminal session." ,
"pty -ACHUVW: print authorship notice, copyright notice, this notice," ,
"             short usage summary, version number, disclaimer of warranty" ,
"pty [-qQve3EdDjJsStT0F] [-fn] [-p[cCdDeEnNrRsS0]] [-x[cCeEnNoOrRsSuUwWxX]]" ,
"  program [arg...]: run program under a pseudo-terminal" ,
"Options processed l to r. Capitals turn things off. Here + means default." ,
"-q: quiet (nothing on stderr)   -e: leave fds 2 & 3    0=eSTp0  p0=pcrEN" ,
"+Q: normal level of verbosity   -3: leave fd 3 only    d=dJT D=Djt    d=>T" ,
"-v: complain about everything   +E: 2 & 3 both->pty    s=sxu S=SxU    s=>E" ,
"-d: we are detached    +j: job control    +t: change orig tty to char mode" ,
"+D: we have ctrl tty   -J: ignore stops   -T: leave orig tty alone" ,
"-s: session (allow disconnect & reconnect)   -fn: pass pty fds up fd n" ,
"+S: no session: disconnect will send HUP     +F: no -f" ,
"-p[cCdDeEnNrRsS]: set pty modes; defaults taken from original tty if -D" ,
"  c: cbreak, character mode  +n: change return to newline  +e: echo" ,
" +d: new line discipline      r: raw, no keyboard signals  +s: screen, crt" ,
"-x[cCeEnNoOrRsSuUwWxX]: security/experimental/extended, may be restricted" ,
"  c: change pty owner   e: pty's stderr write-only       x: set TIOCEXCL" ,
" +s: setuid, safer     +n: check if anyone has pty open  u: use /etc/utmp" ,
" +r: pick random pty    o: skip if anyone has pty open   w: use /etc/wtmp" ,
"If you have questions about or suggestions for pty, please feel free" ,
"to contact the author, Daniel J. Bernstein, at brnstnd@acf10.nyu.edu" ,
"on the Internet." ,
0 } ;
/* I still can't believe ptyhelp fits. :-) */
